

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateQuotaForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   11/14/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateQuotaForUser.sp,v $ $Id: UpdateQuotaForUser.sp,v 1.1.2.6 2020/11/20 23:58:55 sbhukar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateQuotaForUser')
BEGIN
	print '>>> Drop Stored Procedure: UpdateQuotaForUser <<<'
	drop procedure UpdateQuotaForUser
END
IF EXISTS (select * from GxQscripts where name='UpdateQuotaForUser')
	delete from GxQscripts where name = 'UpdateQuotaForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateQuotaForUser')
	delete from GXDBVersions where aliasname = 'UpdateQuotaForUser'
GO
print '... Creating Procedure: UpdateQuotaForUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateQuotaForUser
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(2048) = ''
--This SP calculates quota limit and quota usage for each user
-- 1st get list of all users where quota limit and quota usage needs to be updated
-- 2nd. compute quota limit and update the user property
-- 3rd. compute quota usage and update the user property
BEGIN TRY
DECLARE @startTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @bytesInGB BIGINT = 1024 * 1024 * 1024
DECLARE @transStarted INT = 0
IF object_id('tempdb.dbo.#userList') IS NOT NULL DROP TABLE #userList
CREATE TABLE #userList(
					t_uid INT NOT NULL,
					t_quotaLimit BIGINT DEFAULT 0,
					t_quotaUsage BIGINT DEFAULT 0,
					PRIMARY KEY (t_uid)
					)
IF object_id('tempdb.dbo.#UserQuotaLimit') IS NOT NULL DROP TABLE #UserQuotaLimit
CREATE TABLE #UserQuotaLimit(t_uid1 INT, t_gpid INT, t_quotaInherited INT, t_quotaEnforced INT, t_quotaSize BIGINT)
CREATE CLUSTERED INDEX UserQuotaLimit_t_uid1_t_gpid_Idx ON #UserQuotaLimit (t_uid1, t_gpid)
--------------------------------------------------------
-- 1st get list of all galaxy users and end users
--------------------------------------------------------
INSERT INTO #userList(t_uid)
SELECT DISTINCT U.id
FROM
UMUsers U WITH (NOLOCK) LEFT JOIN UMUsersProp UP WITH (NOLOCK) ON U.id = UP.componentNameId AND UP.attrName = 'ReComputeQuota' AND UP.cs_attrName = CHECKSUM(N'ReComputeQuota')
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0 AND U.id > 0 AND (UP.attrVal = '1' AND UP.modified <= @startTime OR UP.attrVal IS NULL)
--------------------------------------------------------
-- 2nd. compute quota limit and update the user property
--------------------------------------------------------
--Find limit if present against user
INSERT INTO #UserQuotaLimit
SELECT  componentNameId, -1, ISNULL([UMDS User Inherits Quota], -1), ISNULL([Enforce Quota], -1), ISNULL([Quota Size], 0)
FROM    ( SELECT  componentNameId, attrName, CAST(attrVal AS BIGINT) AS attrVal
		FROM    UMUsersProp UP WITH(NOLOCK) JOIN #userList ON componentNameId = t_uid
		WHERE   attrName = 'UMDS User Inherits Quota' AND cs_attrName = CHECKSUM(N'UMDS User Inherits Quota')
		UNION
		SELECT  componentNameId, attrName, CAST(attrVal AS BIGINT) AS attrVal
		FROM    UMUsersProp UP WITH(NOLOCK) JOIN #userList ON componentNameId = t_uid
		WHERE   attrName = 'Enforce Quota' AND cs_attrName = CHECKSUM(N'Enforce Quota')
		UNION
		SELECT  componentNameId, attrName, CAST(attrVal AS BIGINT) AS attrVal
		FROM    UMUsersProp UP WITH(NOLOCK) JOIN #userList ON componentNameId = t_uid
		WHERE   attrName = 'Quota Size' AND cs_attrName = CHECKSUM(N'Quota Size')  ) AS UMP
PIVOT   ( MAX(attrVal) FOR attrName IN (  [UMDS User Inherits Quota], [Enforce Quota], [Quota Size]) ) AS P
UPDATE #userList SET t_quotaLimit = t_quotaSize * @bytesInGB
FROM #UserQuotaLimit WHERE t_uid1 = t_uid AND t_quotaInherited = 0 AND t_quotaEnforced = 1
TRUNCATE TABLE #UserQuotaLimit
--Update if the limit is present at group level and still not updated
INSERT INTO #UserQuotaLimit
SELECT  userid, groupId, -1, ISNULL([Enforce Quota], 0), ISNULL([Quota Size], 0)
FROM    ( SELECT  userid, UG.groupId, attrName, CAST(attrVal AS INT) AS attrVal
		FROM UMUserGroup UG WITH(NOLOCK)
		JOIN #userList B WITH(NOLOCK) on UG.userId = t_uid AND t_quotaLimit = 0
		JOIN UMGroupsProp C WITH(NOLOCK) on UG.groupId = C.componentNameId
JOIN UMGroups G WITH (NOLOCK) ON G.id = UG.groupId AND (G.groupFlags & 0x0001) <> 0 AND (G.groupFlags & 0x0002) = 0 -- select enabled groups and ignore deleted groups
		WHERE C.attrName ='Quota Size' AND C.cs_attrName = CHECKSUM(N'Quota Size') and attrVal <> '0'
		UNION
		SELECT  userid, UG.groupId, attrName, CAST(attrVal AS INT) AS attrVal
		FROM UMUserGroup UG WITH(NOLOCK)
		JOIN #userList B WITH(NOLOCK) on UG.userId = t_uid AND t_quotaLimit = 0
		JOIN UMGroupsProp C WITH(NOLOCK) on UG.groupId = C.componentNameId
		JOIN UMGroups G WITH (NOLOCK) ON G.id = UG.groupId AND (G.groupFlags & 0x0001) <> 0 AND (G.groupFlags & 0x0002) = 0 -- select enabled groups and ignore deleted groups
		WHERE C.attrName = 'Enforce Quota' AND C.cs_attrName = CHECKSUM(N'Enforce Quota') and attrVal <> '0') AS UMP
PIVOT   ( MAX(attrVal) FOR attrName IN ( [Enforce Quota], [Quota Size]) ) AS P
UPDATE #userList SET t_quotaLimit = t_quotaSize * @bytesInGB
FROM (SELECT t_uid1,MAX(t_quotaSize) AS t_quotaSize FROM #UserQuotaLimit WHERE t_quotaEnforced <> 0 AND t_quotaSize <> 0 GROUP BY t_uid1) T
WHERE t_uid1 = t_uid AND t_quotaLimit = 0
--------------------------------------------------------
-- 3rd. compute quota usage and update the user property
--------------------------------------------------------
IF object_id('tempdb.dbo.#clientUserMapping') IS NOT NULL DROP TABLE #clientUserMapping
CREATE TABLE #clientUserMapping(t_uid1 INT, t_clientid INT, t_size BIGINT)
CREATE CLUSTERED INDEX clientUserMapping_t_clientid_t_uid1_Idx ON #clientUserMapping (t_clientid, t_uid1)
INSERT INTO #clientUserMapping
SELECT DISTINCT t_uid, Owners.entityId, 0
FROM UMOwners Owners INNER JOIN
(
	SELECT t_uid, groupID AS t_groupID, 0 AS t_isUser
	FROM UMUserGroup A WITH(NOLOCK) JOIN #userList B ON userID = t_uid
	UNION
	SELECT t_uid, UGM.umgroupId AS t_groupID, 0
	FROM UMDSGroupMaps UGM WITH(NOLOCK) INNER JOIN UMUserGroup UG WITH(NOLOCK) ON UGM.umdsGroupId = UG.groupID
	JOIN #userList B ON userID = t_uid
	UNION
	SELECT t_uid, t_uid AS t_groupID, 1 FROM #userList
) UG
ON Owners.isUser = UG.t_isUser AND Owners.userOrGroupId = UG.t_groupID
BEGIN TRANSACTION
SET @transStarted = 1
-- get space consumed by user stored as subclient property
UPDATE #clientUserMapping SET t_size = size
FROM
(SELECT A.clientId, SUM(CAST(SP.attrVal as bigint)) size FROM APP_Application A WITH (NOLOCK) JOIN (SELECT distinct t_clientid FROM #clientUserMapping) B ON A.clientId = B.t_clientid
JOIN APP_SubClientProp SP WITH (NOLOCK) ON A.id = SP.componentNameId AND SP.attrName = N'Application Size' AND SP.modified = 0 AND SP.cs_attrName = CHECKSUM(N'Application Size')
WHERE A.subclientStatus & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0
GROUP BY A.clientId) T WHERE clientId = t_clientid
-- add space consumed by user stored as backupset property to already size from subclient
UPDATE #clientUserMapping SET t_size = t_size + size
FROM
(
SELECT A.clientId, sum (A.size) as size FROM
	(
	SELECT distinct A.clientId, CAST(BP.attrVal as bigint) as size, C.id as backupset FROM
	APP_Application A WITH (NOLOCK) JOIN #clientUserMapping B ON A.clientId = B.t_clientid
	JOIN APP_BackupSetName C WITH (NOLOCK) ON A.backupSet = C.id
	JOIN APP_BackupSetProp BP WITH (NOLOCK) ON BP.componentNameId = C.id
	WHERE BP.attrName = N'Application Size'
	AND BP.modified = 0
AND C.status & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0 -- only non-deleted, non-hidden backupsets
	) A
GROUP BY A.clientId) T
WHERE clientId = t_clientid
UPDATE #userList SET t_quotaUsage = t_size
FROM (SELECT t_uid1, SUM(t_size) AS t_size FROM #clientUserMapping GROUP BY t_uid1) T WHERE t_uid  = t_uid1
IF object_id('tempdb.dbo.#modifiedRows') IS NOT NULL DROP TABLE #modifiedRows
CREATE TABLE #modifiedRows(t_id INT)
MERGE UMUsersProp AS T
USING #userList AS S
ON T.componentNameId = S.t_uid AND attrName = 'ReComputeQuota' AND cs_attrName = CHECKSUM(N'ReComputeQuota')
WHEN MATCHED AND modified <= @startTime
    THEN UPDATE SET attrVal = '0', modified = @startTime
WHEN NOT MATCHED BY TARGET
    THEN INSERT (componentNameId,attrName,attrType,attrVal,created,modified)
VALUES (t_uid, 'ReComputeQuota', 7, '0', dbo.GetUnixTime(GETDATE()), @startTime)
OUTPUT
	INSERTED.componentNameId INTO #modifiedRows
;
--If row count matches, it means none of the row which were picked by userlist table were updated in meantime. Update gxglobaparam with 0 indicating we are done processing
DECLARE @gpValue NVARCHAR(4) = '1'
IF(SELECT COUNT(t_uid) FROM #userList) = (SELECT COUNT(t_id) FROM #modifiedRows)
	SET @gpValue = '0'
IF EXISTS(SELECT * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ReComputeQuota')	AND @gpValue = '0'
UPDATE GXGlobalParam SET value = @gpValue WHERE name = 'ReComputeQuota'
ELSE IF NOT EXISTS(SELECT * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ReComputeQuota')
INSERT INTO GxGlobalParam VALUES ('ReComputeQuota', @gpValue, @startTime, 0)
-- Delete rows which are modified after processing started in this stored procedure. We process those in next round again
DELETE T FROM #userList T LEFT JOIN #modifiedRows A on t_id = t_uid
WHERE t_id IS NULL
MERGE UMUsersProp AS T
USING #userList AS S
ON T.componentNameId = S.t_uid AND attrName = 'FSQuotaLimit' AND cs_attrName = CHECKSUM(N'FSQuotaLimit')
WHEN MATCHED
    THEN UPDATE SET attrVal = CAST(t_quotaLimit AS NVARCHAR(MAX))
WHEN NOT MATCHED BY TARGET
    THEN INSERT (componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(t_uid, 'FSQuotaLimit', 7, CAST(t_quotaLimit AS NVARCHAR(MAX)), dbo.GetUnixTime(GETDATE()), 0)
;
MERGE UMUsersProp AS T
USING #userList AS S
ON T.componentNameId = S.t_uid AND attrName = 'FSQuotaUsage' AND cs_attrName = CHECKSUM(N'FSQuotaUsage')
WHEN MATCHED
    THEN UPDATE SET attrVal = CAST(t_quotaUsage AS NVARCHAR(MAX))
WHEN NOT MATCHED BY TARGET
    THEN INSERT (componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(t_uid, 'FSQuotaUsage', 7, CAST(t_quotaUsage AS NVARCHAR(MAX)), dbo.GetUnixTime(GETDATE()), 0)
;
END TRY
BEGIN CATCH
    IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
IF @errorCode = 0 AND @transStarted = 1
	COMMIT TRANSACTION
ELSE IF @transStarted = 1
	ROLLBACK TRANSACTION
SELECT @errorCode, @errorString
IF object_id('tempdb.dbo.#modifiedRows') IS NOT NULL DROP TABLE #modifiedRows
IF object_id('tempdb.dbo.#userList') IS NOT NULL DROP TABLE #userList
IF object_id('tempdb.dbo.#UserQuotaLimit') IS NOT NULL DROP TABLE #UserQuotaLimit
IF object_id('tempdb.dbo.#clientUserMapping') IS NOT NULL DROP TABLE #clientUserMapping
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'UpdateQuotaForUser')
	delete from GxQscripts where name = 'UpdateQuotaForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateQuotaForUser')
	delete from GXDBVersions where aliasname = 'UpdateQuotaForUser'
GO

insert into GXDBVersions values(2, 'UpdateQuotaForUser',  '00010001000200060000', 'UpdateQuotaForUser', '00010001000200060000')
GO

