

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateQuotaAndFailJobIfExceeds.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateQuotaAndFailJobIfExceeds.sp,v $ $Id: UpdateQuotaAndFailJobIfExceeds.sp,v 1.1.2.3 2018/06/19 16:55:51 sbhukar Exp $";
-- =========================================================
-- Author: Ankur Varsheny
-- Description: Update the file-system subclient usage
-- =========================================================
--In Indexing V2 all the operation are only tested at backupset level
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UpdateQuotaAndFailJobIfExceeds <<<'

IF EXISTS (select * from sysobjects where name='UpdateQuotaAndFailJobIfExceeds')
	drop procedure UpdateQuotaAndFailJobIfExceeds
IF EXISTS (select * from GxQscripts where name='UpdateQuotaAndFailJobIfExceeds')
	delete from GxQscripts where name = 'UpdateQuotaAndFailJobIfExceeds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateQuotaAndFailJobIfExceeds')
	delete from GXDBVersions where aliasname = 'UpdateQuotaAndFailJobIfExceeds'
GO
print '... Creating Procedure: UpdateQuotaAndFailJobIfExceeds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UpdateQuotaAndFailJobIfExceeds
  @inputXML XML
AS
SET NOCOUNT ON;
BEGIN
	DECLARE @outXML XML
    DECLARE @updateType INT
    SELECT @updateType = N.value(N'@updateType', N'INT') FROM @inputXML.nodes (N'App_UpdateQuotaAndFailJobIfExceeds') AS T(N)
    DECLARE @inAppId INT
    SELECT @inAppId = N.value(N'@appId', N'INT') FROM @inputXML.nodes (N'App_UpdateQuotaAndFailJobIfExceeds') AS T(N)
    DECLARE @inSpaceConsumed BIGINT
    SELECT @inSpaceConsumed = N.value(N'@spaceConsumed', N'BIGINT') FROM @inputXML.nodes (N'App_UpdateQuotaAndFailJobIfExceeds') AS T(N)
    DECLARE @inBackupSetGUID  UNIQUEIDENTIFIER
    SELECT @inBackupSetGUID = N.value(N'@backupSetGuid', N'UNIQUEIDENTIFIER') FROM @inputXML.nodes (N'App_UpdateQuotaAndFailJobIfExceeds') AS T(N)
	SET @inputXML = (SELECT @updateType AS '@updateType',
			@inAppId AS '@appId',
			@inSpaceConsumed AS '@spaceConsumed',
			@inBackupSetGUID AS '@backupSetGuid',
			0 AS '@deltaUsage',
			1 AS '@checkQuotaLimit'
	FOR XML PATH('App_FSQuotaUsage'), TYPE)
	IF OBJECT_ID(N'tempdb..#usageDataXML', N'U') IS NOT NULL DROP TABLE #usageDataXML;
	CREATE TABLE #usageDataXML(usage xml);
	EXEC CheckAndUpdateQuotaLimit @inputXML
	SELECT @outXML = usage FROM #usageDataXML
	SELECT @outXML
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateQuotaAndFailJobIfExceeds')
	delete from GxQscripts where name = 'UpdateQuotaAndFailJobIfExceeds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateQuotaAndFailJobIfExceeds')
	delete from GXDBVersions where aliasname = 'UpdateQuotaAndFailJobIfExceeds'
GO

insert into GXDBVersions values(2, 'UpdateQuotaAndFailJobIfExceeds',  '00010001000200030000', 'UpdateQuotaAndFailJobIfExceeds', '00010001000200030000')
GO

