

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateOffice365ServiceAccount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===========================================================================================+
--	|  				UpdateOffice365ServiceAccount												|
--	| Procedure for update Office365 Service Account details for Exchange OneDrive SharePoint	|
--  |				Author : Mahesh Kasana														|
--	+===========================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateOffice365ServiceAccount')
BEGIN
	print '>>> Drop Stored Procedure: UpdateOffice365ServiceAccount <<<'
	drop procedure UpdateOffice365ServiceAccount
END
IF EXISTS (select * from GxQscripts where name='UpdateOffice365ServiceAccount')
	delete from GxQscripts where name = 'UpdateOffice365ServiceAccount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateOffice365ServiceAccount')
	delete from GXDBVersions where aliasname = 'UpdateOffice365ServiceAccount'
GO
print '... Creating Procedure: UpdateOffice365ServiceAccount'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateOffice365ServiceAccount
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime            DATETIME = GETDATE()
	DECLARE @nowUtcTime         DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix         INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix        INT = DATEDIFF(second, '01/01/1970', @nowTime)
	DECLARE @backupsetId		INT = 0
	DECLARE @ClientId			INT = 0
	DECLARE @instanceId			INT = 0
	DECLARE @appTypeId			INT = 0
	DECLARE @AccountDetails		XML = ''
	DECLARE @isPasswordAttributeSet INT = 0
	DECLARE @instanceType INT = 0
	DECLARE @ONEDRIVE_INSTANCE INT = 7
	DECLARE @dbAccountStr NVARCHAR(MAX)= ''
	DECLARE @dbAccountXML XML
	IF object_id('tempdb.dbo.#XMLAccountEntries') IS NOT NULL
		DROP TABLE #XMLAccountEntries
	CREATE TABLE #XMLAccountEntries (adminSMTP NVARCHAR(MAX), userName NVARCHAR(MAX), pasWord  NVARCHAR(MAX), SerType int, status INT)
	IF object_id('tempdb.dbo.#DBAccountEntries') IS NOT NULL
		DROP TABLE #DBAccountEntries
	CREATE TABLE #DBAccountEntries (adminSMTP NVARCHAR(MAX), userName NVARCHAR(MAX), pasWord  NVARCHAR(MAX), SerType int, status INT)
	IF object_id('tempdb.dbo.#DBAccountEntriesFinal') IS NOT NULL
		DROP TABLE #DBAccountEntriesFinal
	CREATE TABLE #DBAccountEntriesFinal (adminSMTP NVARCHAR(MAX), userName NVARCHAR(MAX), pasWord  NVARCHAR(MAX), SerType int, status INT)
	SELECT @ClientId = ISNULL(ref.value('@clientId','INT'),0),
		   @appTypeId  = ISNULL(ref.value('@appTypeId','INT'),0)
		FROM @i_xmlString.nodes ('App_UpdateOffice365ServiceAccountReq') R(ref)
	IF @ClientId <=0 OR @appTypeId<=0
	BEGIN
		SET @errorCode = 100
		SET @errorString =
		CASE
			WHEN @appTypeId <= 0 THEN 'ERROR : Invalid AppTypeId Id'
			WHEN @ClientId <= 0 THEN 'ERROR : Invalid Client Id'
		END
		GOTO ERROR_EXIT
	END
IF @appTypeId = 137
	BEGIN
		INSERT INTO #XMLAccountEntries(adminSMTP,userName,pasWord, SerType, status)
		SELECT
			ISNULL(dt.value('@exchangeAdminSmtpAddress','NVARCHAR(MAX)'),'') adminSMTP,
			ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(MAX)'),'') userName,
			ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') pasWord,
			ISNULL(dt.value('@serviceType','INT'),'') SerType,
			ISNULL(dt.value('@status', 'INT'), '') status
		FROM @i_xmlString.nodes ('App_UpdateOffice365ServiceAccountReq') R(ref)
			CROSS APPLY ref.nodes('./adminAccounts') D(dt)
		-- Check if atleast one password attribute is set
		SELECT @isPasswordAttributeSet = (CASE WHEN @isPasswordAttributeSet = 1 OR (ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'), '^')) <> '^' THEN 1 ELSE 0 END) -- '^' because to accept empty passwords
		FROM  @i_xmlString.nodes ('App_UpdateOffice365ServiceAccountReq') R(ref)
					CROSS APPLY ref.nodes('./adminAccounts') D(dt)
		SET @dbAccountStr = ISNULL((SELECT TOP 1 IP.attrVal FROM APP_IDAProp (NOLOCK) IP
							 INNER JOIN APP_IDAName (NOLOCK) IA ON IA.id = IP.componentNameId
									AND IA.clientId = @clientId
									AND IP.modified = 0
									AND IP.attrType = 1
									AND IP.attrName = 'Exchange OnePass Admin Accounts'),'') --i dont find any macro for this attrName
		IF @dbAccountStr = ''
		BEGIN
			SET @dbAccountXML =
			(
				SELECT @AccountDetails
				FOR XML PATH(''),
				ROOT('App_ExchangeAdminAccounts')
			)
		END
		ELSE
		BEGIN
			SET @dbAccountXML = CAST(REPLACE(@dbAccountStr,'encoding="utf-8"', 'encoding="utf-16"') as XML)
			INSERT INTO #DBAccountEntries(adminSMTP,userName,pasWord,SerType,status)
			SELECT
				ISNULL(dt.value('@exchangeAdminSmtpAddress','NVARCHAR(MAX)'),'') adminSMTP,
				ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(MAX)'),'') userName,
				ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') pasWord,
				ISNULL(dt.value('@serviceType','INT'),'') SerType,
				ISNULL(dt.value('@status', 'INT'), '') status
			FROM @dbAccountXML.nodes ('App_ExchangeAdminAccounts') R(ref)
				CROSS APPLY ref.nodes('./adminAccounts') D(dt)
			--Remove accounts for which passwords are updated
			IF @isPasswordAttributeSet = 1
				DELETE #DBAccountEntries
				FROM #XMLAccountEntries XD
				INNER JOIN #DBAccountEntries DB ON XD.adminSMTP = DB.adminSMTP
												AND XD.userName = DB.userName
												AND XD.SerType = DB.SerType
			--Replace Local system acccount
			DELETE #DBAccountEntries
			FROM #XMLAccountEntries XD
			INNER JOIN #DBAccountEntries DB ON (XD.SerType = 3
											AND XD.SerType = DB.SerType)
			IF @isPasswordAttributeSet = 1
				Insert into #DBAccountEntriesFinal
				SELECT * From #DBAccountEntries
				UNION
				SELECT * From #XMLAccountEntries
			ELSE
				BEGIN
                    /*Skip adding new entry if existing and incoming status for service accounts is the same*/
                    IF NOT EXISTS (SELECT 1 FROM #DBAccountEntries DE LEFT JOIN #XMLAccountEntries XE ON DE.adminSMTP = XE.adminSMTP AND DE.SerType = XE.SerType WHERE DE.status <> ISNULL(XE.status, 0))
                        GOTO ERROR_EXIT
                    INSERT INTO #DBAccountEntriesFinal (adminSMTP, userName, pasWord, SerType, status)
                    SELECT DE.adminSMTP, DE.userName, DE.pasWord, DE.SerType, ISNULL(XE.status, 0)
                    FROM #DBAccountEntries DE
                    LEFT JOIN #XMLAccountEntries XE ON DE.adminSMTP = XE.adminSMTP AND DE.SerType = XE.SerType
                END
			SET @AccountDetails =
				(
					SELECT DB.adminSMTP '@exchangeAdminSmtpAddress', DB.SerType '@serviceType', DB.status '@status',
					(
						SELECT DB.pasWord '@password', DB.userName '@userName'
						FOR XML PATH ('userAccount'),TYPE
					)
					FROM #DBAccountEntriesFinal DB
					FOR XML PATH ('adminAccounts')
				)
			IF @AccountDetails IS NULL
				GOTO ERROR_EXIT
			SET @dbAccountXML =
			(
				SELECT @AccountDetails
				FOR XML PATH(''),
				ROOT('App_ExchangeAdminAccounts')
			)
		END
		UPDATE APP_IDAProp
		SET modified = @nowTimeUnix
		FROM APP_IDAProp (NOLOCK) IP
		INNER JOIN APP_IDAName (NOLOCK) IA ON IA.id = IP.componentNameId AND IA.clientId = @clientId
		WHERE IP.modified = 0 AND IP.attrName = 'Exchange OnePass Admin Accounts' AND IP.attrType = 1
		INSERT INTO APP_IDAProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT IA.id,'Exchange OnePass Admin Accounts', 1,CAST(@dbAccountXML as NVARCHAR(MAX)),@nowTimeUnix,0,0
		FROM APP_IDAName (NOLOCK) IA WHERE IA.clientId = @clientId
		GOTO ERROR_EXIT
	END
IF @appTypeId = 78
	BEGIN
		INSERT INTO #XMLAccountEntries(adminSMTP, userName, pasWord, SerType)
		SELECT
			ISNULL(dt.value('@AdminSmtpAddress','NVARCHAR(MAX)'),'') adminSMTP,
			ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(MAX)'),'') userName,
			ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') pasWord,
			ISNULL(dt.value('@serviceType','INT'),'') SerType
		FROM @i_xmlString.nodes ('App_UpdateOffice365ServiceAccountReq') R(ref)
			CROSS APPLY ref.nodes('./accounts') D(dt)
		SET @backupsetId = ISNULL((SELECT TOP 1 backupSet FROM APP_Application (NOLOCK) WHERE clientId = @clientId AND appTypeId = @appTypeId),0)
		IF @backupsetId< =0
		BEGIN
				SET @errorCode = 200
				SET @errorString = 'ERROR : Cant Figureout BackupSet Id'
				GOTO  ERROR_EXIT
		END
		SET @dbAccountStr = ISNULL((SELECT TOP 1 BP.attrVal FROM APP_BackupSetProp (NOLOCK) BP
								WHERE BP.componentNameId = @backupsetId
									AND BP.modified = 0
									AND BP.attrType = 1
									AND BP.attrName = 'Sharepoint Service Accounts'),'')
		IF @dbAccountStr = ''
		BEGIN
			SET @dbAccountXML =
			(
				SELECT @AccountDetails
				FOR XML PATH(''),
				ROOT('App_SharepointServiceAccounts')
			)
		END
		ELSE
		BEGIN
			SET @dbAccountXML = CAST(REPLACE(@dbAccountStr,'encoding="utf-8"', 'encoding="utf-16"') as XML)
			INSERT INTO #DBAccountEntries(adminSMTP,userName,pasWord,SerType)
			SELECT ISNULL(dt.value('@AdminSmtpAddress','NVARCHAR(MAX)'),'') adminSMTP,
				   ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(MAX)'),'') userName,
				   ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') pasWord,
				   ISNULL(dt.value('@serviceType','INT'),'') SerType
			FROM @dbAccountXML.nodes ('App_SharepointServiceAccounts') R(ref)
				   CROSS APPLY ref.nodes('./accounts') D(dt)
			--Remove accounts for which passwords are updated
			DELETE #DBAccountEntries
			FROM #XMLAccountEntries XD
			INNER JOIN #DBAccountEntries DB ON XD.adminSMTP = DB.adminSMTP
											AND XD.userName = DB.userName
											AND XD.SerType = DB.SerType
			--Replace Local system acccount
			DELETE #DBAccountEntries
			FROM #XMLAccountEntries XD
			INNER JOIN #DBAccountEntries DB ON (XD.SerType = 3
											AND XD.SerType = DB.SerType)
			Insert into #DBAccountEntriesFinal
			SELECT * From #DBAccountEntries
			UNION
			SELECT * From #XMLAccountEntries
			SET @AccountDetails =
				(
					SELECT  DB.adminSMTP '@AdminSmtpAddress', DB.SerType '@serviceType',
					(
						SELECT DB.pasWord '@password', DB.userName '@userName'
						FOR XML PATH ('userAccount'),TYPE
					)
					FROM #DBAccountEntriesFinal DB
					FOR XML PATH ('accounts')
				)
			IF @AccountDetails IS NULL
				GOTO ERROR_EXIT
			SET @dbAccountXML =
			(
				SELECT @AccountDetails
				FOR XML PATH(''),
				ROOT('App_SharepointServiceAccounts')
			)
		END
		UPDATE APP_BackupSetProp
		SET modified = @nowTimeUnix
		WHERE componentNameId = @backupsetId AND modified = 0 AND attrName = 'Sharepoint Service Accounts' AND attrType = 1
		INSERT INTO APP_BackupSetProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT @backupsetId,'Sharepoint Service Accounts', 1,CAST(@dbAccountXML as NVARCHAR(MAX)),@nowTimeUnix,0,0
		GOTO ERROR_EXIT
	END
IF @appTypeId = 134
	BEGIN
		INSERT INTO #XMLAccountEntries(adminSMTP, userName,pasWord, SerType)
		SELECT ISNULL(dt.value('@AdminSmtpAddress','NVARCHAR(MAX)'),'') adminSMTP,
			ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(MAX)'),'') userName,
			ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') pasWord,
			ISNULL(dt.value('@serviceType','INT'),'') SerType
		FROM @i_xmlString.nodes ('App_UpdateOffice365ServiceAccountReq') R(ref)
			CROSS APPLY ref.nodes('./accounts') D(dt)
		SET @instanceId = ISNULL((SELECT TOP 1 instance FROM APP_Application (NOLOCK) WHERE clientId = @clientId AND appTypeId = @appTypeId),0)
		IF @instanceId< =0
		BEGIN
				SET @errorCode = 200
				SET @errorString = 'ERROR : Cant Figureout Instance Id'
				GOTO  ERROR_EXIT
		END
		SET @instanceType = ISNULL((SELECT TOP 1 attrVal FROM APP_InstanceProp(NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'Cloud Apps Instance Type' AND modified = 0),  0)
		IF @instanceId <= 0
		BEGIN
			SET @errorCode = 200
			SET @errorString = 'ERROR : Invalid instance type'
			GOTO ERROR_EXIT
		END
		SET @dbAccountStr = ISNULL((SELECT TOP 1 IP.attrVal FROM APP_InstanceProp (NOLOCK) IP
								WHERE IP.componentNameId = @instanceId
									AND IP.modified = 0
									AND IP.attrType = 1
									AND IP.attrName = (CASE @instanceType WHEN @ONEDRIVE_INSTANCE THEN 'OneDrive Service Accounts' ELSE 'V2CloudApps Service Accounts' END)),'')
		IF @dbAccountStr = ''
		BEGIN
			IF @instanceType = @ONEDRIVE_INSTANCE
				SET @dbAccountXML =
				(
					SELECT @AccountDetails
					FOR XML PATH(''),
					ROOT('App_OneDriveServiceAccounts')
				)
			ELSE
				SET @dbAccountXML =
				(
					SELECT @AccountDetails
					FOR XML PATH(''),
					ROOT('App_V2CloudAppsServiceAccounts')
				)
		END
		ELSE
		BEGIN
			SET @dbAccountXML = CAST(REPLACE(@dbAccountStr,'encoding="utf-8"', 'encoding="utf-16"') as XML)
			IF @instanceType = @ONEDRIVE_INSTANCE
				INSERT INTO #DBAccountEntries(adminSMTP,userName,pasWord,SerType)
				SELECT  ISNULL(dt.value('@AdminSmtpAddress','NVARCHAR(MAX)'),'') adminSMTP,
						ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(MAX)'),'') userName,
						ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') pasWord,
						ISNULL(dt.value('@serviceType','INT'),'') SerType
				FROM @dbAccountXML.nodes ('App_OneDriveServiceAccounts') R(ref)
						CROSS APPLY ref.nodes('./accounts') D(dt)
			ELSE
				INSERT INTO #DBAccountEntries(adminSMTP,userName,pasWord,SerType)
				SELECT  ISNULL(dt.value('@AdminSmtpAddress','NVARCHAR(MAX)'),'') adminSMTP,
						ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(MAX)'),'') userName,
						ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') pasWord,
						ISNULL(dt.value('@serviceType','INT'),'') SerType
				FROM @dbAccountXML.nodes ('App_V2CloudAppsServiceAccounts') R(ref)
						CROSS APPLY ref.nodes('./accounts') D(dt)
			--Remove accounts for which passwords are updated
			DELETE #DBAccountEntries
			FROM #XMLAccountEntries XD
			INNER JOIN #DBAccountEntries DB ON XD.adminSMTP = DB.adminSMTP
											AND XD.userName = DB.userName
											AND XD.SerType = DB.SerType
			--Replace Local system acccount
			DELETE #DBAccountEntries
			FROM #XMLAccountEntries XD
			INNER JOIN #DBAccountEntries DB ON (XD.SerType = 3
											AND XD.SerType = DB.SerType)
			Insert into #DBAccountEntriesFinal
			SELECT * From #DBAccountEntries
			UNION
			SELECT * From #XMLAccountEntries
			SET @AccountDetails =
				(
					SELECT  DB.adminSMTP '@AdminSmtpAddress', DB.SerType '@serviceType',
					(
						SELECT DB.pasWord '@password', DB.userName '@userName'
						FOR XML PATH ('userAccount'),TYPE
					)
					FROM #DBAccountEntriesFinal DB
					FOR XML PATH ('accounts')
				)
			IF @AccountDetails IS NULL
				GOTO ERROR_EXIT
			IF @instanceType = @ONEDRIVE_INSTANCE
				SET @dbAccountXML =
				(
					SELECT @AccountDetails
					FOR XML PATH(''),
					ROOT('App_OneDriveServiceAccounts')
				)
			ELSE
				SET @dbAccountXML =
				(
					SELECT @AccountDetails
					FOR XML PATH(''),
					ROOT('App_V2CloudAppsServiceAccounts')
				)
		END
		UPDATE APP_InstanceProp
		SET modified = @nowTimeUnix
		WHERE componentNameId = @instanceId AND modified = 0 AND attrName IN ('OneDrive Service Accounts', 'V2CloudApps Service Accounts') AND attrType = 1
		INSERT INTO APP_InstanceProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT @instanceId,(CASE @instanceType WHEN @ONEDRIVE_INSTANCE THEN 'OneDrive Service Accounts' ELSE 'V2CloudApps Service Accounts' END), 1,CAST(@dbAccountXML as NVARCHAR(MAX)),@nowTimeUnix,0,0
		GOTO ERROR_EXIT
	END
ERROR_EXIT:
	IF @o_xmlString IS NULL
	SET @o_xmlString  =
		(
			SELECT @errorCode '@errorCode',
				   @errorString '@errorMessage'
			FOR XML PATH ('App_GenericResp')
		)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateOffice365ServiceAccount')
	delete from GxQscripts where name = 'UpdateOffice365ServiceAccount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateOffice365ServiceAccount')
	delete from GXDBVersions where aliasname = 'UpdateOffice365ServiceAccount'
GO

insert into GXDBVersions values(2, 'UpdateOffice365ServiceAccount',  '00000000000000000000', 'UpdateOffice365ServiceAccount', '00000000000000000000')
GO

