

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateLicUsageDetailsHistory.sp] ---------- 

--******************************************************************************/
--*  Copyright (c) CommVault Systems                                           */
--*  All Rights Reserved                                                       */
--*                                                                            */
--*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
--*  The copyright notice above does not evidence any                          */
--*  actual or intended publication of such source code.                       */
--*                                                                            */
--*  File name   : UpdateLicUsageDetailsHistory.sp   			       */
--*                                                                            */
--*  Description : Procedure used for the Capacity,Usage based licenses        */
--*                                                                            */
--*  Author      : Ravi Kumarasamy					       */
--*                                                                            */
--******************************************************************************/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateLicUsageDetailsHistory.sp,v $ $Id: UpdateLicUsageDetailsHistory.sp,v 1.4.86.1 2017/11/30 02:07:11 leiwang Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PROCNAME   - Should be IDENTICAL TO FILENAME
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UpdateLicUsageDetailsHistory <<<'

IF EXISTS (select * from sysobjects where name='UpdateLicUsageDetailsHistory')
	drop procedure UpdateLicUsageDetailsHistory
IF EXISTS (select * from GxQscripts where name='UpdateLicUsageDetailsHistory')
	delete from GxQscripts where name = 'UpdateLicUsageDetailsHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateLicUsageDetailsHistory')
	delete from GXDBVersions where aliasname = 'UpdateLicUsageDetailsHistory'
GO
print '... Creating Procedure: UpdateLicUsageDetailsHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure UpdateLicUsageDetailsHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @iEnterpriseBackupSize BIGINT,
  @iCoreBackupSize BIGINT,
  @iEnterpriseArchiveSize BIGINT,
  @iCoreArchiveSize BIGINT,    
  @iProtectedMailBoxUsed BIGINT,
  @iArchiveMailBoxUsed BIGINT,
  @iContentIndexedObjectUsed BIGINT,
  @iSnapSize BIGINT,   
  @iReplicationSize BIGINT,
  @flag INT
-- flag: 0   the call comes from LicGetUsageDetails; flag: 1  the call comes from CVUsageCALBased
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  DECLARE @rv INTEGER
    DECLARE @now_dt AS DATETIME = GETUTCDATE()
    DECLARE @now    AS INTEGER  = dbo.GetUnixTime(@now_dt)
    DECLARE @date_s AS NVARCHAR(32) = CAST(DATEPART(year,  @now_dt) AS NVARCHAR(32)) + '-' +
                                      CAST(DATEPART(month, @now_dt) AS NVARCHAR(32)) + '-' +
                                      CAST(DATEPART(day,   @now_dt) AS NVARCHAR(32)) + ' 00:00:00.000'
    DECLARE @date_start INTEGER = dbo.GetUnixTime(CONVERT(DATETIME, @date_s, 120))
    DECLARE @date_end   INTEGER = @date_start + 86400
    IF EXISTS(SELECT * FROM LicUsageDetailsHistory WHERE [date] >= @date_start AND [date] < @date_end)
	BEGIN
		IF(@flag = 0)
		BEGIN
		      UPDATE  LicUsageDetailsHistory
			  SET
				EnterpriseBackupSize   	      = @iEnterpriseBackupSize,
                EnterpriseArchiveSize  	      = @iEnterpriseArchiveSize,
				SnapSize					  = @iSnapSize,
				ReplicationSize				  = @iReplicationSize
        WHERE   [date] >= @date_start AND [date] < @date_end
        END
		ELSE IF (@flag = 1)
		BEGIN
			  UPDATE  LicUsageDetailsHistory
			  SET
					ProtectedMailBoxUsed          = @iProtectedMailBoxUsed,
					ArchiveMailBoxUsed            = @iArchiveMailBoxUsed,
	                ContentIndexedObjectUsed      = @iContentIndexedObjectUsed
			  WHERE   [date] >= @date_start AND [date] < @date_end
        END
        SET @rv = 0
    END
	ELSE
	BEGIN
        INSERT INTO LicUsageDetailsHistory
			(date,EnterpriseBackupSize,CoreBackupSize,EnterpriseArchiveSize,
			CoreArchiveSize,ProtectedMailBoxUsed,ArchiveMailBoxUsed,ContentIndexedObjectUsed,SnapSize,ReplicationSize)
        	VALUES(@now, @iEnterpriseBackupSize, @iCoreBackupSize, @iEnterpriseArchiveSize,
        	@iCoreArchiveSize,@iProtectedMailBoxUsed,@iArchiveMailBoxUsed,@iContentIndexedObjectUsed,@iSnapSize,@iReplicationSize)
        SET @rv = 1
    END
    SELECT @rv
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateLicUsageDetailsHistory')
	delete from GxQscripts where name = 'UpdateLicUsageDetailsHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateLicUsageDetailsHistory')
	delete from GXDBVersions where aliasname = 'UpdateLicUsageDetailsHistory'
GO

insert into GXDBVersions values(2, 'UpdateLicUsageDetailsHistory',  '00010004008600010000', 'UpdateLicUsageDetailsHistory', '00010004008600010000')
GO

