

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateIdxV2AppTypesBitmask.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2020 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateIdxV2AppTypesBitmask.sp,v $ $Id: UpdateIdxV2AppTypesBitmask.sp,v 1.1.2.2.4.1 2021/04/22 19:03:05 mmansano Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateIdxV2AppTypesBitmask')
BEGIN
	print '>>> Drop Stored Procedure: UpdateIdxV2AppTypesBitmask <<<'
	drop procedure UpdateIdxV2AppTypesBitmask
END
IF EXISTS (select * from GxQscripts where name='UpdateIdxV2AppTypesBitmask')
	delete from GxQscripts where name = 'UpdateIdxV2AppTypesBitmask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateIdxV2AppTypesBitmask')
	delete from GXDBVersions where aliasname = 'UpdateIdxV2AppTypesBitmask'
GO
print '... Creating Procedure: UpdateIdxV2AppTypesBitmask'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateIdxV2AppTypesBitmask
  @i_clientId INT = NULL
AS
DECLARE @curtime INT = DBO.GetUnixTime(GETUTCDATE())
DECLARE @indexingV2EnabledMaskAttrName nvarchar(22) = 'IndexingV2_EnabledMask'
IF object_id('tempdb.dbo.#idxToClientProp') IS NOT NULL  DROP TABLE #idxToClientProp
CREATE TABLE #idxToClientProp
(	 componentNameId        INT,
	 attrVal				NVARCHAR(MAX)
)
-- No input client ID provided, update for all v2 clients
if @i_clientId IS NULL
BEGIN
	INSERT INTO #idxToClientProp
	SELECT componentNameId, SUM(ISNULL(i.idxPos, 0)) AS attrVal
            FROM App_ClientProp CP WITH(NOLOCK)
                LEFT OUTER JOIN IdxV2AppTypes i WITH(NOLOCK) ON
                    i.name = CP.attrName
            WHERE CP.attrName LIKE 'IndexingV2%'
                AND CP.attrName <> 'IndexingV2_EnabledMask' -- To avoid warn: "Null value is eliminated by an aggregate or other SET operation."
                AND CP.attrVal = '1'
                AND CP.modified = 0
            GROUP BY componentNameId
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT itc.componentNameId, @indexingV2EnabledMaskAttrName, 2, itc.attrVal, @curTime, 0
	FROM #idxToClientProp itc
	LEFT JOIN App_clientProp CP on itc.componentNameId = CP.componentNameId AND CP.attrName = @indexingV2EnabledMaskAttrName AND CP.modified = 0
	WHERE CP.componentNameId IS NULL
	UPDATE CP
		SET attrVal = itc.attrVal
	FROM #idxToClientProp itc
	INNER JOIN APP_ClientProp CP ON CP.componentNameId = itc.componentNameId and CP.attrName = @indexingV2EnabledMaskAttrName and CP.attrVal <> itc.attrVal AND CP.modified = 0
END
ELSE
BEGIN
	INSERT INTO #idxToClientProp
	SELECT componentNameId, SUM(ISNULL(i.idxPos, 0)) AS attrVal
            FROM App_ClientProp CP WITH(NOLOCK)
                LEFT OUTER JOIN IdxV2AppTypes i WITH(NOLOCK) ON
                    i.name = CP.attrName
            WHERE CP.componentNameId = @i_clientId
                AND CP.attrName LIKE 'IndexingV2%'
                AND CP.attrName <> 'IndexingV2_EnabledMask' -- To avoid warn: "Null value is eliminated by an aggregate or other SET operation."
                AND CP.attrVal = '1'
                AND CP.modified = 0
            GROUP BY componentNameId
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT itc.componentNameId, @indexingV2EnabledMaskAttrName, 2, itc.attrVal, @curTime, 0
	FROM #idxToClientProp itc
	LEFT JOIN App_clientProp CP on itc.componentNameId = CP.componentNameId AND CP.attrName = @indexingV2EnabledMaskAttrName AND CP.modified = 0
	WHERE CP.componentNameId IS NULL
	UPDATE CP
		SET attrVal = itc.attrVal
	FROM #idxToClientProp itc
	INNER JOIN APP_ClientProp CP ON CP.componentNameId = itc.componentNameId and CP.attrName = @indexingV2EnabledMaskAttrName and CP.attrVal <> itc.attrVal AND CP.modified = 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateIdxV2AppTypesBitmask')
	delete from GxQscripts where name = 'UpdateIdxV2AppTypesBitmask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateIdxV2AppTypesBitmask')
	delete from GXDBVersions where aliasname = 'UpdateIdxV2AppTypesBitmask'
GO

insert into GXDBVersions values(2, 'UpdateIdxV2AppTypesBitmask',  'v1.1.2.2.4.1', 'UpdateIdxV2AppTypesBitmask', 'v1.1.2.2.4.1')
GO

