

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateEntitiesForEE.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateEntitiesForEE.sp,v $ $Id: UpdateEntitiesForEE.sp,v 1.1.6.17.8.1 2021/02/17 11:37:17 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateEntitiesForEE')
BEGIN
	print '>>> Drop Stored Procedure: UpdateEntitiesForEE <<<'
	drop procedure UpdateEntitiesForEE
END
IF EXISTS (select * from GxQscripts where name='UpdateEntitiesForEE')
	delete from GxQscripts where name = 'UpdateEntitiesForEE'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateEntitiesForEE')
	delete from GXDBVersions where aliasname = 'UpdateEntitiesForEE'
GO
print '... Creating Procedure: UpdateEntitiesForEE'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateEntitiesForEE
  @i_userId int,
  @i_entityXML xml = '',
  @i_operationType int = 0
AS
  --output variables
  DECLARE @o_errorCode INT
  DECLARE @o_errorMsg NVARCHAR(max) = ''
  DECLARE @o_entityId INT = 0
  --constants
  DECLARE @DEFAULT_CUSTOM_CONTAINER_GUID nvarchar(40) = '22CD8879-B2FD-4A63-8096-B515FC13502D' -- default custom entity
  DECLARE @DEFAULT_CUSTOM_PARENT_CONTAINER_GUID nvarchar(40) = 'B05D1D67-FCE2-493B-A7F4-5400938EAF70' -- default custom parent container guid
  DECLARE @DEFAULT_CLASSIFIER_PARENT_CONTAINER_GUID nvarchar(40) = 'C99E55EF-5875-425C-98A9-8DF5F5F0DF27' -- default classifiers parent container guid
  DECLARE @l_customEntityGuid VARCHAR(36) = @DEFAULT_CUSTOM_CONTAINER_GUID  --mapped in DM2Container
  DECLARE @custom_container_guid VARCHAR(40) = @DEFAULT_CUSTOM_CONTAINER_GUID  --mapped in DM2Container
  DECLARE @USER_OVERRIDDEN INT = 1
  DECLARE @SYSTEM_DEFINED_ENTITY INT = 2
  DECLARE @NER_TYPE INT = 1
  DECLARE @RER_TYPE INT = 2
  DECLARE @DE_TYPE INT = 3
  DECLARE @CLASSIFIER_TYPE INT = 4
  DECLARE @entityId INT
  DECLARE @entityName NVARCHAR(512)
  DECLARE @enabled BIT
  DECLARE @parentEntityID INT
  DECLARE @regularExpression NVARCHAR(MAX)
  DECLARE @isSystemDefinedEntity BIT
  DECLARE @annotatorXML XML
  DECLARE @existingAnnotatorXML XML
  DECLARE @flags INT
  DECLARE @entityType INT = @RER_TYPE -- by default RER entityType
  DECLARE @proximityRange INT
  DECLARE @keywords NVARCHAR(max)
  DECLARE @inheritBaseWords BIT
  DECLARE @sensitivity INT
  DECLARE @entityKey NVARCHAR(1024)
  DECLARE @existingAttribute INT
  DECLARE @description NVARCHAR(max)
  DECLARE @classifierDetails xml
  --Populate the request
  --
  SELECT @entityId = ISNULL(T.ref.value('@entityId','INT'),0) FROM @i_entityXML.nodes('/DM2ContentIndexing_EntityDetails') T(ref)
  IF (@i_operationType = 0) -- ADD/UPDATE
  BEGIN
    SELECT  @entityName = T.ref.value('@entityName', 'NVARCHAR(512)'),
            @entityKey = T.ref.value('@entityKey', 'NVARCHAR(1024)'),
            @enabled = ISNULL(T.ref.value('@enabled', 'BIT'), 1), --honor input enabled flag
            @parentEntityID = T.ref.value('@parentEntityId', 'INT'),
            @regularExpression = T.ref.value('@regularExpression', 'NVARCHAR(MAX)'),
            @flags = T.ref.value('@flags', 'INT'),
            @entityType = T.ref.value('@entityType', 'INT'),
            @description = T.ref.value('@description', 'NVARCHAR(MAX)')
    FROM @i_entityXML.nodes('/DM2ContentIndexing_EntityDetails') T(ref)
    SELECT @annotatorXML = @i_entityXML.query('/DM2ContentIndexing_EntityDetails/entityXML')
    IF @entityId <> 0
    BEGIN
      SELECT @proximityRange = @annotatorXML.value('/entityXML[1]/@proximityRange','int')
      SELECT @keywords = @annotatorXML.value('/entityXML[1]/@keywords','nvarchar(max)')
      SELECT @inheritBaseWords = @annotatorXML.value('/entityXML[1]/@inheritBaseWords','bit')
      -- SELECT @isSystemDefinedEntity = @annotatorXML.value('/entityXML[1]/@isSystemDefinedEntity','bit')
      SELECT @sensitivity = @annotatorXML.value('/entityXML[1]/@sensitivity','int')
      IF @entityType = @CLASSIFIER_TYPE
      BEGIN
        SELECT @classifierDetails = @annotatorXML.query('/entityXML[1]/classifierDetails')
      END
    END
    IF @entityType = @CLASSIFIER_TYPE
    BEGIN
SET @sensitivity = ISNULL(@sensitivity, 0x1)
SET @flags = ISNULL(@flags, 0x1)
    END
  END
  -- do validation
  -- entityId check
  IF ((@entityId <> 0 OR @i_operationType = 1)  AND NOT EXISTS (SELECT TOP 1 EntityID FROM EntityAnnotator WHERE EntityID = @entityId))
  BEGIN
    SELECT @o_errorMsg = 'Invalid Entity Id provided.', @o_errorCode=11501, @o_entityId=-1 -- INVALID_ENTITY_ID = 11501;
    GOTO EXITBLOCK
  END
  --Same key name
  IF  @i_operationType = 0 AND EXISTS(SELECT TOP 1 EntityID FROM EntityAnnotator WHERE EntityKey = @entityKey AND EntityID <> @entityId)
  BEGIN
    SELECT @o_errorMsg = 'Entity name ['+ @entityName +'] already exists. Please use a different name.', @o_errorCode=11502, @o_entityId=-1 -- ENTITY_NAME_ALREADY_EXISTS = 11502
    GOTO EXITBLOCK
  END
  -- in case of derived entity enable operation, check if parent is enabled otherwise throw an error
  IF @i_operationType = 0 AND @enabled = 1 AND @parentEntityID is not NULL AND EXISTS(SELECT TOP 1 EntityID FROM EntityAnnotator WHERE EntityID=@parentEntityID AND Enabled = 0)
  BEGIN
    SELECT @o_errorMsg = 'Failed to enable entity. Please verify that Parent Entity is enabled. ', @o_errorCode=11504, @o_entityId=-1 -- PARENT_ENTITY_DISABLED
    GOTO EXITBLOCK
  END
  BEGIN TRY
  BEGIN TRAN
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ------------------------------------------------------------- Tenant Security --------------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  -- adding tenant security for custom entities
  -- check if user belongs to an organization
  -- get the custom entity container for the organization
  DECLARE @organizationId int = 0
  DECLARE @containerId int = 0
  -- get the organization for the logged in user
  SELECT @organizationId = dbo.AppGetOrganizationForUser(@i_userId)
IF @organizationId <> 0 AND EXISTS(SELECT 1 FROM UMDSProviders WHERE id=@organizationId and serviceType = 5) -- UMDS_PROVIDER_ORGANIZATIONS
  BEGIN
    IF OBJECT_ID('tempdb.dbo.#UserHasPermissionOnEntity_temp') IS NOT NULL
        DROP TABLE #UserHasPermissionOnEntity_temp
    CREATE TABLE #UserHasPermissionOnEntity_temp(entityId int)
EXEC dbo.sec_getNonIdaObjectsForThisUser @i_userId, 9517, 0, '#UserHasPermissionOnEntity_temp'
    SELECT TOP 1 @custom_container_guid = containerGuid FROM DM2Container DC INNER JOIN #UserHasPermissionOnEntity_temp UTEMP ON DC.containerId = UTEMP.entityId
    SET @l_customEntityGuid = @custom_container_guid
    IF @custom_container_guid = @DEFAULT_CUSTOM_CONTAINER_GUID -- in case no custom container exists for the tenant yet, avoid showing global custom container entities
    BEGIN
        -- create a new custom container and store the ownership information in UMSecurityAssociations table
        SET @custom_container_guid = NEWID()
        SET @l_customEntityGuid = @custom_container_guid
        INSERT INTO DM2Container (
            containerGuid, containerName, containerType,
             userId, attribute, comment,
             origCommcellID, createTime)
        VALUES (
@custom_container_guid,'Custom Entity', 9517,
            @i_userId,0, 'Custom Entity',
            0, GETUTCDATE())
        SET @o_errorCode = @@ERROR
        SELECT TOP 1 @containerId = containerId FROM DM2Container WHERE containerGuid = @custom_container_guid
        IF @o_errorCode > 0
        BEGIN
            SELECT @o_entityId = 0, @o_errorMsg = 'Failed to create new entity. New Custom container creation failed.', @o_errorCode = 11503 -- ENTITY_UPDATION_FAILED_DB_ERROR = 11503
            GOTO EXITBLOCK
        END
        -- parent child category hierarchy
        -- Custom parent category
        DECLARE @parentCategoryGuid VARCHAR(40)
        DECLARE @classifierParentCategoryGuid VARCHAR(40)
        SELECT @parentCategoryGuid = @DEFAULT_CUSTOM_PARENT_CONTAINER_GUID
        SELECT @classifierParentCategoryGuid = @DEFAULT_CLASSIFIER_PARENT_CONTAINER_GUID
        -- Custom to Custom Entity category hierarchy
        IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE containerGuid = @parentCategoryGuid AND TagValue = @l_customEntityGuid)
        BEGIN
            INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute)
            SELECT NEWID(), @parentCategoryGuid, @l_customEntityGuid, '', 1, 'Administrator', 2
        END
        -- Classifiers to Custom Entity category hierarchy
        IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE containerGuid = @classifierParentCategoryGuid AND TagValue = @l_customEntityGuid)
        BEGIN
            INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute)
            SELECT NEWID(), @classifierParentCategoryGuid, @l_customEntityGuid, '', 1, 'Administrator', 2
        END
        -- store ownership information
        -- get Tenant Admin, Tenant Operator and Tenant Users group for user organization
        DECLARE @permissionsList    NVARCHAR(MAX) = N''
        --
        -- Get list of permissions depending on the entity type
        SELECT @permissionsList = CAST(A.capabilityId AS VARCHAR(10)) + ',' + @permissionsList FROM UMDM2EntityCapability A, UMPermissions B
WHERE A.entityType = 9517 AND A.capabilityId = B.id
        Group By A.CapabilityId
        DECLARE @o_ErrorString nvarchar(max)
        DECLARE @tenant_admin_group int = 0
        DECLARE @tenant_operator_group int = 0
        DECLARE @tenant_user_group int = 0
        -- get all the tenant groups part of this organization
SELECT @tenant_admin_group = id FROM UMGroups WHERE umdsProviderId = @organizationId AND (groupFlags & 0x10000 = 0x10000)
SELECT @tenant_operator_group = id FROM UMGroups WHERE umdsProviderId = @organizationId AND (groupFlags & 0x40000 = 0x40000)
SELECT @tenant_user_group = id FROM UMGroups WHERE umdsProviderId = @organizationId AND name = 'Tenant Users' -- not aware of any group flags for tenant users group
        -- get logged in tenant parent group
        DECLARE @loggedin_tenant_group INT = 0
        DECLARE @tempMemberUserGroup TABLE (id INT)
        INSERT INTO @tempMemberUserGroup
        exec sec_getMemberUserGroupsWrapper @i_userId
        SELECT TOP 1 @loggedin_tenant_group = id FROM @tempMemberUserGroup where id in (@tenant_admin_group, @tenant_operator_group, @tenant_user_group)
        -- set tenant parent group as creator of entity
EXEC sec_setCreatorForEntity @i_userId, 0, @permissionsList, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 9517, @containerId,0,0,0,0,0,0,0,0,@loggedin_tenant_group
        -- set permissons on rest of tenant groups
        IF @tenant_admin_group <> @loggedin_tenant_group
EXEC sec_insertSecurityAssociation @i_userId, 0, @permissionsList, 0, @tenant_admin_group, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 9517, @containerId
        IF @tenant_operator_group <> @loggedin_tenant_group
EXEC sec_insertSecurityAssociation @i_userId, 0, @permissionsList, 0, @tenant_operator_group, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 9517, @containerId
        IF @tenant_user_group <> @loggedin_tenant_group
EXEC sec_insertSecurityAssociation @i_userId, 0, @permissionsList, 0, @tenant_user_group, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 9517, @containerId
    END
  END
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  IF @i_operationType = 0
  BEGIN
  -- in case of system defined entity disable opertion, disable all the child as well
    IF @enabled = 0 AND EXISTS(SELECT TOP 1 EntityID FROM EntityAnnotator WHERE EntityID=@entityId AND (Attribute & @SYSTEM_DEFINED_ENTITY) =  @SYSTEM_DEFINED_ENTITY)
    BEGIN
      UPDATE EntityAnnotator SET Enabled = 0 WHERE ParentEntityID = @entityId
    END
    IF @entityId = 0
    BEGIN
      INSERT INTO EntityAnnotator(Name, Description, Enabled, ParentEntityID, RegularExpression, Flags, AnnotatorXML, CreateTime, ModifiedTime, EntityType, EntityKey, EntityGUID)
      VALUES(@entityName, @description, @enabled, @parentEntityID, @regularExpression, @flags, @annotatorXML, GETUTCDATE(), NULL, @entityType, @entityKey, NEWID())
      SELECT @o_errorCode = @@ERROR, @o_entityId = SCOPE_IDENTITY()
      IF @o_errorCode > 0
      BEGIN
          SELECT @o_entityId = 0, @o_errorMsg = 'Failed to save entity details for entity ['+ @entityName +']', @o_errorCode = 11503 -- ENTITY_UPDATION_FAILED_DB_ERROR = 11503
          GOTO EXITBLOCK
      END
      --add new entity mapped to custom entity container,
      --
      IF(@o_entityId > 0)
      BEGIN
IF EXISTS(SELECT containerGuid FROM DM2Container WITH(NOLOCK) WHERE containerType = 9517 AND containerGuid = @l_customEntityGuid)
        BEGIN
          INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute)
          SELECT NEWID(), @l_customEntityGuid, @o_entityId, @entityName ,1 /*yea hardcoded*/, 'Custom', 0
        END
      END
    END
    ELSE  -- Update entity
    BEGIN
      SELECT @existingAnnotatorXML = AnnotatorXML FROM EntityAnnotator WHERE EntityID=@entityId
      DECLARE @isUserOverrideAttribute int = 0
      SET @isSystemDefinedEntity = 0 -- we will decide whether system defined or not based on attribute flag
      --for systemdefined entity, always update the user_overridden flag to 1
      --
      SET @existingAttribute  = ISNULL((SELECT TOP 1 Attribute FROM EntityAnnotator where EntityID = @entityId),0)
      IF ((@existingAttribute & @SYSTEM_DEFINED_ENTITY) =  @SYSTEM_DEFINED_ENTITY)
      BEGIN
        SET @isUserOverrideAttribute = @USER_OVERRIDDEN
        SET @isSystemDefinedEntity = 1
      END
      -- check if the custom entity belongs to the user's custom entity container or not
      IF @isSystemDefinedEntity = 0 AND NOT EXISTS(SELECT 1 FROM DM2DocTags where containerGuid=@l_customEntityGuid AND TagValue = CAST(@entityId AS VARCHAR(40)))
      BEGIN
          SELECT @o_errorMsg = 'Failed to update entity [' + @entityName + ']. User does not have sufficient permissions on this entity.', @o_errorCode = 11504 -- ENTITY_UPDATION_FAILED_DB_ERROR = 11504
          GOTO EXITBLOCK
      END
      UPDATE EntityAnnotator
      SET EntityType = CASE WHEN @isUserOverrideAttribute = 1 THEN EntityType ELSE @entityType END,
          Name = CASE WHEN @entityName IS NULL THEN Name ELSE @entityName END,
          Enabled = CASE WHEN @enabled IS NULL THEN Enabled ELSE @enabled END,
          ParentEntityID = CASE WHEN @parentEntityID IS NULL THEN ParentEntityID ELSE @parentEntityID END,
          RegularExpression = CASE WHEN @regularExpression IS NULL THEN RegularExpression ELSE @regularExpression END,
          Description = CASE WHEN @description IS NULL THEN Description ELSE @description END,
          Attribute = @existingAttribute | @isUserOverrideAttribute,
          AnnotatorXML = (
            SELECT
            @isSystemDefinedEntity as '@isSystemDefinedEntity',
            CASE WHEN @proximityRange IS NULL THEN @existingAnnotatorXML.value('/entityXML[1]/@proximityRange','int') ELSE @proximityRange end as '@proximityRange',
            CASE WHEN @keywords IS NULL THEN @existingAnnotatorXML.value('/entityXML[1]/@keywords','nvarchar(max)') ELSE @keywords end as '@keywords',
            CASE WHEN @inheritBaseWords IS NULL THEN @existingAnnotatorXML.value('/entityXML[1]/@inheritBaseWords','bit') ELSE @inheritBaseWords end as '@inheritBaseWords',
            CASE WHEN @sensitivity IS NULL THEN @existingAnnotatorXML.value('/entityXML[1]/@sensitivity','int') ELSE @sensitivity end as '@sensitivity',
            CASE WHEN @entityKey IS NULL THEN @existingAnnotatorXML.value('/entityXML[1]/@entityKey','nvarchar(1024)') ELSE @entityKey end as '@entityKey',
            CASE WHEN @entityType = @CLASSIFIER_TYPE and @isSystemDefinedEntity=0 THEN @classifierDetails.query('/classifierDetails') end
           for xml path('entityXML')
          ),
          ModifiedTime = GETUTCDATE(),
          Flags = CASE WHEN @flags IS NULL THEN Flags ELSE @flags END
      WHERE EntityID = @entityId
      --
      -- Update the TagDesc since we derive the displayName from that column.
      --
      UPDATE DM2DocTags
      SET TagDesc = CASE WHEN @entityName IS NULL THEN TagDesc ELSE @entityName END
      WHERE containerGuid = @l_customEntityGuid AND TagValue = CAST(@entityId AS VARCHAR(40))
      SELECT @o_errorCode = @@ERROR
      IF @o_errorCode > 0
      BEGIN
        SELECT @o_errorMsg = 'Failed to update entity [' + @entityName + ']', @o_errorCode = 11503 -- ENTITY_UPDATION_FAILED_DB_ERROR = 11503
        GOTO EXITBLOCK
      END
      SET @o_entityId = @entityId
    END
  END
  ELSE IF @i_operationType = 1
  BEGIN
    -- for custom entities or derived entities simply delete it
    --
    IF NOT EXISTS(SELECT TOP 1 EntityId FROM EntityAnnotator
          where EntityID = @entityId AND ((Attribute & @SYSTEM_DEFINED_ENTITY) =  @SYSTEM_DEFINED_ENTITY))
    BEGIN
        --Remove dm2doctags and then entityannotator
        --
      -- check if the custom entity belongs to the user's custom entity container or not
      IF NOT EXISTS(SELECT 1 FROM DM2DocTags where containerGuid=@l_customEntityGuid AND TagValue = CAST(@entityId AS VARCHAR(40)))
      BEGIN
          SELECT @o_errorMsg = 'Failed to delete entity. User does not have sufficient permissions on this entity.', @o_errorCode = 11504 -- INSUFFICIENT_USER_PERMISSION_ON_ENTITY = 11504
          GOTO EXITBLOCK
      END
        DELETE DT
        FROM DM2DocTags DT
            INNER JOIN DM2Container DC
            ON	DC.containerGuid = DT.containerGuid
AND DC.containerType in (9516, 9520)
              AND DT.TagValue = CAST(@entityId AS nvarchar(512))
        DELETE FROM EntityAnnotator WHERE EntityID=@entityId
    END
    ELSE
      BEGIN
        -- for system defined entities, mark it as disabled and delete all the derived entities for this entity
        UPDATE EntityAnnotator SET Enabled = 0 WHERE EntityID=@entityId
        -- deleting derived entities depeneded on deleted base entity
        DELETE FROM EntityAnnotator WHERE ParentEntityID=@entityId AND ((Attribute & @SYSTEM_DEFINED_ENTITY) <>  @SYSTEM_DEFINED_ENTITY)
        -- disable all the derived entities which are system defined entities as well
        UPDATE EntityAnnotator SET Enabled = 0 WHERE ParentEntityID=@entityId AND ((Attribute & @SYSTEM_DEFINED_ENTITY) =  @SYSTEM_DEFINED_ENTITY)
        SELECT @o_errorCode = @@ERROR, @o_entityId = @entityId
      END
  END
COMMIT TRAN
END TRY
--------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
  -- Call procedure to print error information.
  -- Call procedure to get error information.
  EXECUTE dbo.GetError @o_errorMsg OUTPUT , @o_errorCode OUTPUT
END CATCH;
EXITBLOCK:
  IF XACT_STATE() <> 0
  BEGIN
    ROLLBACK TRANSACTION;
  END
SELECT @o_errorCode AS o_errorCode, @o_errorMsg AS o_errorMsg, @o_entityId AS o_entityId
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateEntitiesForEE')
	delete from GxQscripts where name = 'UpdateEntitiesForEE'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateEntitiesForEE')
	delete from GXDBVersions where aliasname = 'UpdateEntitiesForEE'
GO

insert into GXDBVersions values(2, 'UpdateEntitiesForEE',  'v1.1.6.17.8.1', 'UpdateEntitiesForEE', 'v1.1.6.17.8.1')
GO

