

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateDCStoreItemCache.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UpdateDCStoreItemCache <<<'

IF EXISTS (select * from sysobjects where name='UpdateDCStoreItemCache')
	drop procedure UpdateDCStoreItemCache
IF EXISTS (select * from GxQscripts where name='UpdateDCStoreItemCache')
	delete from GxQscripts where name = 'UpdateDCStoreItemCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateDCStoreItemCache')
	delete from GXDBVersions where aliasname = 'UpdateDCStoreItemCache'
GO
print '... Creating Procedure: UpdateDCStoreItemCache'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UpdateDCStoreItemCache
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML,
  @flags INT = 0
AS
  DECLARE @response xml
SET NOCOUNT ON
DECLARE @errorCode INT = 0
DECLARE @errorMsg NVARCHAR(MAX) = ''
IF object_id('tempdb.dbo.#StoreItems') is not null DROP TABLE #StoreItems
CREATE TABLE #StoreItems(GUID nvarchar(256), Type NVARCHAR(200), Revision NVARCHAR(256), packageId INT, platformId INT, whatsnew NVARCHAR(MAX))
INSERT INTO #StoreItems
SELECT
	csInfo.n.value('@id','nvarchar(256)'),
	csInfo.n.value('@type','NVARCHAR(200)'),
	csInfo.n.value('@revision','NVARCHAR(256)'),
	csInfo.n.value('@packageId','INT'),
	csInfo.n.value('@platformId','INT'),
	csInfo.n.value('@whatsNew','NVARCHAR(MAX)')
FROM @request.nodes('/WebReport_StoreItemResp/items') AS csInfo(n)
DECLARE @UpdateDCStoreItemCacheTran INT = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION UpdateDCStoreItemCacheTran
		SET @UpdateDCStoreItemCacheTran = 1
	END
	MERGE DCStoreItemCache DC
	USING #StoreItems T
		ON T.GUID = DC.guid
	WHEN MATCHED AND DC.remoteRevision <> T.Revision THEN
		UPDATE SET DC.remoteRevision = T.Revision, DC.whatsNew = T.whatsnew
	WHEN NOT MATCHED BY TARGET THEN
		INSERT (packageId, platformId, guid, type, remoteRevision, whatsNew)
		VALUES (T.packageId, T.platformId, T.GUID, T.Type, T.Revision, T.whatsnew);
	IF (ISNULL(@flags, 0) = 0)	--Full sync from CVD. Do cleanup
		DELETE FROM DCStoreItemCache WHERE guid NOT IN (SELECT GUID FROM #StoreItems)
	IF (@UpdateDCStoreItemCacheTran = 1)
	BEGIN
		COMMIT TRANSACTION UpdateDCStoreItemCacheTran
		SET @UpdateDCStoreItemCacheTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (XACT_STATE() <> 0)
	BEGIN
		IF (@UpdateDCStoreItemCacheTran = 1)
		BEGIN
			ROLLBACK TRANSACTION UpdateDCStoreItemCacheTran
			SET @UpdateDCStoreItemCacheTran = 0
		END
		SELECT @ErrorCode = 1
		SELECT @errorMsg = 'Failed to update software store items cache with error :: ' + ERROR_MESSAGE()
	END
END CATCH
SET @response = (SELECT (SELECT @errorCode AS '@errorCode', @errorMsg AS '@errorMessage' FOR XML PATH('msg'), Type) FOR XML PATH('WebReport_StoreItemResp'))
IF object_id('tempdb.dbo.#StoreItems') is not null DROP TABLE #StoreItems
SELECT @response AS 'response'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateDCStoreItemCache')
	delete from GxQscripts where name = 'UpdateDCStoreItemCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateDCStoreItemCache')
	delete from GXDBVersions where aliasname = 'UpdateDCStoreItemCache'
GO

insert into GXDBVersions values(2, 'UpdateDCStoreItemCache',  '00010001000200070000', 'UpdateDCStoreItemCache', '00010001000200070000')
GO

