

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateCloudAppsLicensingInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: spakhare
--	Date:   25/03/2020
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateCloudAppsLicensingInfo.sp,v $ $Id: UpdateCloudAppsLicensingInfo.sp,v 1.1.2.1 2020/04/01 20:56:23 spakhare Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='UpdateCloudAppsLicensingInfo')
BEGIN
	print '>>> Drop Stored Procedure: UpdateCloudAppsLicensingInfo <<<'
	drop procedure UpdateCloudAppsLicensingInfo
END
IF EXISTS (select * from GxQscripts where name='UpdateCloudAppsLicensingInfo')
	delete from GxQscripts where name = 'UpdateCloudAppsLicensingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCloudAppsLicensingInfo')
	delete from GXDBVersions where aliasname = 'UpdateCloudAppsLicensingInfo'
GO
print '... Creating Procedure: UpdateCloudAppsLicensingInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UpdateCloudAppsLicensingInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inXml XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN TRANSACTION
BEGIN TRY
  DECLARE @outputXML NVARCHAR(MAX)
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	IF OBJECT_ID('tempdb.dbo.#cloudAppsLicesingInfo') IS NOT NULL
		DROP TABLE #cloudAppsLicesingInfo
	CREATE TABLE #cloudAppsLicesingInfo(instanceId INT, backupsetId INT, subclientId INT, userName NVARCHAR(512), email NVARCHAR(512), name NVARCHAR(512), isActive INT, flags BIGINT)
	INSERT INTO #cloudAppsLicesingInfo(instanceId, backupsetId, subclientId, userName, email, name, isActive, flags)
	SELECT r.n.value('entity[1]/@instanceId', 'INTEGER') AS instanceId,
	ISNULL(r.n.value('entity[1]/@backupsetId', 'INTEGER'), 0) AS backupsetId,
	ISNULL(r.n.value('entity[1]/@subclientId', 'INTEGER'), 0) AS subclientId,
	r.n.value('@userName', 'NVARCHAR(512)') AS userName,
	r.n.value('@email', 'NVARCHAR(512)') AS email,
	r.n.value('@name', 'NVARCHAR(512)') AS name,
	r.n.value('@isActive', 'INTEGER') AS isActive,
	ISNULL(r.n.value('@flags', 'INTEGER'), 0) AS flags
	FROM @inXml.nodes('App_CloudAppsLicensingInfos/licensingInfos') r(n)
	WHERE r.n.value('entity[1]/@instanceId', 'INTEGER') <> 0
	-- update backupsetIds to default backupsetId if backupsetId is 0
	UPDATE caLic
	SET backupsetId = bk.id
	FROM #cloudAppsLicesingInfo caLic
	INNER JOIN APP_Application app WITH (NOLOCK) ON app.instance = caLic.instanceId
INNER JOIN APP_BackupSetName bk WITH (NOLOCK) ON bk.id = app.backupSet AND bk.status & 0x00008 = 0x00008
	WHERE caLic.backupsetId = 0
	-- insert non existing users based on userName, backupsetId & instanceId field
	INSERT INTO CloudAppsLicensingInfo (instanceId, backupsetId, subclientId, userName, name, email, isActive, flags)
	SELECT caLic.instanceId, caLic.backupsetId, caLic.subclientId, caLic.userName, caLic.name, caLic.email, caLic.isActive, caLic.flags
	FROM #cloudAppsLicesingInfo caLic
	LEFT OUTER JOIN CloudAppsLicensingInfo cLic WITH (NOLOCK) ON cLic.userName = caLic.userName
	AND cLic.instanceId = caLic.instanceId AND cLic.backupsetId = caLic.backupsetId
	WHERE cLic.backupsetId IS NULL AND cLic.userName IS NULL
	-- update isActive, name & email fields based on userName, backupsetId & instanceId field
	UPDATE capps
	SET capps.isActive = T.isActive, capps.name = T.name, capps.email = T.email
	FROM CloudAppsLicensingInfo capps
	INNER JOIN (
		SELECT ca.instanceId, ca.backupsetId, ca.userName, ca.email, ca.name, ca.isActive FROM #cloudAppsLicesingInfo ca
		LEFT OUTER JOIN CloudAppsLicensingInfo capps
		ON capps.instanceId = ca.instanceId AND capps.backupsetId = ca.backupsetId
		AND capps.userName = ca.userName AND capps.isActive = ca.isActive AND capps.name = ca.name AND capps.email = ca.email
		WHERE capps.isActive IS NULL OR capps.name IS NULL OR capps.email IS NULL
	) T ON T.instanceId = capps.instanceId AND T.backupsetId = capps.backupsetId AND T.userName = capps.userName
	COMMIT TRANSACTION
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
		IF @@TRANCOUNT > 0
			ROLLBACK TRANSACTION
	END CATCH
	SET @outputXML = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('App_GenericResp'))
	SELECT @outputXML
	IF OBJECT_ID('tempdb.dbo.#cloudAppsLicesingInfo') IS NOT NULL
		DROP TABLE #cloudAppsLicesingInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateCloudAppsLicensingInfo')
	delete from GxQscripts where name = 'UpdateCloudAppsLicensingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCloudAppsLicensingInfo')
	delete from GXDBVersions where aliasname = 'UpdateCloudAppsLicensingInfo'
GO

insert into GXDBVersions values(2, 'UpdateCloudAppsLicensingInfo',  '00010001000200010000', 'UpdateCloudAppsLicensingInfo', '00010001000200010000')
GO

