

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateCheckPointInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   06/12/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateCheckPointInfo.sp,v $ $Id: UpdateCheckPointInfo.sp,v 1.1.2.6 2020/08/05 00:51:57 sbhukar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='UpdateCheckPointInfo')
BEGIN
	print '>>> Drop Stored Procedure: UpdateCheckPointInfo <<<'
	drop procedure UpdateCheckPointInfo
END
IF EXISTS (select * from GxQscripts where name='UpdateCheckPointInfo')
	delete from GxQscripts where name = 'UpdateCheckPointInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCheckPointInfo')
	delete from GXDBVersions where aliasname = 'UpdateCheckPointInfo'
GO
print '... Creating Procedure: UpdateCheckPointInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UpdateCheckPointInfo
  @i_xml XML
AS
IF (SELECT CAST(ISNULL(value,0) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Enable Index Pruning' AND modified = 0) > 0 --ENABLE_INDEX_PRUNING
BEGIN
	IF object_id('tempdb.dbo.#checkPointInfo') is not null
		DROP TABLE #checkPointInfo
	CREATE TABLE #checkPointInfo(dbName NVARCHAR(36), startTime BIGINT, endTime BIGINT, checkpointJobId BIGINT, afileId BIGINT, commcellId BIGINT,
									backupsetGUID uniqueidentifier , checkpointName NVARCHAR(MAX), adjustCtime INT)
	IF object_id('tempdb.dbo.#validCheckPointAfile') is not null
		DROP TABLE #validCheckPointAfile
	CREATE TABLE #validCheckPointAfile(afileId BIGINT, commcellId BIGINT, dbName NVARCHAR(36), backupsetGUID uniqueidentifier, startTime BIGINT, endTime BIGINT, adjustCtime INT)
	CREATE CLUSTERED INDEX validCheckPointAfile_idx1 ON #validCheckPointAfile (afileId, commcellId, adjustCtime)
	INSERT INTO #checkPointInfo
	SELECT ISNULL(N.value(N'@appGUID', N'NVARCHAR(36)'),''),
		ISNULL(N.value(N'@prunedCheckpointStartTime', N'BIGINT'),0),
		ISNULL(N.value(N'@prunedCheckpointEndTime', N'BIGINT'),0),
		ISNULL(N.value(N'@checkpointJobId', N'BIGINT'),0),
		ISNULL(N.value(N'../@afileId', N'BIGINT'),0),
		ISNULL(N.value(N'../@commcellId', N'BIGINT'),0),
		NULL,
		'',
		ISNULL(N.value(N'../@adjustCtime', N'INT'),0)
		FROM @i_xml.nodes (N'Indexing_SetIdxDbStatusForCheckPoint/dbs/apps') AS T(N);
	-- StartTime of a checkpoint has to be greater than 0
	DELETE FROM #checkPointInfo WHERE startTime = 0
	UPDATE tmp SET tmp.backupsetGUID = BN.GUID ,
	tmp.checkpointName = 'IdxCheckPoint_' + CAST(BN.GUID AS VARCHAR(36)) + ':' + tmp.dbName
	FROM #checkPointInfo tmp JOIN APP_Application APP WITH (NOLOCK) ON tmp.dbName = App.GUID
	JOIN APP_BackupSetName BN WITH (NOLOCK) ON App.backupSet = BN.id
	--Only insert subclient level index
	--This is to handle MA which are not upgraded yet to SP20. Delete this later on
	INSERT INTO App_IndexCheckpointInfo(dbName, backupSetGUID, afileId, commcellId, startTime, endTime, flags)
	SELECT DISTINCT info.dbName, info.backupsetGUID, AF.id, AF.commCellId, startTime ,endTime, 1
	FROM Archfile AF WITH(NOLOCK) JOIN #checkPointInfo info ON AF.jobId = info.checkpointJobId AND cs_afname = CHECKSUM(info.checkpointName) AND AF.name = info.checkpointName
	JOIN App_IndexDBInfo dbInfo WITH (NOLOCK) ON dbInfo.DbName = info.dbName
	WHERE AF.isValid = 1 AND dbo.isSubClientIndexEnabled(dbInfo.backupSetId) = 1 AND info.afileId = 0
	--This is to handle MA which are on sp20 and higher
	INSERT INTO #validCheckPointAfile
	SELECT AF.id, AF.commCellId, info.dbName, info.backupsetGUID, startTime ,endTime, info.adjustCtime
	FROM Archfile AF WITH(NOLOCK)
	JOIN #checkPointInfo info ON AF.id = info.afileId AND AF.commCellId = info.commCellId
	JOIN App_IndexDBInfo dbInfo WITH (NOLOCK) ON dbInfo.DbName = info.dbName
	WHERE AF.isValid = 1 AND dbo.isSubClientIndexEnabled(dbInfo.backupSetId) = 1 AND info.afileId > 0
	INSERT INTO App_IndexCheckpointInfo(dbName, backupSetGUID, afileId, commcellId, startTime, endTime, flags)
	SELECT DISTINCT dbName, backupsetGUID, afileId, commCellId, startTime ,endTime, 1
	FROM #validCheckPointAfile
	UPDATE Archfile SET cTime = endTime
	FROM #validCheckPointAfile tmp
	WHERE Archfile.isValid = 1 AND Archfile.id = tmp.afileId AND Archfile.commcellId = tmp.commcellId AND tmp.adjustCtime > 0
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'UpdateCheckPointInfo')
	delete from GxQscripts where name = 'UpdateCheckPointInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCheckPointInfo')
	delete from GXDBVersions where aliasname = 'UpdateCheckPointInfo'
GO

insert into GXDBVersions values(2, 'UpdateCheckPointInfo',  '00010001000200060000', 'UpdateCheckPointInfo', '00010001000200060000')
GO

