

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateArchCheckStatusForRunningJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateArchCheckStatusForRunningJobs.sp,v $ $Id: UpdateArchCheckStatusForRunningJobs.sp,v 1.1.54.1 2018/03/22 00:56:27 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='UpdateArchCheckStatusForRunningJobs')
BEGIN
	print '>>> Drop Stored Procedure: UpdateArchCheckStatusForRunningJobs <<<'
	drop procedure UpdateArchCheckStatusForRunningJobs
END
IF EXISTS (select * from GxQscripts where name='UpdateArchCheckStatusForRunningJobs')
	delete from GxQscripts where name = 'UpdateArchCheckStatusForRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateArchCheckStatusForRunningJobs')
	delete from GXDBVersions where aliasname = 'UpdateArchCheckStatusForRunningJobs'
GO
print '... Creating Procedure: UpdateArchCheckStatusForRunningJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure UpdateArchCheckStatusForRunningJobs
  @i_now integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
	DECLARE @tblRetCode TABLE (retCode int)
	DECLARE @l_commCellId INTEGER
	DECLARE @l_archGroupId INTEGER
	DECLARE @l_archGrpCopyId INTEGER
	DECLARE @l_jobid         INTEGER
	DECLARE	JMAdminCursor CURSOR FOR
	SELECT JA.jobid, JA.commcellid, JA.archGrpID, JA.archGrpCopyID
	FROM JMAdminJobInfoTable JA WITH (READUNCOMMITTED)
			INNER JOIN JMJobInfo J WITH (READUNCOMMITTED)
			ON JA.jobId = J.jobId AND JA.commCellId = J.commCellId
	WHERE J.opType IN ( 31 ) -- ARCHIVECHECK
			AND J.subOpType = 1
	ORDER BY archGrpCopyID
	OPEN	JMAdminCursor
	FETCH NEXT FROM JMAdminCursor
	INTO @l_jobid, @l_commCellId, @l_archGroupId,@l_archGrpCopyId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO @tblRetCode
		EXEC UpdateArchCheckStatus @l_archGroupId, @l_archGrpCopyId, @l_jobid, 31 /*ARCHIVECHECK*/, @i_now
		IF @retVal = 0
			SELECT @retVal = retCode FROM @tblRetCode
		DELETE FROM @tblRetCode
		FETCH NEXT FROM JMAdminCursor
		INTO @l_jobid,@l_commCellId, @l_archGroupId,@l_archGrpCopyId
	END
	CLOSE		JMAdminCursor
	DEALLOCATE	JMAdminCursor
END
SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateArchCheckStatusForRunningJobs')
	delete from GxQscripts where name = 'UpdateArchCheckStatusForRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateArchCheckStatusForRunningJobs')
	delete from GXDBVersions where aliasname = 'UpdateArchCheckStatusForRunningJobs'
GO

insert into GXDBVersions values(2, 'UpdateArchCheckStatusForRunningJobs',  '00010001005400010000', 'UpdateArchCheckStatusForRunningJobs', '00010001005400010000')
GO

