

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateArchCheckStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateArchCheckStatus.sp,v $ $Id: UpdateArchCheckStatus.sp,v 1.26.2.12 2020/12/10 01:13:06 chandru Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateArchCheckStatus')
BEGIN
	print '>>> Drop Stored Procedure: UpdateArchCheckStatus <<<'
	drop procedure UpdateArchCheckStatus
END
IF EXISTS (select * from GxQscripts where name='UpdateArchCheckStatus')
	delete from GxQscripts where name = 'UpdateArchCheckStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateArchCheckStatus')
	delete from GXDBVersions where aliasname = 'UpdateArchCheckStatus'
GO
print '... Creating Procedure: UpdateArchCheckStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateArchCheckStatus
  @i_archGroupId integer,
  @i_copyId integer,
  @i_adminJobId integer,
  @i_adminJobType integer,
  @i_now integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/* Save the result to this table CREATE TABLE #UpdateArchCheckStatusResult (result INT)*/
IF object_id('tempdb.dbo.#tempJobDataStatus') IS NOT null DROP TABLE #tempJobDataStatus
CREATE TABLE #tempJobDataStatus (jobId INT, commCellId INT, archGrpCopyId INT, dataType INT,
			archCheckStatus INT, archCheckEndTime INT, newCheckStatus INT, failedOR INT, checkedOR INT, checkedAND INT, chunkUpdated INT PRIMARY KEY(jobId, commCellId, archGrpCopyId, dataType))
IF object_id('tempdb.dbo.#tempArchCheckFlag') IS NOT null DROP TABLE #tempArchCheckFlag
CREATE TABLE #tempArchCheckFlag (jobId INT, commCellId INT, archGrpCopyId INT, dataType INT,
			failedOR INT, checkedOR INT, checkedAND INT PRIMARY KEY(jobId, commCellId, archGrpCopyId, dataType))
DECLARE @l_SIDBStoreId INTEGER = ISNULL(dbo.GetOptionInt(229570007, @i_adminJobId, 0, 0), 0)
DECLARE @l_jobStartTime INTEGER = 0
DECLARE @l_jobSubOpType INTEGER = 0
SELECT @l_jobSubOpType = subOpType, @l_jobStartTime = jobStartTime
FROM	JMJobInfo WITH (READUNCOMMITTED)
WHERE	jobId = @i_adminJobId
IF (@l_jobSubOpType = 106) --ARCHIVECHECK2
BEGIN
	INSERT INTO #tempJobDataStatus
	SELECT JDS.jobId, JDS.commCellId , JDS.archGrpCopyId, JDS.dataType, JDS.archCheckStatus, JDS.archCheckEndTime, 0, 0, 0, 0xFFFF, 0
	FROM   JMJobDataStats JDS WITH (READUNCOMMITTED)
			INNER JOIN (SELECT	DISTINCT AV.SrcCopyId, AV.BackupJobId, AV.CommCellId, AV.fileType
						FROM	ArchChunkToVerify2 AV WITH (READUNCOMMITTED)
						WHERE	AV.adminJobID = @i_adminJobId
						UNION
						SELECT DISTINCT H.SrcCopyId, H.BackupJobId, H.CommCellId, AF.fileType
						FROM	ArchChunkToVerify2History H WITH (READUNCOMMITTED)
								INNER JOIN archFile AF WITH (READUNCOMMITTED) ON H.archFileId = AF.id AND H.commCellId = AF.commcellId
						WHERE	H.adminJobID = @i_adminJobId ) V ON	JDS.JobID = V.BackupJobId
																AND JDS.archGrpCopyId = V.SrcCopyId
																AND JDS.dataType = V.fileType
																AND JDS.CommCellId = V.CommCellId
WHERE	(JDS.disabled & 256) = 0
			AND JDS.status IN (100,102,103) /*READY, NODATAVALID, PARTIALDATA*/
END
ELSE IF (@l_SIDBStoreId > 0)
BEGIN
	IF object_id('tempdb.dbo.#tempJobs') IS NOT null DROP TABLE #tempJobs
	CREATE TABLE #tempJobs (jobId INT, commCellId INT, archGrpCopyId INT, dataType INT, appId INT PRIMARY KEY(jobId, commCellId, archGrpCopyId, dataType))
	INSERT INTO #tempJobs
	SELECT	DISTINCT V.BackupJobId, V.CommCellId, V.archCopyId, V.fileType, V.AppId
	FROM	ArchChunkToVerify V WITH (READUNCOMMITTED)
	WHERE	V.adminJobID = @i_adminJobId
	UNION
	SELECT	DISTINCT H.BackupJobId, H.CommCellId, H.archCopyId, H.fileType, H.AppId
	FROM	ArchChunkToVerifyHistory H WITH (READUNCOMMITTED)
	WHERE	adminJobID = @i_adminJobId
	INSERT INTO #tempJobDataStatus
    SELECT JDS.jobId, JDS.commCellId , JDS.archGrpCopyId, JDS.dataType, JDS.archCheckStatus, JDS.archCheckEndTime, 0, 0, 0, 0xFFFF, 0
    FROM   JMJobDataStats JDS WITH (READUNCOMMITTED)
			INNER JOIN #tempJobs T ON	JDS.JobID = T.JobID
										AND JDS.archGrpCopyId = T.archGrpCopyId
										AND JDS.dataType = T.dataType
										AND JDS.CommCellId = T.CommCellId
WHERE   (JDS.disabled & 256) = 0
            AND JDS.status IN (100,102,103)/*READY, NODATAVALID, PARTIALDATA*/
			AND JDS.archCheckStatus IN (3 /*ACS_TOBECHECKED*/, 4 /*ACS_PARTCHECKED*/) -- We are marking the jobs as picked in archCHunkToVerifyInsert
	IF object_id('tempdb.dbo.#tempJobs') IS NOT null DROP TABLE #tempJobs
END
ELSE
BEGIN
	IF (@i_copyId = 0 )
	BEGIN
		INSERT INTO #tempJobDataStatus
		SELECT JDS.jobId, JDS.commCellId , JDS.archGrpCopyId, JDS.dataType, JDS.archCheckStatus, JDS.archCheckEndTime, 0, 0, 0, 0xFFFF, 0
		FROM   JMJobDataStats JDS WITH (READUNCOMMITTED)
		WHERE  (JDS.disabled & 256) = 0
				AND JDS.status IN (100,102,103) /*READY, NODATAVALID, PARTIALDATA*/
				AND JDS.archCheckStatus IN (1, 3, 4) -- (ACS_EXPIRED, ACS_TOBECHECKED, ACS_PARTCHECKED)
				AND (JDS.archGrpId = @i_archGroupId)
	END
	ELSE
	BEGIN
		INSERT INTO #tempJobDataStatus
		SELECT JDS.jobId, JDS.commCellId , JDS.archGrpCopyId, JDS.dataType, JDS.archCheckStatus, JDS.archCheckEndTime, 0, 0, 0, 0xFFFF, 0
		FROM   JMJobDataStats JDS WITH (READUNCOMMITTED)
		WHERE  (JDS.disabled & 256) = 0
				AND JDS.status IN (100,102,103) /*READY, NODATAVALID, PARTIALDATA*/
				AND JDS.archCheckStatus IN (1, 3, 4) -- (ACS_EXPIRED, ACS_TOBECHECKED, ACS_PARTCHECKED)
				AND (JDS.archGrpId = @i_archGroupId)
				AND (JDS.archGrpCopyId = @i_copyId)
	END
END
IF (@l_jobSubOpType = 106 /*ARCHIVECHECK2*/) AND (@l_SIDBStoreId > 0)
BEGIN
	INSERT INTO #tempArchCheckFlag
	SELECT	JDS.jobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType, MAX(ACM.flags & 4), MAX(ACM.flags & 2), MIN(ACM.flags & 2)
	FROM	#tempJobDataStatus JDS
			INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobId AND AF.fileType = JDS.dataType AND AF.commCellId = JDS.commCellId AND AF.isValid = 1
			INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND JDS.archGrpCopyId = ACM.archCopyId AND ACM.physicalSize > 0
	GROUP BY JDS.jobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType
END
ELSE IF (@l_SIDBStoreId > 0)
BEGIN
	INSERT INTO #tempArchCheckFlag
	SELECT	JDS.jobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType, MAX(ACM.flags & 4), MAX(ACM.flags & 2), MIN(ACM.flags & 2)
	FROM	#tempJobDataStatus JDS
			INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobId AND AF.fileType = JDS.dataType AND AF.commCellId = JDS.commCellId AND AF.isValid = 1
			INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED)
				ON	AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND JDS.archGrpCopyId = ACM.archCopyId
					AND ACM.physicalSize > 0  AND ACM.modifiedTime >= @l_jobStartTime
	GROUP BY JDS.jobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType
END
ELSE
BEGIN
	INSERT INTO #tempArchCheckFlag
	SELECT	JDS.jobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType, MAX(ACM.flags & 4), MAX(ACM.flags & 2), MIN(ACM.flags & 2)
	FROM	#tempJobDataStatus JDS
			INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobId AND AF.fileType = JDS.dataType AND AF.commCellId = JDS.commCellId
																AND AF.isValid = 1
			INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId
																		AND JDS.archGrpCopyId = ACM.archCopyId AND ACM.physicalSize > 0
	GROUP BY JDS.jobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType
END
UPDATE	JDS
SET		failedOR = ACF.failedOR, checkedOR = ACF.checkedOR, checkedAND = ACF.checkedAND, chunkUpdated = 1
FROM	#tempJobDataStatus JDS
		INNER JOIN #tempArchCheckFlag ACF
					ON JDS.jobId = ACF.jobId AND JDS.commCellId = ACF.commCellId
						AND JDS.dataType = ACF.dataType AND JDS.archGrpCopyId = ACF.archGrpCopyId
IF object_id('tempdb.dbo.#tempArchCheckFlag') IS NOT null DROP TABLE #tempArchCheckFlag
UPDATE	#tempJobDataStatus
SET		newCheckStatus = (CASE WHEN ((failedOR & 4) = 4) THEN 6 -- Update failed jobs
							 WHEN ((checkedAND & 2) = 2 AND newCheckStatus <> 6) THEN 5 -- Update checked jobs
							 WHEN ((checkedOR & 2) = 2 AND newCheckStatus NOT IN (5, 6)) THEN 4 -- Update partially checked jobs
							 ELSE newCheckStatus
						END)
IF (@l_SIDBStoreId > 0)
BEGIN
	DELETE #tempJobDataStatus
	WHERE  newCheckStatus = 0 OR (archCheckStatus = newCheckStatus AND archCheckEndTime > @l_jobStartTime) OR chunkUpdated = 0
END
ELSE
BEGIN
	DELETE #tempJobDataStatus
	WHERE  newCheckStatus = 0 OR archCheckStatus = newCheckStatus
END
INSERT INTO #tempJobDataStatus
SELECT	AF.JobId, AF.CommCellId, AFC.archCopyId, AF.fileType, 0, 0, 5, 0, 0, 0, 1
FROM	#tempJobDataStatus JDS
		INNER JOIN archFile AF WITH (READUNCOMMITTED) ON JDS.JobId = AF.JobID AND JDS.CommCellId = AF.CommCellId AND JDS.dataType != AF.FileType
		INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellID AND JDS.archGrpCopyId = AFC.archCopyId
		LEFT OUTER JOIN #tempJobDataStatus t ON t.jobID = AF.jobID AND t.commcellId = AF.commcellId AND t.archGrpCopyId = AFC.archCopyId AND AF.fileType = t.dataType
WHERE	AF.isValid = 1
		AND t.jobId IS NULL
GROUP BY AF.JobId, AFC.archCopyId, AF.fileType, AF.CommCellId
HAVING	MIN(AFC.isValid) = 1
		AND MAX(AFC.lastChunkNumber) = 0
BEGIN   TRANSACTION
UPDATE	JDS
SET		archCheckStatus = tJDS.newCheckStatus, archCheckEndTime = @i_now, modifiedTime = @i_now,
		disabled = (CASE WHEN (tJDS.newCheckStatus = 5 /*ACS_CHECKED */
								AND JDS.status IN (100,102,103) /*READY, NODATAVALID, PARTIALDATA*/
AND (JDS.disabled & (1 | 64 | 256 | 32768 |
2048 | 4096 | 8192 )) = (1 | 64))
THEN (disabled & (64 | ~1))
						WHEN (tJDS.newCheckStatus = 5 /*ACS_CHECKED */
								AND JDS.status IN (100,102,103) /*READY, NODATAVALID, PARTIALDATA*/
AND (JDS.disabled & (64 | 2048 | 256 )) = (64))
THEN (disabled & ~64)
						ELSE JDS.disabled
					END)
FROM	JMJobDataStats JDS
		INNER JOIN #tempJobDataStatus tJDS
			ON JDS.jobId = tJDS.jobId
			   AND JDS.dataType = tJDS.dataType AND JDS.archGrpCopyId = tJDS.archGrpCopyId
			   AND JDS.commCellId = tJDS.commCellId
IF @i_adminJobId > 0
BEGIN
	DELETE tJDS
	FROM   #tempJobDataStatus tJDS
			INNER JOIN archCheckHistory ACH WITH (READUNCOMMITTED)
				ON  tJDS.jobId = ACH.jobId
					AND tJDS.commCellId = ACH.commCellId
					AND tJDS.archGrpCopyId = ACH.archCopyId
					AND ACH.adminJobId = @i_adminJobId
	INSERT INTO archCheckHistory
	SELECT jobId, commCellId, archGrpCopyId, @i_adminJobId, @i_adminJobType, @i_now, MAX(newCheckStatus), '', 0
	FROM   #tempJobDataStatus
	WHERE  newCheckStatus IN (5, 6) /*ACS_CHECKED, ACS_FAILED  */
	GROUP BY jobId, commCellId, archGrpCopyId
END
SET @retVal = @@ERROR
IF @retVal = 0
   COMMIT   TRANSACTION
IF @retVal <> 0
   ROLLBACK TRANSACTION
IF object_id('tempdb.dbo.#tempJobDataStatus') IS NOT null DROP TABLE #tempJobDataStatus
IF object_id('tempdb.dbo.#tempArchCheckFlag') IS NOT null DROP TABLE #tempArchCheckFlag
IF OBJECT_ID('tempdb..#UpdateArchCheckStatusResult') IS NOT NULL
BEGIN
	INSERT INTO #UpdateArchCheckStatusResult
	SELECT @retVal
END
ELSE
	SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateArchCheckStatus')
	delete from GxQscripts where name = 'UpdateArchCheckStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateArchCheckStatus')
	delete from GXDBVersions where aliasname = 'UpdateArchCheckStatus'
GO

insert into GXDBVersions values(2, 'UpdateArchCheckStatus',  '00010026000200120000', 'UpdateArchCheckStatus', '00010026000200120000')
GO

