

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UMUserGroupAssocTriggerToWorkQueue.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UMUserGroupAssocTriggerToWorkQueue.sp,v $ $Id: UMUserGroupAssocTriggerToWorkQueue.sp,v 1.1.2.9 2020/09/30 02:34:11 xsui Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='UMUserGroupAssocTriggerToWorkQueue')
BEGIN
	print '>>> Drop Stored Procedure: UMUserGroupAssocTriggerToWorkQueue <<<'
	drop procedure UMUserGroupAssocTriggerToWorkQueue
END
IF EXISTS (select * from GxQscripts where name='UMUserGroupAssocTriggerToWorkQueue')
	delete from GxQscripts where name = 'UMUserGroupAssocTriggerToWorkQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UMUserGroupAssocTriggerToWorkQueue')
	delete from GXDBVersions where aliasname = 'UMUserGroupAssocTriggerToWorkQueue'
GO
print '... Creating Procedure: UMUserGroupAssocTriggerToWorkQueue'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UMUserGroupAssocTriggerToWorkQueue
-- Input arguments
  @startTime INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_errorCode int = 0
  DECLARE @o_errorCodeStr nvarchar(1024) = ''
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @rowCnt INT = 0
	DECLARE @WorkToken INT = 33	--WORK_TOKEN_USER_UG_ASSOC_CHANGE
	IF (@startTime = 0)
	BEGIN
		-- set to current time
		SET @startTime = dbo.GetUnixTime(GetUTCDate())
	END
	-- test code - temporary stop processing of trigger rows
	IF EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'UserGroupAssocTriggerRowProccessingStop' AND value = '1')
	BEGIN
		GOTO END_OF_PROC
	END
	-- check whether any new rows are there. If not, dont do anything
	SELECT @rowCnt = COUNT(1) FROM UMUserGroupAssocTriggerRows
	where createdTime<=@startTime
	if (@rowCnt=0)
	begin
		GOTO END_OF_PROC
	end
	-- Get the mongo client Id
	if object_id('tempdb.dbo.#clientList') is not null
	BEGIN
		DROP TABLE #clientList
	END
	Create table #clientList
	(
		clientId integer primary key(clientId)
	)
	 -- Push it to clients which have MQ and Mongodb and webserver package installed
	 Insert into #clientList
	 select c.id from SimInstalledPackages
		inner join App_client C on SimInstalledPackages.clientId = C.Id
and (C.status&2)=0 and simPackageID IN (952, 1604)
		intersect
		select c.id from SimInstalledPackages
		inner join App_client C on SimInstalledPackages.clientId = C.Id
		and (C.status&2)=0 and simPackageID = 954
		INTERSECT
		SELECT c.id FROM SimInstalledPackages
		INNER JOIN App_client C on SimInstalledPackages.clientId = C.Id
		and (C.status&2)=0 and simPackageID = 252 -- N_WIN_PACKAGE_DM2_WEB_SERVICE
	--=========================================================================
	-- From here on actual database updates take place to APP_WorkQueueRequest
	--=========================================================================
	BEGIN TRY
		BEGIN TRANSACTION Update_WorkQueueRequest
		-- Identify all users removed from user groups and check whether users are subscribed to receive updates from shares
		-- If so we have to change their subscription
		If exists(select 1 from UMUserGroupAssocTriggerRows with (nolock)
			where createdTime<=@startTime
			and operationType=3) -- DELETE op
		BEGIN
			UPDATE NTAlertsubscriptions
			SET flags = 0
			FROM NTAlertsubscriptions
			INNER JOIN UMUserGroupAssocTriggerRows ON UMUserGroupAssocTriggerRows.operationType = 3 AND UMUserGroupAssocTriggerRows.userID = NTAlertSubscriptions.userId AND UMUserGroupAssocTriggerRows.createdTime<=@startTime
			INNER JOIN App_SharingUserInfo ON NTAlertsubscriptions.entityId1 = App_SharingUserInfo.shareId
AND NTAlertsubscriptions.EntityType1 = 7987
AND (App_SharingUserInfo.userType = 3 OR App_SharingUserInfo.userType = 4 )
			AND App_SharingUserInfo.sharedTo = UMUserGroupAssocTriggerRows.userGroupId
			AND App_SharingUserInfo.excluded = 0
			AND App_SharingUserInfo.deleted = 0
			AND App_SharingUserInfo.enabled = 1
			-- Do it only for users not associated to share directly.
			LEFT JOIN App_SharingUserInfo UsersSharedTo ON UsersSharedTo.shareId = App_SharingUserInfo.shareId
AND UsersSharedTo.userType = 1
			AND UsersSharedTo.excluded = 0
			AND UsersSharedTo.deleted = 0
			AND UsersSharedTo.enabled = 1
			AND UsersSharedTo.sharedTo = UMUserGroupAssocTriggerRows.userId
			WHERE UsersSharedTo.shareId IS NULL
		END
		-- Insert APP_WorkQueueRequest rows
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT clientId,
			@WorkToken,
			'<CvEntities_UserEntity userId="'+CONVERT(NVARCHAR(10),T.userId)+'"/>',
			@startTime, 0, 0, 0, -1
		FROM #clientList
		CROSS JOIN
		(
			SELECT DISTINCT userID from UMUserGroupAssocTriggerRows
		) T
		-- Need to recompute the quota information for the users/groups getting removed/added. Insert 'ReComputeQuota' property in UmUsersProp table for the modified users.
		DECLARE @inXml XML
		SET @inXml = (SELECT DISTINCT userId as '@id'
						FROM UMUserGroupAssocTriggerRows WITH(NOLOCK)
						FOR XML PATH ('userID'), ROOT('UserList')
					 )
		exec UpdateUserPropForQuota @inXml
		-- Delete all modified rows so that they wont be picked next time.
		DELETE UMUserGroupAssocTriggerRows
		WHERE createdTime<=@startTime
		COMMIT TRANSACTION Update_WorkQueueRequest
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = 1
		SET @o_errorCodeStr = 'APP_WorkQueueRequest CG Trigger Row update failed'
		ROLLBACK TRANSACTION Update_WorkQueueRequest
	END CATCH
END_OF_PROC:
	SELECT @o_errorCode, @o_errorCodeStr
GO

IF EXISTS (select * from GxQscripts where name = 'UMUserGroupAssocTriggerToWorkQueue')
	delete from GxQscripts where name = 'UMUserGroupAssocTriggerToWorkQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UMUserGroupAssocTriggerToWorkQueue')
	delete from GXDBVersions where aliasname = 'UMUserGroupAssocTriggerToWorkQueue'
GO

insert into GXDBVersions values(2, 'UMUserGroupAssocTriggerToWorkQueue',  '00010001000200090000', 'UMUserGroupAssocTriggerToWorkQueue', '00010001000200090000')
GO

