

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UMGetUserGroupList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UMGetUserGroupList.sp,v $ $Id: UMGetUserGroupList.sp,v 1.1.2.4 2018/09/04 03:27:30 njudge Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "UMGetUserGroupList"
--	|	This Procedure gets list of user group that the user belongs
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UMGetUserGroupList <<<'

IF EXISTS (select * from sysobjects where name='UMGetUserGroupList')
	drop procedure UMGetUserGroupList
IF EXISTS (select * from GxQscripts where name='UMGetUserGroupList')
	delete from GxQscripts where name = 'UMGetUserGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UMGetUserGroupList')
	delete from GXDBVersions where aliasname = 'UMGetUserGroupList'
GO
print '... Creating Procedure: UMGetUserGroupList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UMGetUserGroupList
-- Input arguments
  @i_userId INT,
  @i_userGroupType INT = 0
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @userGroupId INTEGER;
  DECLARE @userGroupName NVARCHAR(512);
SELECT DISTINCT id, UMGroups.name
FROM UMGroups WITH(NOLOCK) INNER JOIN
					(
						SELECT groupId FROM UMUserGroup WITH(NOLOCK)  INNER JOIN UMGroups WITH(NOLOCK)  ON UMUserGroup.groupId = UMGroups.id WHERE userId = @i_userId
							UNION
						SELECT umGroupId FROM UMDSGroupMaps WITH(NOLOCK) INNER JOIN UMUserGroup WITH(NOLOCK) ON UMDSGroupMaps.umDSgroupId = UMUserGroup.groupId AND userId = @i_userId
					 ) AS UG
ON UMGroups.id = UG.groupId
WHERE groupFlags & 1 = 1 AND ((@i_userGroupType = 0 ) OR (@i_userGroupType = 1 and umdsProviderId = 0 ) OR (@i_userGroupType = 2 and umdsProviderId <> 0 ))
ORDER BY UMGroups.name
GO

IF EXISTS (select * from GxQscripts where name = 'UMGetUserGroupList')
	delete from GxQscripts where name = 'UMGetUserGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UMGetUserGroupList')
	delete from GXDBVersions where aliasname = 'UMGetUserGroupList'
GO

insert into GXDBVersions values(2, 'UMGetUserGroupList',  '00010001000200040000', 'UMGetUserGroupList', '00010001000200040000')
GO

