

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UMGetApplicationFeatureDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UMGetApplicationFeatureDetails.sp,v $ $Id: UMGetApplicationFeatureDetails.sp,v 1.1.2.2 2016/03/28 21:16:11 abilbrey Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "UMGetApplicationFeatureDetails"
--	|	This Procedure gets My Application Feature Details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UMGetApplicationFeatureDetails <<<'

IF EXISTS (select * from sysobjects where name='UMGetApplicationFeatureDetails')
	drop procedure UMGetApplicationFeatureDetails
IF EXISTS (select * from GxQscripts where name='UMGetApplicationFeatureDetails')
	delete from GxQscripts where name = 'UMGetApplicationFeatureDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UMGetApplicationFeatureDetails')
	delete from GXDBVersions where aliasname = 'UMGetApplicationFeatureDetails'
GO
print '... Creating Procedure: UMGetApplicationFeatureDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UMGetApplicationFeatureDetails
-- Input arguments
  @i_localeId INT, 
  @i_myAppId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_propData XML;
	IF (@i_myAppId = 0)
	BEGIN
		-- Get all My Application Feature Details
		SET @r_propData = ISNULL((
			SELECT
				(SELECT
					af.enumId '@myAppId',
					CASE
						WHEN af.localeMsgId = 0 THEN af.label
						ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, af.localeMsgId, 0, 2)
					END AS '@label',
					dbo.UMFormatMyAuxApplication(af.enumId, @i_localeId)
				FROM
					UMApplicationFeatures af WITH(READUNCOMMITTED)
				WHERE
					af.parentEnumId = 0
					AND af.enumId <> 0
					AND (af.flags & 1) = 1		-- enabled
					AND (af.flags & 2) = 0		-- not hidden
				ORDER BY
					af.enumId ASC
				FOR XML PATh('myApplication'), ROOT('myApplications'), TYPE)
			FOR XML PATH('App_GetMyApplicationFeaturesResponse'), TYPE), '<App_GetMyApplicationFeaturesResponse><myApplications /><App_GetMyApplicationFeaturesResponse />')
	END
	ELSE
	BEGIN
		-- Get specific My Application Feature Details
		SET @r_propData = ISNULL((
			SELECT
				(SELECT
					af.enumId '@myAppId',
					CASE
						WHEN af.localeMsgId = 0 THEN af.label
						ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, af.localeMsgId, 0, 2)
					END AS '@label',
					dbo.UMFormatMyAuxApplication(af.enumId, @i_localeId)
				FROM
					UMApplicationFeatures af WITH(READUNCOMMITTED)
				WHERE
					af.enumId = @i_myAppId
					AND (af.flags & 1) = 1		-- enabled
					AND (af.flags & 2) = 0		-- not hidden
				ORDER BY
					af.enumId ASC
				FOR XML PATh('myApplication'), ROOT('myApplications'), TYPE)
			FOR XML PATH('App_GetMyApplicationFeaturesResponse'), TYPE), '<App_GetMyApplicationFeaturesResponse><myApplications /><App_GetMyApplicationFeaturesResponse />')
	END
	SELECT @r_propData;
GO

IF EXISTS (select * from GxQscripts where name = 'UMGetApplicationFeatureDetails')
	delete from GxQscripts where name = 'UMGetApplicationFeatureDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UMGetApplicationFeatureDetails')
	delete from GXDBVersions where aliasname = 'UMGetApplicationFeatureDetails'
GO

insert into GXDBVersions values(2, 'UMGetApplicationFeatureDetails',  '00010001000200020000', 'UMGetApplicationFeatureDetails', '00010001000200020000')
GO

