

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_SetIndexingV2ClientProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_SetIndexingV2ClientProperty.sp,v $ $Id: TapeImport_SetIndexingV2ClientProperty.sp,v 1.3.12.6 2020/11/19 03:37:21 kbora Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TapeImport_SetIndexingV2ClientProperty')
BEGIN
	print '>>> Drop Stored Procedure: TapeImport_SetIndexingV2ClientProperty <<<'
	drop procedure TapeImport_SetIndexingV2ClientProperty
END
IF EXISTS (select * from GxQscripts where name='TapeImport_SetIndexingV2ClientProperty')
	delete from GxQscripts where name = 'TapeImport_SetIndexingV2ClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_SetIndexingV2ClientProperty')
	delete from GXDBVersions where aliasname = 'TapeImport_SetIndexingV2ClientProperty'
GO
print '... Creating Procedure: TapeImport_SetIndexingV2ClientProperty'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TapeImport_SetIndexingV2ClientProperty
  @i_clientId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @AppTypeId integer
DECLARE @MinCTime integer
DECLARE @MinCTimeInProp INT
DECLARE @MaxCTime integer
DECLARE @MaxCTimeInProp integer
DECLARE @indexingV2PropName nvarchar(512)
	DECLARE AgentListCur Cursor LOCAL For
	SELECT  DISTINCT appTypeId
	FROM 	CCM_TI_MAP_Application
	WHERE   new_clientId = @i_clientId
	OPEN AgentListCur
	FETCH NEXT FROM AgentListCur INTO @AppTypeId
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		SET @indexingV2PropName = dbo.GetIndexingV2PropNameByAppType(@AppTypeId)
		SET @MinCTime 		= ISNULL(
									( SELECT MIN(A.cTime) FROM archFile A
										INNER JOIN APP_Application B ON A.appId = B.id AND B.appTypeId = @AppTypeId
										WHERE B.clientId = @i_clientId AND A.name LIKE '%IdxLogs_V1%'
									) ,0)
		SET @MinCTimeInProp = ISNULL(
									( SELECT created FROM APP_ClientProp
										WHERE attrName = @indexingV2PropName AND componentNameId = @i_clientId AND modified = 0
									), -1)
		IF @MinCTime > 0 AND @MinCTimeInProp = -1
		AND EXISTS( SELECT 1 FROM APP_ClientProp
						WHERE componentNameId = @i_clientId
						AND attrName = 'TapeImportClientProp' AND modified = 0
					   )
		BEGIN
			INSERT INTO APP_ClientProp
			SELECT @i_clientId, @indexingV2PropName, 2, 1, @MinCTime, 0, 0
		END
		ELSE IF @MinCTime > 0 AND @MinCTime < @MinCTimeInProp
		BEGIN
			UPDATE APP_ClientProp
			SET created = @MinCTime
			WHERE attrName = @indexingV2PropName AND componentNameId = @i_clientId AND modified = 0
		END
		-- If client creation API creates indexingV2 property, but actually client has no jobs with v2 indexing then delete it.
		ELSE IF @MinCTime = 0
		BEGIN
			DELETE APP_ClientProp
			WHERE attrName = @indexingV2PropName AND componentNameId = @i_clientId
			AND EXISTS( SELECT 1 FROM APP_ClientProp
						WHERE componentNameId = @i_clientId
						AND attrName = 'TapeImportClientProp' AND modified = 0
					   )
		END
	FETCH NEXT FROM AgentListCur INTO @AppTypeId
	END
/* Setting upgrade time for exchange db for archive files before v11 to kick old browse logic */
SET @MaxCTime = ISNULL(( SELECT MAX(cTime) FROM archFile A WITH (NOLOCK) INNER JOIN APP_Application B WITH (NOLOCK) ON A.appId = B.id
						INNER JOIN CCM_TI_MAP_Application C WITH (NOLOCK) ON C.new_appId = B.id
WHERE B.appTypeId = 53 AND B.clientId = @i_clientId
						AND NOT EXISTS (SELECT 1 FROM archFile D WITH (NOLOCK) WHERE A.jobId = D.jobId AND A.commCellId = D.commCellId AND D.name = 'CV_MS_EXCHANGE_DB_AGENT')), 0)
SET @MaxCTimeInProp = ISNULL (( SELECT attrVal FROM APP_ClientProp WHERE attrName LIKE 'Client Upgrade Time' AND componentNameId = @i_clientId AND modified = 0), -1)
IF @MaxCTime > 0 AND @MaxCTimeInProp = -1
BEGIN
	INSERT INTO APP_ClientProp
	SELECT @i_clientId, 'Client Upgrade Time', 10, @MaxCTime + 1, dbo.GetUnixTime(GETUTCDate()), 0, 0
END
ELSE IF @MaxCTime > 0 AND @MaxCTime > @MaxCTimeInProp
BEGIN
	UPDATE APP_ClientProp
	SET attrVal = @MaxCTime
	WHERE attrName LIKE 'Client Upgrade Time' AND componentNameId = @i_clientId
END
return;
GO

IF EXISTS (select * from GxQscripts where name = 'TapeImport_SetIndexingV2ClientProperty')
	delete from GxQscripts where name = 'TapeImport_SetIndexingV2ClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_SetIndexingV2ClientProperty')
	delete from GXDBVersions where aliasname = 'TapeImport_SetIndexingV2ClientProperty'
GO

insert into GXDBVersions values(2, 'TapeImport_SetIndexingV2ClientProperty',  '00010003001200060000', 'TapeImport_SetIndexingV2ClientProperty', '00010003001200060000')
GO

