

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_MergeOMLInfo.sp] ---------- 

-- -----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- -----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_MergeOMLInfo.sp,v $ $Id: TapeImport_MergeOMLInfo.sp,v 1.3 2014/07/24 20:48:53 kbora Exp $";
--
--  +========================================================================+
--  | Stored Precedure: TapeImport_MergeOMLInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TapeImport_MergeOMLInfo <<<'

IF EXISTS (select * from sysobjects where name='TapeImport_MergeOMLInfo')
	drop procedure TapeImport_MergeOMLInfo
IF EXISTS (select * from GxQscripts where name='TapeImport_MergeOMLInfo')
	delete from GxQscripts where name = 'TapeImport_MergeOMLInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeOMLInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeOMLInfo'
GO
print '... Creating Procedure: TapeImport_MergeOMLInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TapeImport_MergeOMLInfo
  @i_xmlStr xml,
  @MeidaId integer
AS
SET NOCOUNT ON
  DECLARE @CommCellId integer
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
	DECLARE @Application nvarchar(1024)
	DECLARE @BarCode nvarchar(1024)
	DECLARE @CheckSum nvarchar(1024)
	DECLARE @CopyID nvarchar(1024)
	DECLARE @DRPassword nvarchar(1024)
	DECLARE @DRUserName nvarchar(1024)
	DECLARE @FlushBlockSizeKB INT
	DECLARE @LabelGUID nvarchar(1024)
	DECLARE @LabelType nvarchar(1024)
	DECLARE @LabelVersion nvarchar(1024)
	DECLARE @LastMediaBarCode nvarchar(1024)
	DECLARE @LastMediaID nvarchar(1024)
	DECLARE @LastMediaSideName nvarchar(1024)
	DECLARE @MMSCommCellId INT
	DECLARE @MagicNumber nvarchar(1024)
	DECLARE @MediaCreationTime INT
	DECLARE @MediaGroupID nvarchar(1024)
	DECLARE @UniqueMediaID nvarchar(1024)
	DECLARE @MediaName nvarchar(1024)
	DECLARE @SideName nvarchar(1024)
	DECLARE @StoragePolicyId nvarchar(1024)
	DECLARE @Vendor nvarchar(1024)
	DECLARE @VolId INT
	DECLARE @flag bit
	SELECT
	 @Application=(doc.col.value('@Application', 'nvarchar(1024)')),
	 @BarCode=(doc.col.value('@BarCode', 'nvarchar(1024)')),
	 @CheckSum=(doc.col.value('@CheckSum', 'nvarchar(1024)')),
	 @CopyID=(doc.col.value('@CopyID', 'nvarchar(1024)')),
	 @DRPassword=(doc.col.value('@DRPassword', 'nvarchar(1024)')),
	 @DRUserName=(doc.col.value('@DRUserName', 'nvarchar(1024)')),
	 @FlushBlockSizeKB =(doc.col.value('@FriendlyName', 'INT')),
	 @LabelGUID=(doc.col.value('@LabelGUID', 'nvarchar(1024)')),
	 @LabelType=(doc.col.value('@LabelType', 'nvarchar(1024)')),
	 @LabelVersion=(doc.col.value('@LabelVersion', 'nvarchar(1024)')),
	 @LastMediaBarCode=(doc.col.value('@LastMediaBarCode', 'nvarchar(1024)')),
	 @LastMediaID=(doc.col.value('@LastMediaID', 'nvarchar(1024)')),
	 @LastMediaSideName=(doc.col.value('@LastMediaSideName', 'nvarchar(1024)')),
	 @MMSCommCellId=(doc.col.value('@MMSCommCellId', 'INT')),
	 @MagicNumber=(doc.col.value('@MagicNumber', 'nvarchar(1024)')),
	 @MediaCreationTime=(doc.col.value('@MediaCreationTime', 'INT')),
	 @MediaGroupID=(doc.col.value('@MediaGroupID', 'nvarchar(1024)')),
	 @UniqueMediaID=(doc.col.value('@MediaID', 'nvarchar(1024)')),
	 @MediaName=(doc.col.value('@MediaName', 'nvarchar(1024)')),
	 @SideName=(doc.col.value('@SideName', 'nvarchar(1024)')),
	 @StoragePolicyId=(doc.col.value('@StoragePolicyId', 'nvarchar(1024)')),
	 @VolId=(doc.col.value('@VolId', 'INT')),
	 @Vendor=(doc.col.value('@Vendor', 'nvarchar(1024)'))
	FROM @i_xmlStr.nodes('/MediaManager_OMLInfo') doc(col)
BEGIN TRANSACTION TRAN_Merge_OML
	DECLARE @OrigMeidaId INT
	DECLARE @MaxCCId INT
	SET @errorString='Media Lable Information successfully merged into CommServ Database'
--get MediaId from XML
	SELECT @OrigMeidaId=CAST(reverse(substring(reverse(@UniqueMediaID),0,charindex('_',reverse(@UniqueMediaID)))) AS INT)
--Create new CommCell Entry in App_CommCell table if Media is from foreign CommCell
	IF	@MMSCommCellId =-1
	BEGIN
		SET @errorString = 'ERROR:The Media is from Unlicenced CommCell, It Can not be Catalogued  '
		GOTO CX_ERROR_EXIT
	END
	IF NOT EXISTS (
			SELECT id
			FROM APP_CommCell WHERE number=@MMSCommCellId
	)
	BEGIN
		INSERT INTO APP_CommCell VALUES(
		@MMSCommCellId,0,1,'TapeImportedCommCell_',2,0,'','','','','',0,0,'','','',1
		)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: OMLInfo_Merge --Failed to create new entry in App_CommCell table'
			GOTO CX_ERROR_EXIT
		END
		UPDATE APP_CommCell
		SET aliasName=aliasName+CAST(id AS VARCHAR(10))
		WHERE @MMSCommCellId=number
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: OMLInfo_Merge --Failed to update aliasName in App_CommCell table'
			GOTO CX_ERROR_EXIT
		END
	END
	SET @CommCellId = ISNULL ((SELECT id FROM APP_CommCell WHERE number=@MMSCommCellId), 0)
	UPDATE MMMedia
	SET UniqueId=@UniqueMediaID,
		CreationTime=@MediaCreationTime,
		origCCcommCellID=@CommCellId,
		origCCmediaID = CASE WHEN @CommCellId = 2 THEN  mediaId ELSE @OrigMeidaId END -- This is required becuase in same CommCell scenerio in DR case, media id will be different
	FROM MMMedia WHERE MediaId=@MeidaId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: OMLInfo_Merge --Failed to Update MMMedia Table'
		GOTO CX_ERROR_EXIT
	END
	UPDATE MMVolume
	SET origCCvolumeID = CASE WHEN @CommCellId = 2 THEN  volumeId ELSE @VolId END, -- This is required becuase in same CommCell scenerio in DR case, media id will be different
		origCCcommCellID=@CommCellId,
		FlushBlockSizeKB = @FlushBlockSizeKB,
		ReformatTime = @MediaCreationTime
	FROM MMVolume WHERE MediaId=@MeidaId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: OMLInfo_Merge --Failed to Update MMVolume Table'
		GOTO CX_ERROR_EXIT
	END
	IF  EXISTS ( SELECT 1 FROM MMMediaSide WHERE MediaId=@MeidaId )
		BEGIN
			UPDATE MMMediaSide
			SET IsOMLValid=1,
				IsOMLWritten=2
			WHERE MediaId=@MeidaId
		END
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: OMLInfo_Merge --Failed to Update MMMediaSide Table'
		GOTO CX_ERROR_EXIT
	END
	COMMIT  TRANSACTION TRAN_Merge_OML
	SELECT  @CommCellId,0, @errorString
	RETURN	(0)
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TRAN_Merge_OML
	RAISERROR ('%s' , 16, 1, @errorString)
	SELECT @CommCellId,-1, @errorString
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'TapeImport_MergeOMLInfo')
	delete from GxQscripts where name = 'TapeImport_MergeOMLInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeOMLInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeOMLInfo'
GO

insert into GXDBVersions values(2, 'TapeImport_MergeOMLInfo',  '00010003000000000000', 'TapeImport_MergeOMLInfo', '00010003000000000000')
GO

