

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_MergeCMTInfo.sp] ---------- 

-- -----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- -----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_MergeCMTInfo.sp,v $ $Id: TapeImport_MergeCMTInfo.sp,v 1.7.2.16 2020/11/19 03:37:17 kbora Exp $";
--
--  +========================================================================+
--  | Stored Precedure: TapeImport_MergeCMTInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TapeImport_MergeCMTInfo')
BEGIN
	print '>>> Drop Stored Procedure: TapeImport_MergeCMTInfo <<<'
	drop procedure TapeImport_MergeCMTInfo
END
IF EXISTS (select * from GxQscripts where name='TapeImport_MergeCMTInfo')
	delete from GxQscripts where name = 'TapeImport_MergeCMTInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeCMTInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeCMTInfo'
GO
print '... Creating Procedure: TapeImport_MergeCMTInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TapeImport_MergeCMTInfo
  @i_xmlStr xml,
  @CommCellId int,
  @MediaId int
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
------------------ChunkmapTrailer Inofrmation---------------------
DECLARE @CMTVersion TINYINT
DECLARE @TrailerSize VARCHAR(100)
DECLARE @NumberOfArchFilesInChunk INT
DECLARE @CCIdInCMT INT
DECLARE @ChunkId BIGINT
DECLARE @ArchGroupId SMALLINT
DECLARE @CopyId SMALLINT
DECLARE @StreamId INT
DECLARE @MediaGroupId INT
DECLARE @FileMarkNumber INT
DECLARE @VolumeId INT
DECLARE @TotalPhysicalChunkSize BIGINT
DECLARE @TotalLogicalChunkSize BIGINT
DECLARE @GalaxyVersion VARCHAR(100)
DECLARE @uniqueMediaIdString VARCHAR(100)
DECLARE @HwEncKey VARCHAR(100)
DECLARE @SIDBEngineId VARCHAR(100)
DECLARE @MediaSideId INT
--------------------AFile Information -----------------------------
DECLARE @ArchFileId INT
DECLARE @IsArchFileClosed INT
DECLARE @AppId INT
DECLARE @JobId INT
DECLARE @CreateJobId VARCHAR(100)
DECLARE @AppTypeId INT
DECLARE @BackupLevel INT
DECLARE @BackupTime VARCHAR(100)
DECLARE @FileType TINYINT
DECLARE @FileSeqNo VARCHAR(100)
DECLARE @ClientName VARCHAR(100)
DECLARE @ArchiveFileName VARCHAR(MAX)
DECLARE @ChunkSeqNumber INT
DECLARE @PhysicalSizeInChunk BIGINT
DECLARE @LogicalSizeInChunk BIGINT
DECLARE @PhysicalOffsetForChunk BIGINT
DECLARE @LogicalOffsetForChunk BIGINT
DECLARE @EncryptionType INT
DECLARE @NeedPassPhrase INT
DECLARE @DataEncKey NVARCHAR(MAX)
DECLARE @RsaPriKey NVARCHAR(MAX)
DECLARE @ObjNameForNAS VARCHAR(2048)
DECLARE @ObjNameVersionForNAS VARCHAR(100)
DECLARE @ArchCopyEncRSAPriKeyInfo 		XML
DECLARE @ArchCopyEncPriKey 				NVARCHAR(MAX)
DECLARE @ArchCopyEncMasterKey			NVARCHAR(MAX)
DECLARE @ArchCopyEncKeyProviderType 	INT
DECLARE @ArchCopyEncKeyProviderGUID 	UNIQUEIDENTIFIER
DECLARE @ArchCopyEncPubKey 				NVARCHAR(MAX)
DECLARE @ArchCopyEncKeyType				INT
DECLARE @ArchCopyEncKeyLength			INT
DECLARE @ArchCopyEncKeyProviderName		NVARCHAR(1024)
DECLARE @ArchCopyEncKeyProviderId		INT
SET @ArchCopyEncPubKey 			= ''
SET @ArchCopyEncKeyType 		= 3
SET @ArchCopyEncKeyLength 		= 256
SET @ArchCopyEncKeyProviderId 	= 0
--Get ChunkMapTrailer Info
	SELECT
	 @CMTVersion=(doc.col.value('@version', 'TINYINT')),
	 @TrailerSize=(doc.col.value('@trailerSize', 'nvarchar(100)')),
	 @NumberOfArchFilesInChunk=(doc.col.value('@archFileCount', 'INT')),
	 @CCIdInCMT=(doc.col.value('@commCellId', 'nvarchar(100)')),
	 @ChunkId=(doc.col.value('@chunkId', 'BIGINT')),
	 @ArchGroupId=(doc.col.value('@archGroupId', 'SMALLINT')),
	 @CopyId=(doc.col.value('@copyId', 'SMALLINT')),
	 @StreamId=(doc.col.value('@streamId', 'INT')),
	 @MediaGroupId=(doc.col.value('@mediaGroupId', 'INT')),
	 @FileMarkNumber=(doc.col.value('@fileMarkerNo', 'INT')),
	 @VolumeId=(doc.col.value('@volumeId', 'INT')),
	 @TotalPhysicalChunkSize=(doc.col.value('@totalPhysicalSize', 'BIGINT')),
	 @TotalLogicalChunkSize=(doc.col.value('@totalLogicalSize', 'BIGINT')),
	 @GalaxyVersion=(doc.col.value('@galaxyVersion', 'nvarchar(100)')),
	 @uniqueMediaIdString=(doc.col.value('@uniqueMediaId', 'nvarchar(1000)')),
	 @HwEncKey=(doc.col.value('@hwEncKey', 'nvarchar(1000)')),
	 @SIDBEngineId=(doc.col.value('@sidbEngineId', 'nvarchar(1000)'))
	FROM @i_xmlStr.nodes('/MediaManager_ChunkMapTrailerInfo') doc(col)
DECLARE @ClientId INT = -10
DECLARE @SubClientName VARCHAR(100)
DECLARE @ArchGroupName VARCHAR(100)
DECLARE @CopyName VARCHAR(100)
DECLARE @EncKeyLen SMALLINT
DECLARE @ArchFileSize BIGINT
DECLARE @SizeOnMedia BIGINT
DECLARE @NextClientPropId INT
DECLARE @OrigMediaId INT
DECLARE @simOperatingSystemId INT
DECLARE @archFileCopyFlags INT
SELECT @OrigMediaId=CAST(reverse(substring(reverse(@uniqueMediaIdString),0,charindex('_',reverse(@uniqueMediaIdString)))) AS INT)
IF @CommCellId = 2
BEGIN
	SET @OrigMediaId = @MediaId
	IF @VolumeId = 0
		SELECT @VolumeId = VolumeId FROM MMVolume WHERE MediaId = @MediaId
END
SET @MediaSideId = ISNULL ((SELECT MediaSideId FROM MMMediaSide WHERE MediaId = @MediaId), 0)
IF @ArchGroupId = 0
	SET @ArchGroupId = -1
SET @NextClientPropId = 1
DECLARE @dummyGUID VARCHAR(100)
SET @dummyGUID = '00000000-0000-0000-0000-000000000000'
/* If tape has unsupported apptypes bring only supported apptypes to merge phase and skip others. */
IF OBJECT_ID('tempdb..#WinAppTypes') IS NOT NULL
	DROP TABLE #WinAppTypes
CREATE TABLE #WinAppTypes ( appTypeId INT)
INSERT INTO #WinAppTypes
SELECT DISTINCT appTypeId FROM APP_AppTypeGroupAssoc where appGroupId in (
SELECT  appTypeGroupId from APP_AppTypeGroup where groupName like '%windows%')
OR appTypeId IN (106, 53, 54, 13)
UNION
SELECT 1000
IF @@ERROR>0
BEGIN
	SET @errorString='Failed to Insert into WinAppTypes table'
	GOTO RETURN_ERROR
END
IF OBJECT_ID('tempdb..#UnixAppTypes') IS NOT NULL
	DROP TABLE #UnixAppTypes
CREATE TABLE #UnixAppTypes ( appTypeId INT)
INSERT INTO #UnixAppTypes
SELECT DISTINCT appTypeId FROM APP_AppTypeGroupAssoc where appGroupId in (
SELECT appTypeGroupId from APP_AppTypeGroup where groupName like '%unix%')
IF @@ERROR>0
BEGIN
	SET @errorString='Failed to Insert into UnixAppTypes table'
	GOTO RETURN_ERROR
END
------------------------CCM_APP_CommCell Table------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_APP_CommCell)
		BEGIN
			INSERT INTO CommServ_Convert..CCM_APP_CommCell
			SELECT A.* FROM APP_CommCell A WHERE id = @CommCellId
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_APP_CommCell TABLE'
				GOTO RETURN_ERROR
			END
			UPDATE CommServ_Convert..CCM_APP_CommCell
			SET id = 2
			WHERE id = @CommCellId
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO UPDATE CCM_APP_CommCell TABLE'
				GOTO RETURN_ERROR
			END
		END
IF @@ERROR>0
		BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_APP_CommCell TABLE'
				GOTO RETURN_ERROR
		END
-----------------------CCM_APP_CustomCalendar-------------------------------------------------------
IF NOT EXISTS (SELECT * FROM CommServ_Convert..CCM_APP_CustomCalendar)
BEGIN
		INSERT INTO CommServ_Convert..CCM_APP_CustomCalendar VALUES (
			1,'Standard',0,1,0,0,1,1,0,0,2,@dummyGUID )
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_APP_CustomCalendar TABLE'
			GOTO RETURN_ERROR
		END
END
-------------------------------------------CCM_MMVolume-----------------------------------------------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_MMVolume WHERE VolumeId = @VolumeId )
BEGIN
	IF @SIDBEngineId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM IdxSIDBStore WHERE SIDBStoreId = @SIDBEngineId AND @CommCellId = 2)
		BEGIN
			SELECT TOP 1 @SIDBEngineId = SIDBStoreId FROM IdxSIDBStore WHERE SIDBStoreId > 0
		END
	END
	IF @CommCellId = 2 AND NOT EXISTS (SELECT 1 FROM MMVolume WHERE VolumeId = @VolumeId)
	BEGIN
		SET IDENTITY_INSERT MMVolume ON
		INSERT INTO MMVolume
		(
		 VolumeId, VolumeName, CreationTime, VolumeFlags, VolumeInitialized, FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts,
		 NumberOfSoftErrors, NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
		 LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
		 origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId, SiloStatus,
		 CurrMountPathId, FailureErrorCode, MMSpareStatus
		)
		VALUES
		(
		@VolumeId, 'V_' + CAST(@VolumeId AS VARCHAR(64)), dbo.GetUnixTime(getutcdate()), 2, 0, 64, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0,
		0, 10001, '', 2, 0, 0, 0, 0, @CommCellId,
		@VolumeId , @MediaId, @MediaSideId, 0, 0, dbo.GetUnixTime(getutcdate()), -1, 0, @SIDBEngineId, -1, 0, 0, 0
		)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: OMLInfo_Merge --Failed to INSERT MMVolume Table for VolId : '+ CAST(@VolumeId AS VARCHAR(128))
			SET IDENTITY_INSERT MMVolume OFF
			GOTO RETURN_ERROR
		END
		SET IDENTITY_INSERT MMVolume OFF
	END
	INSERT INTO CommServ_Convert..CCM_MMVolume
	SELECT * FROM MMVolume WHERE origCCvolumeId=@VolumeId AND origCCcommCellID = @CommCellId
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to insert into CommServ_Convert..CCM_MMVolume'
		GOTO RETURN_ERROR
	END
	UPDATE 	CommServ_Convert..CCM_MMVolume
	SET		VolumeId = @VolumeId,MediaId = @OrigMediaId,origCCcommCellID = 2
	WHERE 	origCCvolumeId = @VolumeId AND origCCcommCellID = @CommCellId
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CommServ_Convert..CCM_MMVolume'
		GOTO RETURN_ERROR
	END
END
-------------------------------------------CCM_MMMedia-------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_MMMedia WHERE MediaID=@OrigMediaId)
BEGIN
		INSERT INTO CommServ_Convert..CCM_MMMedia
		SELECT * FROM MMMedia WHERE (MediaId = @MediaId AND @CommCellId = 2) OR (origCCmediaId = @OrigMediaId AND origCCcommCellID = @CommCellId)
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to insert into CommServ_Convert..CCM_MMMedia'
			GOTO RETURN_ERROR
		END
		UPDATE 	CommServ_Convert..CCM_MMMedia
		SET		MediaId = @OrigMediaId,origCCcommCellID = 2
		WHERE 	origCCmediaId = @OrigMediaId AND origCCcommCellID = @CommCellId
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to update CommServ_Convert..CCM_MMVolume'
			GOTO RETURN_ERROR
		END
END
---------------------------------------------------------------------------------------------------------------------------------------------
--Get AFile Info
	DECLARE ArchFileInfo_Cursor CURSOR LOCAL FAST_FORWARD FOR
	SELECT
		 (doc.col.value('@ArchFileId', 'INT')),
		 (doc.col.value('@IsArchFileClosed', 'INT')),
		 (doc.col.value('@AppId', 'INT')),
		 (doc.col.value('@JobId', 'INT')),
		 (doc.col.value('@CreateJobId', 'nvarchar(100)')),
		 (doc.col.value('@AppType', 'INT')),
		 (doc.col.value('@BackupLevel', 'INT')),
		 (doc.col.value('@BackupTime', 'nvarchar(100)')),
		 (doc.col.value('@FileType', 'TINYINT')),
		 (doc.col.value('@FileSeqNo', 'nvarchar(100)')),
		 (doc.col.value('@ClientName', 'nvarchar(100)')),
		 (doc.col.value('@ArchiveFileName', 'nvarchar(MAX)')),
		 (doc.col.value('@ChunkSeqNumber', 'INT')),
		 (doc.col.value('@PhysicalSizeInChunk', 'BIGINT')),
		 (doc.col.value('@LogicalSizeInChunk', 'BIGINT')),
		 (doc.col.value('@PhysicalOffsetForChunk', 'BIGINT')),
		 (doc.col.value('@LogicalOffsetForChunk', 'BIGINT')),
		 (doc.col.value('@EncryptionType', 'INT')),
		 (doc.col.value('@NeedPassPhrase', 'INT')),
		 (doc.col.value('@DataEncKey', 'nvarchar(MAX)')),
		 (doc.col.value('@RsaPriKey', 'nvarchar(MAX)')),
		 (doc.col.value('@ObjNameForNAS', 'nvarchar(2048)')),
		 (doc.col.value('@ObjNameVersionForNAS', 'nvarchar(1000)'))
		FROM @i_xmlStr.nodes('/MediaManager_ChunkMapTrailerInfo/ArchFileInfoList') doc(col)
OPEN ArchFileInfo_Cursor
		FETCH NEXT FROM ArchFileInfo_Cursor INTO @ArchFileId,@IsArchFileClosed,@AppId,@JobId,@CreateJobId,
								 @AppTypeId, @BackupLevel, @BackupTime, @FileType, @FileSeqNo, @ClientName, @ArchiveFileName,
								 @ChunkSeqNumber, @PhysicalSizeInChunk, @LogicalSizeInChunk, @PhysicalOffsetForChunk,
								 @LogicalOffsetForChunk, @EncryptionType, @NeedPassPhrase, @DataEncKey, @RsaPriKey, @ObjNameForNAS, @ObjNameVersionForNAS
WHILE (@@FETCH_STATUS = 0)
	BEGIN
	IF NOT EXISTS ( SELECT 1 FROM #WinAppTypes WHERE appTypeId = @AppTypeId)
	   AND NOT EXISTS (SELECT 1 FROM #UnixAppTypes WHERE appTypeId = @AppTypeId)
	GOTO SKIP_APP
	SET @ArchCopyEncRSAPriKeyInfo 	= NULL
	SET @ArchCopyEncPriKey 			= ''
	SET @ArchCopyEncMasterKey 		= ''
	SET @ArchCopyEncKeyProviderType = 0
	SET @ArchCopyEncKeyProviderGUID = NULL
	IF @RsaPriKey LIKE '%RSAPriKeyInfo%'
	BEGIN
		SET @ArchCopyEncRSAPriKeyInfo = CAST (@RsaPriKey AS XML)
		SELECT
			 @ArchCopyEncPriKey 			= (doc.col.value('@PriKey', 'NVARCHAR(MAX)')),
			 @ArchCopyEncMasterKey 			= (doc.col.value('@MasterKeyId', 'NVARCHAR(MAX)')),
			 @ArchCopyEncKeyProviderType 	= (doc.col.value('@KeyProviderType', 'INT')),
			 @ArchCopyEncKeyProviderGUID 	= (doc.col.value('@KeyProviderGUID', 'UNIQUEIDENTIFIER'))
		FROM @ArchCopyEncRSAPriKeyInfo.nodes('/RSAPriKeyInfo') doc(col)
	END
/* There is a customer (TR - 160617-211) who has tapes with data afiles which don't have client name on chunk map trailer files, so we are creating dummy client for all such jobs */
IF @FileType = 1 AND  @ClientName = ''
SET @ClientName = 'TapeImportClient'
/* For NAS data set the correct archFileCopy flags */
SET @archFileCopyFlags = 0
SET @simOperatingSystemId = 0
IF @AppTypeId = 13
BEGIN
	IF @ObjNameForNAS <> 'N/A' AND LEN(@ObjNameForNAS) > 0
	BEGIN
		IF @ObjNameForNAS LIKE '%ACL_START%' OR @ObjNameForNAS LIKE '%ENHANCED_DAR_ENABLED%' OR @ObjNameForNAS LIKE '%LIST_QTREES%'
		OR @ObjNameForNAS LIKE '%NDMP_UNICODE_FH%' OR @ObjNameForNAS LIKE '%CV_ACLS_OFFSET%' OR @ObjNameForNAS LIKE '%CV_OFFSET_MAP%'
		OR @ObjNameForNAS LIKE '%CV_ADS%' OR @ObjNameForNAS LIKE '%CV_FLEXGP%'
SET @simOperatingSystemId = 16
		ELSE
		IF @ObjNameForNAS LIKE '%EMC_OFFLINE_DATA%' OR @ObjNameForNAS LIKE '%SNAPSURE%'
SET @simOperatingSystemId = 17
		ELSE
		IF @ObjNameForNAS LIKE '%BLUEARC%'
SET @simOperatingSystemId = 29
		ELSE
SET @simOperatingSystemId = 19
	END
	IF @PhysicalSizeInChunk = @LogicalSizeInChunk
SET @archFileCopyFlags = 128
	ELSE
SET @archFileCopyFlags = 32
END
-----------------------GetClient Id-----------------------------------------------
	IF EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_APP_Client WHERE name=@ClientName)
		BEGIN
			SELECT @ClientId= id FROM CommServ_Convert..CCM_APP_Client WHERE name=@ClientName
		END
-- This happens when we get index chunk first, and the client name on this chunk is MA's name. So if the subclient exists then get the clientId.
	ELSE IF EXISTS (SELECT 1 FROM CommServ_Convert..CCM_APP_Application WHERE id = @AppId)
		BEGIN
			SELECT @ClientId = clientId FROM CommServ_Convert..CCM_APP_Application WHERE id = @AppId
		END
	ELSE IF EXISTS (SELECT 1 FROM CommServ_Convert..CCM_APP_Client) AND @FileType = 1
		BEGIN
			SELECT @ClientId = MIN(id) FROM CommServ_Convert..CCM_APP_Client
			SET @ClientId = @ClientId - 1
		END
--  ELSE If FileType is index then we don't create client, we use the current client. If there is no current client then we will create new client, later if we get data archfile then we reset the clientId.
----------------------------------------CCM_APP_Client table----------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_APP_Client WHERE id = @ClientId )
		BEGIN
			INSERT INTO CommServ_Convert..CCM_APP_Client VALUES(
						@ClientId,@ClientName, @simOperatingSystemId,'','',0,0,0,0,'','','',0,0,0,0,0,0,0,0,2,@dummyGUID,0,'')
			IF @@ERROR>0
					BEGIN
						SET @errorString='FAILED TO INSERT INTO CCM_APP_Client TABLE'
						GOTO RETURN_ERROR
					END
			SET @NextClientPropId = ISNULL ( (SELECT MAX(id) FROM CommServ_Convert..CCM_APP_ClientProp),1)
			IF @RsaPriKey <> '' AND @RsaPriKey NOT LIKE '%RSAPriKeyInfo%'
			BEGIN
				INSERT INTO CommServ_Convert..CCM_APP_ClientProp VALUES (@NextClientPropId,@ClientId,'Encrypt: rsaPriKeyBPF',1,@RsaPriKey,dbo.GetUnixTime(getutcdate()),0,0)
				IF @@ERROR>0
						BEGIN
							SET @errorString='FAILED TO INSERT INTO CCM_APP_ClientProp TABLE for rsaPriKeyBPF'
							GOTO RETURN_ERROR
						END
				INSERT INTO CommServ_Convert..CCM_APP_ClientProp VALUES (@NextClientPropId+1,@ClientId,'Encrypt: rsaPubKey',	1,	@RsaPriKey,dbo.GetUnixTime(getutcdate()),0,0)
				IF @@ERROR>0
						BEGIN
							SET @errorString='FAILED TO INSERT INTO CCM_APP_ClientProp TABLE for rsaPubKey'
							GOTO RETURN_ERROR
						END
			END
		END
--------------------------------------CCM_APP_Application table--------------------------------------------------------
	IF @AppId=1 AND @CommCellId = 2
		SET @AppTypeId=1000
	IF NOT EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_APP_Application WHERE id=@AppId )
	BEGIN
		SET @SubClientName='TapeImportSubClient_'+CAST(@AppId AS VARCHAR(10))
		INSERT INTO CommServ_Convert..CCM_APP_Application VALUES(
					@AppId,@ClientId,@AppTypeId,0,0,0,@ArchGroupId,@ArchGroupId,0,0,@SubClientName,0,0,0,2,@dummyGUID)
		IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_APP_Application TABLE'
				GOTO RETURN_ERROR
			END
	END
	/* for exchange database agent index afile has appType 33 and data afile has apptype 53, if index chunk comes first we ended up creating file system backupset , subclient for exchange agent. */
	ELSE IF @FileType = 1
	BEGIN
		UPDATE APP
		SET appTypeId = @appTypeId
		FROM CommServ_Convert..CCM_APP_Application APP
		WHERE APP.id = @AppId AND APP.appTypeId <> @appTypeId
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO UPDATE CCM_APP_Application TABLE with correct appTypeId. '
			GOTO RETURN_ERROR
		END
		UPDATE APP
		SET clientId = @ClientId
		FROM CommServ_Convert..CCM_APP_Application APP
		WHERE APP.id = @AppId AND APP.clientId <> @ClientId
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO UPDATE CCM_APP_Application TABLE with correct clientId. '
			GOTO RETURN_ERROR
		END
	END
-------------------------------------CCM_archGroup table------------------------------------------------------------------
	SET @ArchGroupName='TapeImportSP_'+CAST(@ArchGroupId AS VARCHAR(10))
	IF NOT EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_archGroup WHERE id=@ArchGroupId)
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archGroup VALUES(
					@ArchGroupId,@CopyId,@ArchGroupName,'Created by tape import',10,1,0,2,@ArchGroupId,0,0,-1,-1,0,'',0,'',0,'', 0)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archGroup TABLE'
			GOTO RETURN_ERROR
		END
	END
------------------------------------CCM_archGroupCopy table------------------------------------------------------------------
		--SET MAXMULTIPLEX
	SET @CopyName='TapeImportCopy_SP'+CAST(@ArchGroupId AS VARCHAR(10))+'_Copy'+CAST(@CopyId AS VARCHAR(10))
	SET @EncKeyLen=LEN(@DataEncKey)
	IF NOT EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_archGroupCopy WHERE id=@CopyId )
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archGroupCopy
		(id, archGroupId, copy, name, flags, maxMultiplex, isActive, type, startTime, waitForIfOffline, waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId, delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId, encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed, SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags, blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId, sealStoreTaskId, extendedFlags, destMediaCopyId, maxCacheDBSizeMB, DDBLimitExtensionTimeStamp, DDBLimitExtensionTimeStampEncrypted, archCheckValidPeriodType)
		VALUES(@CopyId,@ArchGroupId,1,@CopyName,0,0,1,1,0,0,0,0,2,@CopyId,0,0,0,0,1,0,0,0,0,0,0,0,0,0,'',0,0,1,0,0,0,0,0,16,0,0,'',0)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archGroupCopy TABLE'
			GOTO RETURN_ERROR
		END
	END
IF @ArchCopyEncRSAPriKeyInfo IS NOT NULL
BEGIN
------------------------------------ CCM_ArchEncKeyProvider table ------------------------------------------------------------------
	SET @ArchCopyEncKeyProviderName = 'TapeImportKeyProviderName_SP'+CAST(@ArchGroupId AS VARCHAR(10))+'_Copy'+CAST(@CopyId AS VARCHAR(10))
	IF @ArchCopyEncKeyProviderGUID IS NOT NULL AND NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_ArchEncKeyProvider WHERE GUID = @ArchCopyEncKeyProviderGUID )
	BEGIN
		SET @ArchCopyEncKeyProviderId = @ArchCopyEncKeyProviderId + 1
		INSERT INTO CommServ_Convert..CCM_ArchEncKeyProvider VALUES(
		 @ArchCopyEncKeyProviderId, @ArchCopyEncKeyProviderName, @ArchCopyEncKeyProviderType, @ArchCopyEncKeyType, @ArchCopyEncKeyLength, '', 0, dbo.GetUnixTime(getutcdate()), @ArchCopyEncKeyProviderGUID )
	END
------------------------------------ CCM_ArchCopyEncProperties  table ------------------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_ArchCopyEncProperties WHERE CopyId = @CopyId )
	BEGIN
		INSERT INTO CommServ_Convert..CCM_ArchCopyEncProperties VALUES(
		 @CopyId, @ArchCopyEncPubKey, @ArchCopyEncPriKey, @ArchCopyEncMasterKey, @ArchCopyEncKeyProviderId, @ArchCopyEncKeyType, 0)
	END
END
----------------------------------CCM_archFile table-----------------------------------------------------------------------------
--is ObjNameForNAS == ObjName ??
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_archFile WHERE id=@ArchFileId )
	BEGIN
	INSERT INTO CommServ_Convert..CCM_archFile VALUES(
				@ArchFileId,@ArchiveFileName,2,@ArchGroupId,@ObjNameForNAS,0,@AppId,@FileType,@BackupTime,@JobId,@BackupLevel,1,0,0,0)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archFile TABLE'
			GOTO RETURN_ERROR
		END
	END
	----------------------------------CCM_archFileCopy table---------------------------------------------------------------------------
		/* Mapping for EncKeyType as we are not writing actual type on media
		BLOWFISH	2----->2
		AES			3----->4
		TWO FISH	5----->9
		3-DES		6----->10
		SERPENT		4----->6
		GOST		8----->11
		*/
		SELECT
		@EncryptionType = CASE @EncryptionType
                         WHEN 2 THEN 2
                         WHEN 3 THEN 4
                         WHEN 4 THEN 6
                         WHEN 5 THEN 9
                         WHEN 6 THEN 10
						 WHEN 8 THEN 11
						 ELSE @EncryptionType
                     END
		IF EXISTS
		(
		SELECT 1
		FROM CommServ_Convert..CCM_archFileCopy
		WHERE archFileId=@ArchFileId AND archCopyId = @CopyId
		)
		BEGIN
			UPDATE CommServ_Convert..CCM_archFileCopy
			SET physicalSize=physicalSize+@PhysicalSizeInChunk,
				logicalSize=logicalSize+@LogicalSizeInChunk,
				lastChunkNumber= CASE WHEN lastChunkNumber>@ChunkSeqNumber THEN lastChunkNumber ELSE @ChunkSeqNumber END
			WHERE archFileId=@ArchFileId AND archCopyId = @CopyId
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO UPDATE INTO CCM_archFileCopy TABLE'
				GOTO RETURN_ERROR
			END
		END
		ELSE
		BEGIN
DECLARE @encRSA INT = 0
IF (@NeedPassPhrase & 2) > 0
SET @encRSA = (@encRSA | 2)
IF (@NeedPassPhrase & 4) > 0
SET @encRSA = (@encRSA | 16)
IF @encRSA = 0 AND LEN(@RsaPriKey) > 10
SET @encRSA = 1
			INSERT INTO CommServ_Convert..CCM_archFileCopy VALUES(
						@ArchFileId,2,@CopyId,@archFileCopyFlags,1,1,@ChunkSeqNumber,@PhysicalSizeInChunk,@LogicalSizeInChunk,0,
						@encRSA,@EncryptionType,@DataEncKey,0,0,0, 0, -1)
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_archFileCopy TABLE'
				GOTO RETURN_ERROR
			END
		END
-------------------------------------CCM_archChunk table------------------------------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_archChunk WHERE id=@ChunkId)
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archChunk VALUES(
					@ChunkId,2,@VolumeId,@FileMarkNumber,0,@CMTVersion,'',@TotalPhysicalChunkSize,@TotalLogicalChunkSize,0,0,0,@HwEncKey,0,2)
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_archChunk TABLE'
				GOTO RETURN_ERROR
			END
	END
------------------------------------CCM_archChunkMapping table-------------------------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_archChunkMapping WHERE @ChunkId=archChunkId AND @ArchFileId=archFileId AND archCopyId = @CopyId )
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archChunkMapping VALUES(
					@ChunkId,@ArchFileId,2,@CopyId,@ChunkSeqNumber,@PhysicalOffsetForChunk,@LogicalOffsetForChunk,@PhysicalSizeInChunk,@LogicalSizeInChunk,
					0,0,0,0,2,@JobId,-1)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archChunkMapping TABLE'
			GOTO RETURN_ERROR
		END
	END
-----------------------------------------CCM_JMJobStats table ----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_JMJobStats WHERE jobId=@JobId )
	BEGIN
		INSERT INTO CommServ_Convert..CCM_JMJobStats VALUES(
					@JobId,2,
					CASE @AppTypeId WHEN 1000 THEN 11 ELSE 4 END,
					2,0,'','',0,'')
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_JMJobStats TABLE'
			GOTO RETURN_ERROR
		END
	END
----------------------------------------CCM_JMJobDataStats table------------------------------------------------------------------------
	IF EXISTS(SELECT 1 FROM CommServ_Convert..CCM_JMJobDataStats WHERE jobId=@JobId AND archGrpCopyId=@CopyId AND dataType=@FileType)
		BEGIN
		UPDATE CommServ_Convert..CCM_JMJobDataStats
		SET sizeOnMedia+=@PhysicalSizeInChunk
		WHERE jobId=@JobId AND archGrpCopyId=@CopyId  AND dataType=@FileType
		IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO UPDATE INTO CCM_JMJobDataStats TABLE'
				GOTO RETURN_ERROR
			END
		END
	ELSE
		BEGIN
			INSERT INTO CommServ_Convert..CCM_JMJobDataStats(jobId, archGrpId, archGrpCopyId, dataType, opType, auxCopyJobId, status, disabled, appId, commCellId, archCheckEndTime, archCheckStatus, retentionFlags,
			manualRetentionEndTime, copiedTime, agedTime, mediaDeletedTime, modifiedTime, sizeOnMedia, agedBy, flags, jobSelectionTime)
			VALUES(@JobId,@ArchGroupId,@CopyId,@FileType,4,0,100,0,@AppId,2,0,0,0,0,0,0,0,0,@PhysicalSizeInChunk,0,0,0)
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_JMJobDataStats TABLE'
				GOTO RETURN_ERROR
			END
		END
------------------------------------------------------CCM_JMAdminJobStatsTable table---------------------------------------------------------------
	IF @AppTypeId=1000
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_JMAdminJobStatsTable WHERE jobId=@JobId )
		BEGIN
			INSERT INTO CommServ_Convert..CCM_JMAdminJobStatsTable VALUES(
						@JobId,11,1,0,0,@ArchGroupId,@ArchGroupName,0,0,0,0,0,'CommServ','',0,'',0,0,0,0,'',@CopyId,0,0,'admin',0,0,0,
						2,@AppId,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,'',0)
		END
		IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO insert into CCM_JMAdminJobStatsTable TABLE'
				GOTO RETURN_ERROR
			END
	END
------------------------------------------------------CCM_JMBkpStats table---------------------------------------------------------------------------
	IF @AppTypeId<>1000
	BEGIN
		IF EXISTS(SELECT 1 FROM CommServ_Convert..CCM_JMBkpStats WHERE jobId=@JobId )
			BEGIN
			UPDATE CommServ_Convert..CCM_JMBkpStats
			SET totalBackupSize+=@PhysicalSizeInChunk,
				totalUncompBytes+=@LogicalSizeInChunk
			WHERE jobId=@JobId
			IF @@ERROR>0
				BEGIN
					SET @errorString='FAILED TO UPDATE CCM_JMBkpStats TABLE'
					GOTO RETURN_ERROR
				END
			END
		--Check Status,Data Status
		ELSE
			BEGIN
				INSERT INTO CommServ_Convert..CCM_JMBkpStats VALUES(
							@JobId,2,@AppId,@AppTypeId,0,@ArchGroupId,0,@BackupLevel,0,1,0,1,0,0,
							4,1,0,'',0,0,0,0,0,0,'',0,0,0,@LogicalSizeInChunk,0,0,@ArchGroupId,0,0,0,0,NULL,0,0,0,0,0,0,0,0,0,0,0,0,
							@PhysicalSizeInChunk,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0)
				IF @@ERROR>0
				BEGIN
					SET @errorString='FAILED TO INSERT INTO CCM_JMBkpStats TABLE'
					GOTO RETURN_ERROR
				END
			END
	END
/*
-----------------------------------------------------------CCM_TI_AllArchiveFilesAndChunks-----------------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CCM_TI_AllArchiveFilesAndChunks WHERE archFileId=@ArchFileId AND copyId=@CopyId AND chunkId=@ChunkId )
BEGIN
		INSERT INTO CCM_TI_AllArchiveFilesAndChunks VALUES(
						@JobId,@ArchFileId,@CopyId,@FileType,@ChunkId,2,@ChunkSeqNumber,@IsArchFileClosed)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_TI_AllArchiveFilesAndChunks TABLE'
			GOTO RETURN_ERROR
		END
END
*/
SKIP_APP:
FETCH NEXT FROM ArchFileInfo_Cursor INTO @ArchFileId,@IsArchFileClosed,@AppId,@JobId,@CreateJobId,
									 @AppTypeId, @BackupLevel, @BackupTime, @FileType, @FileSeqNo, @ClientName, @ArchiveFileName,
									 @ChunkSeqNumber, @PhysicalSizeInChunk, @LogicalSizeInChunk, @PhysicalOffsetForChunk,
									 @LogicalOffsetForChunk, @EncryptionType, @NeedPassPhrase, @DataEncKey, @RsaPriKey, @ObjNameForNAS, @ObjNameVersionForNAS
END
CLOSE ArchFileInfo_Cursor
DEALLOCATE ArchFileInfo_Cursor
	SET @errorString = 'Successfully populated the convert db with ChunkMapTrailers for CommCellId ['+CAST(@CommCellId AS VARCHAR(100)) + ']'
	SELECT  0, @errorString
	RETURN	(0)
RETURN_ERROR:
	RAISERROR ('%s' , 16, 1, @errorString)
    SELECT -1, @errorString
    RETURN	(-1)

IF EXISTS (select * from GxQscripts where name = 'TapeImport_MergeCMTInfo')
	delete from GxQscripts where name = 'TapeImport_MergeCMTInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeCMTInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeCMTInfo'
GO

insert into GXDBVersions values(2, 'TapeImport_MergeCMTInfo',  '00010007000200160000', 'TapeImport_MergeCMTInfo', '00010007000200160000')
GO

