

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_GetMissingEntityInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: kbora
--  Date:   25/12/2013
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_GetMissingEntityInfo.sp,v $ $Id: TapeImport_GetMissingEntityInfo.sp,v 1.4.12.4 2020/03/02 18:22:08 kbora Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TapeImport_GetMissingEntityInfo')
BEGIN
	print '>>> Drop Stored Procedure: TapeImport_GetMissingEntityInfo <<<'
	drop procedure TapeImport_GetMissingEntityInfo
END
IF EXISTS (select * from GxQscripts where name='TapeImport_GetMissingEntityInfo')
	delete from GxQscripts where name = 'TapeImport_GetMissingEntityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_GetMissingEntityInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_GetMissingEntityInfo'
GO
print '... Creating Procedure: TapeImport_GetMissingEntityInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TapeImport_GetMissingEntityInfo
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
	INSERT INTO CCM_TI_MAP_Client
	SELECT id,0,name,0
	FROM Commserv_Merge..CCM_APP_Client
	INSERT INTO CCM_TI_MAP_archGroup
	SELECT id,0
	FROM Commserv_Merge..CCM_archGroup
	INSERT INTO CCM_TI_MAP_archGroupCopy
	SELECT id,0,archGroupId,0
	FROM Commserv_Merge..CCM_archGroupCopy
	INSERT INTO CCM_TI_MAP_Application
	SELECT id,0,appTypeId,clientId,0,0,0,dataArchGrpID,0,0,''
	FROM Commserv_Merge..CCM_APP_Application
	UPDATE CCM_TI_MAP_Application
	SET clientName=B.name
	FROM CCM_TI_MAP_Application A, Commserv_Merge..CCM_APP_Client B
	WHERE A.old_clientId=B.id
	IF OBJECT_ID('tempdb..#WinCompatibleAppTypes') IS NOT NULL
		DROP TABLE #WinCompatibleAppTypes
	CREATE TABLE #WinCompatibleAppTypes ( appTypeId INT)
	INSERT INTO #WinCompatibleAppTypes
	SELECT DISTINCT A.type
	FROM APP_iDAType A, APP_AppTypeGroupAssoc B
	WHERE B.appGroupId=57 AND A.displayName LIKE '%File System%' AND A.type = B.appTypeId
	IF OBJECT_ID('tempdb..#WinAppTypes') IS NOT NULL
	DROP TABLE #WinAppTypes
	CREATE TABLE #WinAppTypes ( appTypeId INT)
	INSERT INTO #WinAppTypes
	SELECT distinct appTypeId FROM APP_AppTypeGroupAssoc where appGroupId in (
	select appTypeGroupId from APP_AppTypeGroup where groupName like '%windows%')
OR appTypeId IN (106, 53, 54, 13)
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to Insert into WinAppTypes table'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('tempdb..#UnixAppTypes') IS NOT NULL
	DROP TABLE #UnixAppTypes
    CREATE TABLE #UnixAppTypes ( appTypeId INT)
	INSERT INTO #UnixAppTypes
	SELECT distinct appTypeId FROM APP_AppTypeGroupAssoc where appGroupId in (
	select appTypeGroupId from APP_AppTypeGroup where groupName like '%unix%')
	IF @@ERROR>0
	BEGIN
	SET @errorString='Failed to Insert into UnixAppTypes table'
	GOTO CX_ERROR_EXIT
	END
	DECLARE @CommCellId INT
	SET @CommCellId = ISNULL ( (SELECT TOP 1 B.id  FROM CommServ_Merge..CCM_APP_CommCell A, CommServ..APP_CommCell B WHERE A.number = B.number  ), 0)
	IF @CommCellId = 0
	BEGIN
	SET @errorString='CommCell entry is not present in the Db..'
	GOTO CX_ERROR_EXIT
	END
	IF @CommCellId = 2
	BEGIN
		UPDATE	CCM_TI_MAP_Application
		SET 	new_appId 		= B.id,
				new_clientId	= B.clientId,
				new_backupSetId	= B.backupSet,
				clientName		= C.name,
				new_archGroupId	= B.dataArchGrpID,
				appTypeId		= B.appTypeId
		FROM CCM_TI_MAP_Application A, APP_Application B, APP_Client C
		WHERE B.id=A.old_appId AND B.clientId = C.id
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to update CCM_TI_MAP_Application --when applicatin exists on CS'
			GOTO CX_ERROR_EXIT
		END
	END
	UPDATE 	CCM_TI_MAP_Application
	SET 	new_appId 		= B.new_Id,
			new_clientId	= C.clientId,
			new_backupSetId = C.backupSet,
			clientName		= D.name,
			new_archGroupId = C.dataArchGrpID,
			appTypeId		= C.appTypeId
	FROM CCM_TI_MAP_Application A,TapeImportMappings B, APP_Application C, APP_Client D
	WHERE A.old_appId=B.old_Id AND B.entityType=7 AND C.id=B.new_Id AND A.new_appId=0 AND C.clientId=D.id AND B.newCCId = @CommCellId
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_TI_MAP_Application --when applicatin exists in TapeImportMapping table'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_TI_MAP_Client
	SET	new_clientId=B.new_clientId
	FROM CCM_TI_MAP_Client A, CCM_TI_MAP_Application B
	WHERE A.old_clientId=B.old_clientId AND B.new_appId <> 0
	/* Don't set the client id based on just few applications (subclients which does not have client name but they exists on CS),
	   becuase there are more applications which do not exists on CS and their client name is tapeImportclient (client name is empty on media) */
AND NOT EXISTS (SELECT 1 FROM CCM_TI_MAP_Application C WHERE C.old_clientId = A.old_clientId AND C.clientName = 'TapeImportClient' AND C.new_appId = 0 )
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_TI_MAP_Client --when applicatin exists on CS'
		GOTO CX_ERROR_EXIT
	END
	-- this is needed when subclients already exists and jobs are imported with other appType
	UPDATE Commserv_Merge..CCM_APP_Application
	SET appTypeId = B.appTypeId
	FROM Commserv_Merge..CCM_APP_Application A, CCM_TI_MAP_Application B
	WHERE A.id = B.old_appId AND B.new_appId <> 0
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_APP_Application --when applicatin exists on CS'
		GOTO CX_ERROR_EXIT
	END
	-- this is needed when subclients already exists and jobs are imported with other appType
	UPDATE Commserv_Merge..CCM_JMBkpStats
	SET appType = B.appTypeId
	FROM Commserv_Merge..CCM_JMBkpStats A, CCM_TI_MAP_Application B
	WHERE A.appId = B.old_appId AND B.new_appId <> 0
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_JMBkpStats --applicatin exists on CS'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @AppId				INT
	DECLARE @AppType			INT
	DECLARE @ClientId			INT
	DECLARE @BackupSetId		INT
	DECLARE @archGroupId		INT
	DECLARE @copyId				INT
	DECLARE @ClientName			VARCHAR(100)
	DECLARE @nextBackupSetId	INT
	DECLARE @osType				INT
	DECLARE @CompatibleAppTypeId INT
	DECLARE @newClientId		INT
	DECLARE @newBackupSetId	    INT
	DECLARE @str1	VARCHAR(1024)
	DECLARE @str2	VARCHAR(1024)
	SET @nextBackupSetId = 0
	DECLARE ApplicationInfo CURSOR LOCAL FAST_FORWARD FOR
	SELECT old_appId, appTypeId, old_clientId, clientName
	FROM CCM_TI_MAP_Application WHERE new_appId = 0
	OPEN ApplicationInfo
	FETCH NEXT FROM ApplicationInfo
	INTO @AppId, @AppType, @ClientId, @ClientName
	 WHILE @@FETCH_STATUS = 0
	 BEGIN
		SET @newClientId		=	0
		SET @newBackupSetId		=	0
		SET @osType				=	0
		IF EXISTS(SELECT 1 FROM #WinAppTypes WHERE appTypeId = @AppType) OR @AppType = 1000
		BEGIN
			SET @osType=1
		END
		ELSE IF EXISTS(SELECT 1 FROM #UnixAppTypes WHERE appTypeId = @AppType)
			SET @osType=2
		ELSE
		BEGIN
			SET @errorString='Un supported appType found exiting..'
			GOTO CX_ERROR_EXIT
		END
		IF @AppType = 1000 OR @AppType = 1
		SET @AppType = 43
		-- if we come to this point means, subclient is not present. so we can not find client. here we have to make use of global params to decide of.
		SET @newClientId=ISNULL((	SELECT DISTINCT componentNameId FROM APP_ClientProp WHERE attrName='TapeImportClientProp' AND attrVal=@ClientName+'_'+CAST(@CommCellId AS VARCHAR(100))),0)
		IF @newClientId=0
		BEGIN
		SET @newClientId =  ISNULL(( SELECT A.id FROM APP_Client A INNER JOIN APP_CommCell B ON A.origCCId = B.id WHERE A.name = @ClientName AND B.id = @CommCellId ),0)
		END
		IF @newClientId<>0
		BEGIN
			UPDATE CCM_TI_MAP_Client
			SET	new_clientId=@newClientId
			FROM CCM_TI_MAP_Client
			WHERE clientName=@ClientName AND new_clientId=0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Client --when orig ccid is 2'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_TI_MAP_backupSet
			SET new_clientId=A.new_clientId,appTypeId = @AppType
			FROM CCM_TI_MAP_Client A, CCM_TI_MAP_backupSet B
			WHERE A.old_clientId=B.old_clientId AND A.new_clientId <> 0 AND B.new_clientId = 0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_backupSet --when orig ccid <> 2'
				GOTO CX_ERROR_EXIT
			END
			-- we always taking compatible appType, problem comes when one client has more than one agent. think about it when problem comes.
			IF @AppType IN ( SELECT appTypeId FROM #WinCompatibleAppTypes) AND @AppType NOT IN ( SELECT appTypeId FROM APP_Application WHERE clientId=@newClientId)
			BEGIN
				SET @AppType= ISNULL (( SELECT TOP 1 A.appTypeId
										FROM #WinCompatibleAppTypes A, APP_Application B
										WHERE A.appTypeId=B.appTypeId AND B.clientId=@newClientId),@AppType)
			END
			SET @newBackupSetId = ISNULL((	SELECT DISTINCT C.componentNameId
											FROM APP_Application A, APP_BackupSetName B, APP_BackupSetProp C
											WHERE A.clientId=@newClientId AND A.backupSet=B.id
											AND B.id=C.componentNameId AND C.attrName='TapeImportBackupSetProp'
											AND C.attrVal=CAST(@AppType AS VARCHAR(100))+'_'+CAST(@newClientId as VARCHAR(100))+'_'+CAST(@CommCellId AS VARCHAR(100))),0
										)
			IF @newBackupSetId = 0
			BEGIN
				SET @newBackupSetId=ISNULL ((SELECT old_backupSetId FROM CCM_TI_MAP_backupSet WHERE appTypeId=@AppType AND old_clientId=@ClientId ),0)
				IF @newBackupSetId=0
				BEGIN
					SET @nextBackupSetId=@nextBackupSetId-1
					SET @newBackupSetId=@nextBackupSetId
					INSERT INTO CCM_TI_MAP_backupSet VALUES(
					@nextBackupSetId,0,@ClientId,@newClientId,@ClientName,1,@AppType)
					IF @@ERROR>0
					BEGIN
						SET @errorString='Failed to INSERT CCM_TI_MAP_backupSet --when @CompatibleAppTypeId=0'
						GOTO CX_ERROR_EXIT
					END
				END
			END
			UPDATE CCM_TI_MAP_Application
			SET new_clientId 	= @newClientId,
				new_backupSetId	= @newBackupSetId,
				appTypeId		= @AppType,
				old_backupSetId	= @newBackupSetId
			WHERE old_appId=@AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application --when applicatin not exists in TapeImportMapping table and no backup set exists'
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_APP_Application
			SET appTypeId=@AppType
			FROM Commserv_Merge..CCM_APP_Application
			WHERE id = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_APP_Application '
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_JMBkpStats
			SET appType= @AppType
			FROM Commserv_Merge..CCM_JMBkpStats A
			WHERE A.appId = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application -- when bakcup set exists and application does not exists, updating with right appTypeId '
				GOTO CX_ERROR_EXIT
			END
			IF NOT EXISTS(SELECT 1 FROM TapeImportMappings WHERE old_Id=@AppId AND entityType=7 AND newCCId=@CommCellId)
				BEGIN
					INSERT INTO TapeImportMappings
					SELECT old_appId,0,@CommCellId,7
					FROM CCM_TI_MAP_Application
					WHERE old_appId = @AppId AND new_appId = 0
					IF @@ERROR>0
					BEGIN
						SET @errorString='Failed to INSERT INTO TapeImportMappings '
						GOTO CX_ERROR_EXIT
					END
				END
		END
		ELSE
		BEGIN
			UPDATE CCM_TI_MAP_Client
			SET clientName=@ClientName,osType=@osType
			WHERE old_clientId=@ClientId AND new_clientId=0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Client'
				GOTO CX_ERROR_EXIT
			END
			SET @newBackupSetId=ISNULL ((SELECT old_backupSetId FROM CCM_TI_MAP_backupSet WHERE appTypeId=@AppType AND old_clientId=@ClientId ),0)
			IF @newBackupSetId=0
			BEGIN
				SET @nextBackupSetId=@nextBackupSetId-1
				SET @newBackupSetId=@nextBackupSetId
				INSERT INTO CCM_TI_MAP_backupSet VALUES(
				@nextBackupSetId,0,@ClientId,@newClientId,@ClientName,1,@AppType)
			END
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to INSERT CCM_TI_MAP_backupSet --when applicatin not exist in  TapeImportMapping table but backup exists'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_TI_MAP_Application
			SET old_backupSetId=@newBackupSetId,clientName=@ClientName,appTypeId = @AppType -- AppType should be updated if appType is 1 or 1000
			WHERE old_appId=@AppId AND new_appId=0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application when no client, no backupset'
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_APP_Application
			SET appTypeId=@AppType
			FROM Commserv_Merge..CCM_APP_Application
			WHERE id = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_APP_Application '
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_JMBkpStats
			SET appType= @AppType
			FROM Commserv_Merge..CCM_JMBkpStats A
			WHERE A.appId = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application -- when bakcup set exists and application does not exists, updating with right appTypeId '
				GOTO CX_ERROR_EXIT
			END
			IF NOT EXISTS(SELECT 1 FROM TapeImportMappings WHERE old_Id=@AppId AND entityType=7 AND newCCId=@CommCellId)
			BEGIN
				INSERT INTO TapeImportMappings
				SELECT old_appId,0,@CommCellId,7
				FROM CCM_TI_MAP_Application
				WHERE old_appId = @AppId AND new_appId = 0
				IF @@ERROR>0
				BEGIN
					SET @errorString='Failed to INSERT INTO TapeImportMappings '
					GOTO CX_ERROR_EXIT
				END
			END
		END
	END_LOOP:
	FETCH NEXT FROM ApplicationInfo
	INTO @AppId, @AppType, @ClientId, @ClientName
	END
/*	-- Set subclient status to un-deleted, think about not to update existing subclientStatus flags.
	UPDATE APP_Application
	SET subclientStatus = 0
	FROM APP_Application A, CCM_TI_MAP_Application B
	WHERE A.id = B.new_appId */
	-- Needed this when synthetic backup job,incremental job is present on media, in this case media says one application present under two clients.
	DELETE CCM_TI_MAP_Client
	FROM CCM_TI_MAP_Client a
	WHERE a.old_clientId NOT IN (SELECT DISTINCT b.old_clientId FROM CCM_TI_MAP_Application b)
	IF @CommCellId=2
	BEGIN
		 UPDATE CCM_TI_MAP_ArchGroup
		 SET new_archGroupId = b.Id
		 FROM CCM_TI_MAP_archGroup a, archGroup b,Commserv_Merge..CCM_archGroup c
		 WHERE A.old_archGroupId=B.id AND b.id = c.id
		 IF @@ERROR>0
		 BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_ArchGroup --When commcell id is 2'
			GOTO CX_ERROR_EXIT
		 END
		 UPDATE CCM_TI_MAP_archGroupCopy
		 SET new_CopyId = B.id
		 FROM CCM_TI_MAP_archGroupCopy A,archGroupCopy B, Commserv_Merge..CCM_archGroupCopy C
		 WHERE A.old_CopyId = B.id AND B.id = C.id
		 IF @@ERROR>0
		 BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy --When commcell id is 2'
			GOTO CX_ERROR_EXIT
		 END
		 -- This is needed when sp is present but not copy
		 UPDATE CCM_TI_MAP_archGroupCopy
		 SET new_archGroupId = B.new_archGroupId
		 FROM CCM_TI_MAP_archGroupCopy A,CCM_TI_MAP_archGroup B
		 WHERE A.old_archGroupId = B.old_archGroupId
		 IF @@ERROR>0
		 BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy --When commcell id is 2'
			GOTO CX_ERROR_EXIT
		 END
	END
	DECLARE ArchGroupCopyInfo CURSOR LOCAL FAST_FORWARD FOR
	SELECT id,archGroupId
	FROM Commserv_Merge..CCM_archGroupCopy A, CCM_TI_MAP_archGroupCopy B
	WHERE A.id = B.old_CopyId AND B.new_CopyId = 0
	OPEN ArchGroupCopyInfo
	FETCH NEXT FROM ArchGroupCopyInfo
	INTO @copyId, @archGroupId
	WHILE @@FETCH_STATUS = 0
    BEGIN
		IF EXISTS  (    	SELECT 1
							FROM TapeImportMappings
							WHERE old_Id=@copyId AND entityType=18  AND newCCId=@CommCellId AND new_Id<>0
					)
				BEGIN
				UPDATE CCM_TI_MAP_archGroupCopy
				SET new_CopyId=C.id,new_archGroupId=C.archGroupId
				FROM CCM_TI_MAP_archGroupCopy A,TapeImportMappings B,archGroupCopy C
				WHERE A.old_CopyId=@copyId AND A.old_CopyId=B.old_Id AND B.entityType=18  AND B.new_Id=C.id and new_CopyId=0 AND B.newCCId = @CommCellId
				IF @@ERROR>0
				BEGIN
					SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy --TapeImportMappings'
					GOTO CX_ERROR_EXIT
				END
				UPDATE CCM_TI_MAP_archGroup
				SET new_archGroupId=B.new_archGroupId
				FROM CCM_TI_MAP_archGroup A, CCM_TI_MAP_archGroupCopy B
				WHERE A.old_archGroupId=B.old_archGroupId
				IF @@ERROR>0
				BEGIN
					SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroup --TapeImportMappings'
					GOTO CX_ERROR_EXIT
				END
			END
			IF NOT EXISTS(SELECT 1 FROM TapeImportMappings WHERE old_Id=@copyId AND entityType=18  AND newCCId=@CommCellId)
				BEGIN
					INSERT INTO TapeImportMappings
					SELECT old_CopyId,0,@CommCellId,18
					FROM CCM_TI_MAP_archGroupCopy
					WHERE old_CopyId=@copyId AND new_CopyId = 0
					IF @@ERROR>0
					BEGIN
						SET @errorString='Failed to INSERT INTO TapeImportMappings '
						GOTO CX_ERROR_EXIT
					END
				END
		FETCH NEXT FROM ArchGroupCopyInfo
		INTO @copyId, @archGroupId
	END
       -- The below two update statements are needed, when CCM brings the sp, copy we have to use orig ids to find sp,copy
		UPDATE CCM_TI_MAP_archGroup
		SET new_archGroupId = B.id
		FROM CCM_TI_MAP_archGroup A,archGroup B
		WHERE A.old_archGroupId = B.origCCarchGroupId AND B.origCCcommCellID = @CommCellId AND A.new_archGroupId = 0
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroup with archgroupId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_TI_MAP_archGroupCopy
		SET new_CopyId = B.id,new_archGroupId = B.archGroupId
		FROM CCM_TI_MAP_archGroupCopy A, archGroupCopy B
		WHERE A.old_CopyId = B.origCCarchCopyId AND B.origCCcommCellID = @CommCellId AND A.new_CopyId = 0
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy with archgroupId'
			GOTO CX_ERROR_EXIT
		END
		-- archGroupId on cmt can be wrong some times, such cases new copyId found but new archGroupId can still be 0. so from copyId update archGroupId.
		UPDATE CCM_TI_MAP_archGroup
		SET new_archGroupId = C.archGroupId
		FROM CCM_TI_MAP_archGroup A INNER JOIN CCM_TI_MAP_archGroupCopy B ON A.old_archGroupId = B.old_archGroupId
			 INNER JOIN archGroupCopy C ON B.new_CopyId = C.id
		WHERE A.new_archGroupId = 0 AND B.new_CopyId > 0
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroup with archgroupId when archGroupId on cmt is wrong.'
			GOTO CX_ERROR_EXIT
		END
		-- If some subclients exists on the backupSet already then new subclients should use same instance and appType.
		UPDATE APP1
		SET APP1.instanceId = APP2.instance,
			APP1.appTypeId = APP2.appTypeId
		FROM CCM_TI_MAP_Application APP1
			INNER JOIN APP_Application APP2 ON APP1.new_backupSetId = APP2.backupSet
		WHERE APP1.new_appId = 0
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_Application with instanceId.'
			GOTO CX_ERROR_EXIT
		END
		SET @errorString = 'TapeImportMissingInfo proc Successful'
		SELECT  0,@errorString
		RETURN
	CX_ERROR_EXIT:
		RAISERROR ('%s' , 16, 1, @errorString)
		SELECT -1, @errorString
		RETURN

IF EXISTS (select * from GxQscripts where name = 'TapeImport_GetMissingEntityInfo')
	delete from GxQscripts where name = 'TapeImport_GetMissingEntityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_GetMissingEntityInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_GetMissingEntityInfo'
GO

insert into GXDBVersions values(2, 'TapeImport_GetMissingEntityInfo',  '00010004001200040000', 'TapeImport_GetMissingEntityInfo', '00010004001200040000')
GO

