

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_timeoff_history.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_timeoff_history.sp,v $ $Id: TOUpdate_timeoff_history.sp,v 1.1.2.5 2018/03/27 09:17:56 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_timeoff_history <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_timeoff_history')
	drop procedure TOUpdate_timeoff_history
IF EXISTS (select * from GxQscripts where name='TOUpdate_timeoff_history')
	delete from GxQscripts where name = 'TOUpdate_timeoff_history'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_timeoff_history')
	delete from GXDBVersions where aliasname = 'TOUpdate_timeoff_history'
GO
print '... Creating Procedure: TOUpdate_timeoff_history'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_timeoff_history
  @xmlText XML
AS
BEGIN
BEGIN TRANSACTION UpdateTimeOffHistory
	BEGIN TRY
		DECLARE @dTodayDate DATE
		SET @dTodayDate = CONVERT(DATE, GETDATE())
		IF @xmlText IS NOT NULL AND (SELECT @xmlText.value('(/today)[1]', 'datetime')) IS NOT NULL
			SELECT @dTodayDate = CONVERT(DATE, @xmlText.value('(/today)[1]', 'VARCHAR(12)'),101)
		DECLARE @dLastDayOfMonth DATE
		DECLARE @dLastDayOfPrevYear DATE
		DECLARE @dFirstDayOfCurYear DATE
		DECLARE @xmlOutput XML
		SET @dLastDayOfMonth = CONVERT(DATE, DATEADD(DAY, -1, DATEADD(MONTH, 1, DATEADD(DAY, - DATEPART(DAY, @dTodayDate) + 1, @dTodayDate))))
		SET @dLastDayOfPrevYear = CONVERT(DATE, DATEADD(DAY, - DATEPART(DAYOFYEAR, @dTodayDate), @dTodayDate))
		SET @dFirstDayOfCurYear = CONVERT(DATE, DATEADD(DAY, - DATEPART(DAYOFYEAR, @dTodayDate) + 1, @dTodayDate))
		INSERT INTO TOTimeOffHistory (sEmpID, nRequestTypeID, nAccrued, nUsed, nOpeningBal, dUpdateTS, nYear, nAppliedTimeOff)
		SELECT ProdcertName, nID, 0, 0 , 0, @dTodayDate, YEAR(@dTodayDate), 0  FROM
		(SELECT E.ProdcertName, RT.nID FROM TORequestType RT JOIN TOEmployee E
			ON E.nLocationID = RT.nLocationID
		EXCEPT
		SELECT TH.sEmpID As ProdcertName, TH.nRequestTypeID  As nID FROM TOTimeOffHistory TH WHERE YEAR(@dTodayDate) = nYear ) T
		UPDATE TOTimeOffHistory SET nAppliedTimeOff = nApplied, nUsed = T.nUsed
		FROM
		(SELECT sRequestor, nRequestID, SUM(nWorkdays) As nApplied,
			SUM(CASE WHEN CONVERT(DATE,@dTodayDate) BETWEEN dateStart AND dateEnd AND bIsHalfDay = 'false'
						THEN [dbo].[TOGet_total_working_days](dateStart, @dTodayDate, nOptDays, nLocationID)
					 WHEN CONVERT(DATE,@dTodayDate) BETWEEN dateStart AND dateEnd AND bIsHalfDay = 'true'  THEN nWorkDays
					 WHEN CONVERT(DATE,@dTodayDate) > dateEnd THEN nWorkDays
				END) As nUsed
		FROM
		(SELECT R.sRequestor, R.dateStart, R.dateEnd, R.nRequestTypeID AS nRequestID, R.nWorkDays, R.bIsHalfDay, E.nLocationID,
				(SELECT COUNT(CASE WHEN CONVERT(DATE,Item) <= @dTodayDate THEN 1 ELSE NULL END) FROM TOSplit(sOptHolidays, ',')) AS nOptDays
		FROM TORequests R JOIN  TOEmployee E
			ON E.ProdcertName = R.sRequestor
		WHERE (YEAR(dateStart) = YEAR(@dTodayDate) OR YEAR(dateEnd) = YEAR(@dTodayDate)) AND nHelperRequestStatusID IN (1,2)) T
		GROUP BY sRequestor, nRequestID) T
		WHERE T.sRequestor = sEmpID AND nRequestTypeID = T.nRequestID AND nYear = YEAR(@dTodayDate)
		IF @dTodayDate = @dLastDayOfMonth
		BEGIN
			DECLARE @SpecialCaseTable TABLE (ProdcertName NVARCHAR(50), nRequestType INT, nAccruedPerMonth FLOAT, nMaxAllowed FLOAT, nCarryForward FLOAT)
			DECLARE @DefaultCaseTable TABLE (nRequestType INT, nAccruedPerMonth FLOAT, nMaxAllowed FLOAT, nCarryForward FLOAT)
			INSERT INTO @SpecialCaseTable
			SELECT E.ProdcertName, nRequestType, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TOEmployee E JOIN TOEmployeeToPolicyMapping EPM
				ON E.ProdcertName = EPM.sEmpAlias
			JOIN TOLeaveEntitlementPolicy LEP
				ON EPM.nLeaveEntitlementPolicyID = LEP.nID AND @dTodayDate BETWEEN CONVERT(DATE, LEP.dRenewedOn) AND  DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
			JOIN TORequestType R
				ON R.nID = EPM.nRequestType
			WHERE bIsDeductible = 'true'
			UNION
			SELECT E.ProdcertName, nRequestType, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TOEmployeeToPolicyMappingHistory EMPH JOIN TOEmployee E
				ON E.ProdcertName = EMPH.sEmpAlias
			JOIN TORequestType R
				ON R.nID = EMPH.nRequestType
			WHERE @dTodayDate BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
				  AND bIsHistory = 'false' AND bIsDeductible = 'true'
			INSERT INTO @DefaultCaseTable
			SELECT  RT.nID, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TORequestType RT JOIN TOLeaveEntitlementPolicy LEP
				ON LEP.nID = RT.nEntitlementPolicyID
			WHERE @dTodayDate BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))  AND bIsDeductible = 'true'
			UNION
			SELECT  RT.nID, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TOLeaveEntitlementPolicyHistory LEPH JOIN TORequestType RT
				ON RT.nID = LEPH.nRequestTypeID
			WHERE @dTodayDate BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn)) AND bIsHistory = 'false' AND bIsDeductible = 'true'
			UPDATE TOTimeOffHistory SET nAccrued = nAccrued + nAccruedPerMonth, dUpdateTS = GETDATE()
			FROM
			(SELECT * FROM @SpecialCaseTable) T
			WHERE T.ProdcertName = sEmpID AND nRequestTypeID = T.nRequestType AND nYear = YEAR(@dTodayDate)
			UPDATE TOTimeOffHistory SET nAccrued = nAccrued + nAccruedPerMonth, dUpdateTS = GETDATE()
			FROM
			(SELECT * FROM @DefaultCaseTable) T
			WHERE nRequestTypeID = T.nRequestType AND sEmpID NOT IN (SELECT ProdcertName FROM @SpecialCaseTable) AND nYear = YEAR(@dTodayDate)
		END
		IF @dTodayDate = @dFirstDayOfCurYear
		BEGIN
			DECLARE @SpecialTable TABLE (ProdcertName NVARCHAR(50), nRequestType INT, nAccruedPerMonth FLOAT, nMaxAllowed FLOAT, nCarryForward FLOAT)
			DECLARE @DefaultTable TABLE (nRequestType INT, nAccruedPerMonth FLOAT, nMaxAllowed FLOAT, nCarryForward FLOAT)
			INSERT INTO @SpecialTable
			SELECT E.ProdcertName, nRequestType, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TOEmployee E JOIN TOEmployeeToPolicyMapping EPM
				ON E.ProdcertName = EPM.sEmpAlias
			JOIN TOLeaveEntitlementPolicy LEP
				ON EPM.nLeaveEntitlementPolicyID = LEP.nID AND @dLastDayOfPrevYear BETWEEN CONVERT(DATE, LEP.dRenewedOn) AND  DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
			JOIN TORequestType R
				ON R.nID = EPM.nRequestType
			WHERE bIsDeductible = 'true'
			UNION
			SELECT E.ProdcertName, nRequestType, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TOEmployeeToPolicyMappingHistory EMPH JOIN TOEmployee E
				ON E.ProdcertName = EMPH.sEmpAlias
			JOIN TORequestType R
				ON R.nID = EMPH.nRequestType
			WHERE @dLastDayOfPrevYear BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
				  AND bIsHistory = 'false' AND bIsDeductible = 'true'
			INSERT INTO @DefaultTable
			SELECT  RT.nID, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TORequestType RT JOIN TOLeaveEntitlementPolicy LEP
				ON LEP.nID = RT.nEntitlementPolicyID
			WHERE @dLastDayOfPrevYear BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))  AND bIsDeductible = 'true'
			UNION
			SELECT  RT.nID, nAccruedPerMonth, nMaxAllowed, nCarryFwdAllowed
			FROM TOLeaveEntitlementPolicyHistory LEPH JOIN TORequestType RT
				ON RT.nID = LEPH.nRequestTypeID
			WHERE @dLastDayOfPrevYear BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn)) AND bIsHistory = 'false' AND bIsDeductible = 'true'
			UPDATE TOTimeOffHistory SET nOpeningBal = CASE WHEN (T.nMaxAllowed < T.nUsed) THEN (T.nOpeningBal + T.nMaxAllowed - T.nUsed) ELSE T.nOpeningBal END +
													  CASE WHEN (T.nMaxAllowed - T.nUsed) >= T.nCarryForward THEN T.nCarryForward ELSE (T.nMaxAllowed - T.nUsed) END
			FROM (SELECT S.*, nOpeningBal, nUsed FROM @SpecialTable S JOIN TOTimeOffHistory T1
					ON S.ProdcertName = T1.sEmpID AND S.nRequestType = T1.nRequestTypeID AND nYear = YEAR(@dLastDayOfPrevYear)
					JOIN TORequestType R ON R.nID = T1.nRequestTypeID AND bIsDeductible = 'true') T
			WHERE T.nRequestType = nRequestTypeID AND T.ProdcertName = sEmpID AND nYear = YEAR(@dFirstDayOfCurYear)
			UPDATE TOTimeOffHistory SET nOpeningBal = CASE WHEN (T.nMaxAllowed < T.nUsed) THEN (T.nOpeningBal + T.nMaxAllowed - T.nUsed) ELSE T.nOpeningBal END +
													  CASE WHEN (T.nMaxAllowed - T.nUsed) >= T.nCarryForward THEN T.nCarryForward ELSE (T.nMaxAllowed - T.nUsed) END
			FROM (SELECT D.*, nOpeningBal, nUsed, sEmpID AS EmpID  FROM @DefaultTable D JOIN TOTimeOffHistory T1
					ON D.nRequestType = T1.nRequestTypeID AND nYear = YEAR(@dLastDayOfPrevYear)
				  JOIN TORequestType R ON R.nID = T1.nRequestTypeID AND bIsDeductible = 'true'
				 WHERE  T1.sEmpID NOT IN (SELECT ProdcertName FROM @SpecialTable)) T
			WHERE T.nRequestType = nRequestTypeID AND T.EmpID = sEmpID AND nYear = YEAR(@dFirstDayOfCurYear)
		END
		SET @xmlOutput = 'true'
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION UpdateTimeOffHistory
		SET @xmlOutput = 'false'
		RETURN
	END CATCH
	SELECT @xmlOutput
COMMIT TRANSACTION UpdateTimeOffHistory
RETURN
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_timeoff_history')
	delete from GxQscripts where name = 'TOUpdate_timeoff_history'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_timeoff_history')
	delete from GXDBVersions where aliasname = 'TOUpdate_timeoff_history'
GO

insert into GXDBVersions values(2, 'TOUpdate_timeoff_history',  '00010001000200050000', 'TOUpdate_timeoff_history', '00010001000200050000')
GO

