

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_timeoff.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_timeoff.sp,v $ $Id: TOUpdate_timeoff.sp,v 1.2.2.6 2018/03/27 08:43:14 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_timeoff <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_timeoff')
	drop procedure TOUpdate_timeoff
IF EXISTS (select * from GxQscripts where name='TOUpdate_timeoff')
	delete from GxQscripts where name = 'TOUpdate_timeoff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_timeoff')
	delete from GXDBVersions where aliasname = 'TOUpdate_timeoff'
GO
print '... Creating Procedure: TOUpdate_timeoff'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_timeoff
  @nID INT,
  @sRequestor NVARCHAR(50),	 
  @nRequestTypeID INT,
  @dateStart DATE,
  @dateEnd DATE,	
  @sComments NVARCHAR(MAX),	
  @sOutlookMeetingID NVARCHAR(255),
  @sOptHolidays NVARCHAR(255),		
  @sAlias NVARCHAR(50),		
  @bIsHalfDay BIT,
  @bHalfDayType BIT, -- 0  for AM and 1 for PM	
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
BEGIN TRANSACTION UpdateTimeOff
	BEGIN TRY
		DECLARE @nHelperRequestStatusID INT = 1
		DECLARE @nWorkDays DECIMAL(6,1)
		DECLARE @nApprovalEscalationLevel INT = 0 -- set by default 0 means immediate manager can approve
		DECLARE @IDs TABLE(nID INT, sRequestor NVARCHAR(50))
		DECLARE @sOptionalDaysToWrite NVARCHAR(255)
		DECLARE @IsOptionalHolidaySuccess BIT
		DECLARE @nOptHolidayInCurrReq INT
		DECLARE @nLocationID INT
		DECLARE @nLeaveEntitlementPolicyID INT = -1
		DECLARE @nLeaveApprovalPolicyID INT = -1
		DECLARE @i INT = 1
		DECLARE @bIsHalfdayAllowed BIT ='false'
		DECLARE @nOldLeaveStatus INT = 0
		DECLARE @dOldReqStartDate DATE
		DECLARE @dOldReqEndDate DATE
		DECLARE @sSubmitterAlias NVARCHAR(50)
		DECLARE @sRequestorAlias NVARCHAR(50)
		DECLARE @sOldOutlookMeetingID NVARCHAR(255)
		-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
		SET NOCOUNT ON;
		SELECT @bIsHalfdayAllowed = bIsHalfDayAllowed FROM TORequestType WHERE nID = @nRequestTypeID
		IF @bIsHalfDay = 'true' AND @bIsHalfdayAllowed = 'false'
		BEGIN
			SET @errorMsg = 'Error: Half day not allowed for the Request type'
			RAISERROR(@errorMsg, 16,1)
		END
		IF @bIsHalfDay = 'true' AND (@dateStart <> @dateEnd)
		BEGIN
			SET @errorMsg = 'Error: Half day not allowed for more than one day'
			RAISERROR(@errorMsg, 16,1)
		END
		SELECT @nOldLeaveStatus = nHelperRequestStatusID, @dOldReqStartDate = dateStart, @dOldReqEndDate = dateEnd, @sSubmitterAlias = sSubmittedBy ,
			   @sRequestorAlias = sRequestor, @sOldOutlookMeetingID = sOutlookMeetingID FROM TORequests WHERE nID = @nID
		IF @nOldLeaveStatus = 3 OR @nOldLeaveStatus = 4
		BEGIN
			SET @errorMsg = 'Error: Cannot modify cancelled/denied TORequests'
			RAISERROR(@errorMsg, 16,1)
		END
		IF CONVERT(DATE, GETDATE()) > @dOldReqStartDate
		BEGIN
			SET @errorMsg = 'Error: Cannot modify past days TORequests'
			RAISERROR(@errorMsg, 16,1)
		END
		IF NOT ((@nOldLeaveStatus IN (1,2) AND (@sAlias = @sRequestorAlias)) OR (@nOldLeaveStatus = 1 AND (@sSubmitterAlias = @sAlias)))
		BEGIN
			SET @errorMsg = 'Error: Cannot modify Requests which is either not yours nor submitted by you for others'
			RAISERROR(@errorMsg, 16,1)
		END
		DECLARE @nCarryForwardFromLastYear FLOAT = NULL
		DECLARE @dHiredDate DATE
		DECLARE @bIsDeductible BIT
		SELECT @bIsDeductible = bIsDeductible FROM TORequestType WHERE nID = @nRequestTypeID
		SELECT @dHiredDate = dHiredDate FROM TOEmployee WHERE ProdcertName = @sRequestor
		SELECT @nCarryForwardFromLastYear = CONVERT(FLOAT, nOpeningBal) FROM TOTimeOffHistory WHERE sEmpID = @sRequestor AND YEAR(@dateEnd) = nYear AND nRequestTypeID = @nRequestTypeID
		SELECT @nLeaveEntitlementPolicyID = nLeaveEntitlementPolicyID, @nLeaveApprovalPolicyID = nLeaveApprovalPolicyID FROM TOEmployee E JOIN TOEmployeeToPolicyMapping EMP
			ON E.ProdcertName = EMP.sEmpAlias AND EMP.nRequestType = @nRequestTypeID
			WHERE E.ProdcertName = @sRequestor
		DECLARE @nMaxAllowed FLOAT = 0
		DECLARE @nMaxContAllowed FLOAT = 0
		DECLARE @nMaxCountAllowed FLOAT = 0
		DECLARE @LEPStartDate DATE
		DECLARE @LEPEndDate DATE
		IF @nLeaveEntitlementPolicyID > 0
			SELECT @nMaxAllowed = nMaxAllowed,@nMaxContAllowed = nMaxContAllowed, @LEPStartDate = dRenewedOn, @LEPEndDate = DATEADD(DAY, -1, DATEADD(MONTH,nDuration,dRenewedOn)), @nMaxCountAllowed = nMaxCountAllowed
				FROM TOLeaveEntitlementPolicy LEP WHERE LEP.nID = @nLeaveEntitlementPolicyID
		ELSE
			SELECT @nLeaveEntitlementPolicyID = LEP.nID, @nMaxAllowed = nMaxAllowed,@nMaxContAllowed = nMaxContAllowed, @LEPStartDate = dRenewedOn, @LEPEndDate = DATEADD(DAY, -1, DATEADD(MONTH,nDuration,dRenewedOn)), @nMaxCountAllowed = nMaxCountAllowed
			FROM TOLeaveEntitlementPolicy LEP JOIN TORequestType RT
				ON RT.nEntitlementPolicyID = LEP.nID  WHERE RT.nID = @nRequestTypeID
		IF NOT (@nLeaveEntitlementPolicyID > 0)
		BEGIN
			SET @errorMsg = 'Error: No Leave entitlement policy found for duartion ' + CONVERT(VARCHAR, @dateStart) + ' to ' + CONVERT(VARCHAR, @dateEnd)
			RAISERROR(@errorMsg, 16,1)
		END
		IF  (@dateStart NOT BETWEEN @LEPStartDate AND @LEPEndDate) AND (@dateEnd NOT BETWEEN @LEPStartDate AND @LEPEndDate)
		BEGIN
			DECLARE @bIsLEPFound BIT = 'false'
			EXEC dbo.TOGet_leave_entitlement_policy_details
						@sRequestor,
						@nRequestTypeID,
						@dateStart,
						@dateEnd,
						@LEPStartDate = @LEPStartDate OUT,
						@LEPEndDate = @LEPEndDate OUT,
						@nMaxAllowed = @nMaxAllowed OUT,
						@nMaxContAllowed = @nMaxContAllowed OUT,
						@nMaxCountAllowed = @nMaxCountAllowed OUT,
						@bIsLEPFound = @bIsLEPFound OUT
			IF @bIsLEPFound = 'false'
			BEGIN
				SET @errorMsg = 'Error: No unique Leave entitlement policy found for duration ' + CONVERT(VARCHAR, @dateStart) + ' to ' + CONVERT(VARCHAR, @dateEnd)
				RAISERROR(@errorMsg, 16,1)
			END
		END
		ELSE IF (@dateStart BETWEEN @LEPStartDate AND @LEPEndDate) AND (@dateEnd NOT BETWEEN @LEPStartDate AND @LEPEndDate)
		BEGIN
			SET @errorMsg = 'Error: No unique Leave entitlement policy found for duration ' + CONVERT(VARCHAR, @dateStart) + ' to ' + CONVERT(VARCHAR, @dateEnd)
			RAISERROR(@errorMsg, 16,1)
		END
		ELSE IF (@dateStart NOT BETWEEN @LEPStartDate AND @LEPEndDate) AND (@dateEnd BETWEEN @LEPStartDate AND @LEPEndDate)
		BEGIN
			SET @errorMsg = 'Error: No unique Leave entitlement policy found for duration ' + CONVERT(VARCHAR, @dateStart) + ' to ' + CONVERT(VARCHAR, @dateEnd)
			RAISERROR(@errorMsg, 16,1)
		END
		IF @sOldOutlookMeetingID IS NOT NULL AND @sOldOutlookMeetingID != ''
		BEGIN
			SET @sOutlookMeetingID = @sOldOutlookMeetingID
		END
		IF @nCarryForwardFromLastYear IS NOT NULL AND @bIsDeductible = 'true' AND @nMaxAllowed != -1
		BEGIN
			SET @nMaxAllowed = @nMaxAllowed + @nCarryForwardFromLastYear
			SET @nMaxAllowed = CEILING(@nMaxAllowed)
		END
		IF @dHiredDate BETWEEN @LEPStartDate AND @LEPEndDate AND @bIsDeductible = 'true' AND @nMaxAllowed != -1
		BEGIN
			DECLARE @NoOfDays INT = NULL
			SET @NoOfDays = DATEDIFF(DAY, @LEPStartDate, @LEPEndDate) + 1
			SET @nMaxAllowed = (@nMaxAllowed / @NoOfDays) * (DATEDIFF(DAY, @dHiredDate, @LEPEndDate) + 1)
			SET @nMaxAllowed = CEILING(@nMaxAllowed)
		END
		DECLARE @nDefaultApprover INT = 0
		DECLARE @nCntCountEscalation INT = 0
		DECLARE @nCntCounEscApprover INT = 0
		DECLARE @nTotalCountEscalation INT = 0
		DECLARE @nTotalCountEscApprover INT = 0
		IF @nLeaveApprovalPolicyID > 0
			SELECT @nDefaultApprover = nDefaultApprover, @nCntCountEscalation = nCntCountEscalation, @nCntCounEscApprover = nCntCounEscApprover, @nTotalCountEscalation = nTotalCountEscalation,
				@nTotalCountEscApprover = nTotalCountEscApprover FROM TOLeaveApprovalPolicy WHERE nID = @nLeaveApprovalPolicyID
		ELSE
			SELECT @nDefaultApprover = nDefaultApprover, @nCntCountEscalation = nCntCountEscalation, @nCntCounEscApprover = nCntCounEscApprover, @nTotalCountEscalation = nTotalCountEscalation,
				@nTotalCountEscApprover = nTotalCountEscApprover FROM TOLeaveApprovalPolicy LAP JOIN TORequestType RT
				ON RT.nApprovalPolicyID = LAP.nID  WHERE RT.nID = @nRequestTypeID
		SELECT @nLocationID  = nLocationID FROM TOEmployee WHERE ProdcertName = @sRequestor
		DECLARE @nOptHolidayReqType INT = 0
		--SELECT @nOptHolidayReqType = sValue FROM TOGlobal WHERE sName LIKE 'OptHolidayReqType'
		DECLARE @nParentLocID INT  = 0
		SELECT @nParentLocID = nParentLocID FROM TOLocation WHERE nID = @nLocationID
		SELECT @nOptHolidayReqType = nID FROM TORequestType WHERE bIsOptionalType = 'true' AND (nLocationID = @nLocationID OR nLocationID = @nParentLocID)
		IF @bIsHalfDay = 'false'
		BEGIN
			IF @nOptHolidayReqType = @nRequestTypeID
			BEGIN
				SET @sOptHolidays = ','
				DECLARE @tempDate DATE = @dateStart
				WHILE @tempDate <= @dateEnd
				BEGIN
					SET @sOptHolidays = @sOptHolidays +  CONVERT(VARCHAR, @tempDate) + ','
					SET @tempDate = DATEADD(DAY, 1, @tempDate)
				END
			END
			EXEC [dbo].[TOCheck_optional_day_violation]
				@sRequestor ,
				@LEPStartDate ,
				@LEPEndDate ,
				@sOptHolidays,
				@nLocationID ,
				@bIsHalfDay ,
				@nID,
				@dateStart,
				@dateEnd,
				@sOptionalDays = @sOptionalDaysToWrite OUTPUT,
				@IsOptionalHolidaySuccess = @IsOptionalHolidaySuccess OUTPUT,
				@nOptHolidayInCurrReq = @nOptHolidayInCurrReq OUTPUT
		END
		ELSE
			SET @IsOptionalHolidaySuccess = 'true'
		IF @IsOptionalHolidaySuccess = 'true'
		BEGIN
			SET @nWorkDays = dbo.TOGet_total_working_days(CONVERT(DATETIME,@dateStart),CONVERT(DATETIME, @dateEnd), @nOptHolidayInCurrReq,@nLocationID)
			IF @bIsHalfDay = 'true' AND @nWorkDays > 0
				SET @nWorkDays = 0.5
			--DECLARE @nTotalDays INT = dbo.GET_WORKING_DAYS(CONVERT(DATETIME,@dateStart),CONVERT(DATETIME, @dateEnd))
			--IF @nTotalDays = @nOptHolidayInCurrReq
			--BEGIN
			--	SET @nRequestTypeID = @nOptHolidayReqType
			--	SET @nWorkDays = @nOptHolidayInCurrReq
			--END
			IF (@nRequestTypeID <> @nOptHolidayReqType) AND (@nWorkDays = 0)
			BEGIN
				SET @bReturnCode = 'false'
				SET @errorMsg = 'Error: No time off can be applied for weekends/TOHolidays'
				RAISERROR(@errorMsg, 16,1)
			END
			-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
			SET NOCOUNT ON;
			DECLARE @nTotalCountOfReq INT = 0
			DECLARE @nTotalSumOfReq INT = 0
			DECLARE @nSubmittedStatusID INT = 1
			DECLARE @nApprovedStatusID INT = 2
--				SELECT @nOptHolidayReqType = sValue FROM TOGlobal WHERE sName = 'OptHolidayReqType'
			SELECT @nTotalCountOfReq = COUNT(*), @nTotalSumOfReq = CASE WHEN SUM(nWorkDays) IS NULL THEN 0 ELSE SUM(nWorkDays)END  FROM TORequests WHERE nRequestTypeID = @nRequestTypeID AND sRequestor = @sRequestor
				   AND dateStart >= @LEPStartDate AND dateEnd <= @LEPEndDate  AND nHelperRequestStatusID IN (@nSubmittedStatusID, @nApprovedStatusID) AND nID <> @nID
			--Check Leave Entitlement Policy violations
			IF ((@nMaxCountAllowed = -1) OR ((@nTotalCountOfReq + 1) <= @nMaxCountAllowed)) AND ((@nMaxAllowed = -1) OR (@nTotalSumOfReq + @nWorkDays <= @nMaxAllowed))
				AND ((@nMaxContAllowed = -1) OR (@nWorkDays <= @nMaxContAllowed))
			BEGIN
				DECLARE	@IsOverlapCheckPassed BIT,
						@nOverlapReqSplits INT
				--Check Overlapping violation and based on that Split old request
				EXEC	[dbo].[TOCheck_overlapping_request_violation]
						@sRequestor,
						@LEPStartDate ,
						@LEPEndDate,
						@dateStart,
						@dateEnd,
						@nRequestTypeID,
						@bIsHalfDay,
						@bHalfDayType,
						@nLocationID ,
						@nID,
						@IsOverlapCheckPassed = @IsOverlapCheckPassed OUTPUT,
						@nOverlapReqSplits = @nOverlapReqSplits OUTPUT
				DECLARE @nEscalationLevel INT = 0
				DECLARE @bIsEscalated BIT ='false'
				DECLARE @SpecialEscaltionGroup NVARCHAR(50) = NULL
				IF @IsOverlapCheckPassed = 'true'
				BEGIN
					 SET @SpecialEscaltionGroup = (SELECT sValue FROM TOGlobal WHERE sName = CONVERT(VARCHAR,@nCntCounEscApprover) OR sName = CONVERT(VARCHAR,@nTotalCountEscApprover))
					IF @SpecialEscaltionGroup IS NOT NULL
					BEGIN
						IF ((@nCntCountEscalation <> -1) AND (@nCntCountEscalation <= @nWorkDays)) OR ((@nTotalCountEscalation <> -1) AND (@nTotalCountEscalation <= (@nTotalSumOfReq + @nWorkDays)))
						BEGIN
							SET @nEscalationLevel = (SELECT * FROM dbo.TOGet_first_manager(@SpecialEscaltionGroup, ','))
							SET @bIsEscalated = 'true'
						END
					END
					ELSE
					BEGIN
						IF (@nCntCountEscalation <> -1) AND (@nTotalCountEscalation <> -1) AND (@nCntCountEscalation <= @nWorkDays) AND (@nTotalCountEscalation <= (@nTotalSumOfReq + @nWorkDays))
						BEGIN
							IF (@nCntCounEscApprover > @nTotalCountEscApprover)
								SET @nEscalationLevel = @nCntCounEscApprover
							ELSE
								SET @nEscalationLevel = @nTotalCountEscApprover
							SET @bIsEscalated = 'true'
						END
						ELSE IF (@nCntCountEscalation <> -1) AND (@nCntCountEscalation <= @nWorkDays)
						BEGIN
							SET @nEscalationLevel = @nCntCounEscApprover
							SET @bIsEscalated = 'true'
						END
						ELSE IF (@nTotalCountEscalation <> -1) AND (@nTotalCountEscalation <= (@nTotalSumOfReq + @nWorkDays))
						BEGIN
							SET @nEscalationLevel = @nTotalCountEscApprover
							SET @bIsEscalated = 'true'
						END
						ELSE
						BEGIN
							SET @nEscalationLevel = @nDefaultApprover
							SET @bIsEscalated = 'false'
						END
					END
					IF @nRequestTypeID = @nOptHolidayReqType
					BEGIN
						UPDATE TORequests SET dateRequested = GETDATE(),sRequestor = @sRequestor,nRequestTypeID = @nRequestTypeID,dateStart = @dateStart,dateEnd = @dateEnd,
							nWorkDays = @nWorkDays,sComments = @sComments,nHelperRequestStatusID = 2,sOutlookMeetingID = @sOutlookMeetingID, bIsEscalated = @bIsEscalated,
							sOptHolidays = @sOptionalDaysToWrite, nApprovalEscalationLevel = @nApprovalEscalationLevel,sSubmittedBy = @sAlias,bIsHalfDay = @bIsHalfDay,
							bHalfDayType = @bHalfDayType, sApprovedBy ='admin', sApproverComments = 'Optional day time off are auto approved', dateApproved = GETDATE()
							,sEscalationApprover = 'admin'
						WHERE nID = @nID
					END
					ELSE
					BEGIN
						DECLARE @sEscalationApprover NVARCHAR(50);
						IF @SpecialEscaltionGroup IS NOT NULL
						BEGIN
							SET @sEscalationApprover = (SELECT dbo.TOGet_user_name(@SpecialEscaltionGroup, ','))
						END
						ELSE
						BEGIN
							IF @nEscalationLevel = -1 OR @nEscalationLevel = 0
							BEGIN
								SET @sEscalationApprover = (SELECT CASE WHEN CHARINDEX(',', Manager, 0) > 0 THEN SUBSTRING(Manager, 0 , CHARINDEX(',', Manager, 0)) ELSE Manager END
																FROM TOEmployee WHERE ProdcertName = @sRequestor)
							END
							ELSE
							BEGIN
								WITH [CTE_Manager_Hierarchy]
								AS
								(
									SELECT E1.ProdcertName, E2.ProdcertName AS Manager, 0 AS Level FROM TOEmployee E1 JOIN TOEmployee E2
										ON E2.ProdcertName IN (SELECT * FROM dbo.TOGet_first_manager(E1.Manager, ','))
									WHERE E1.ProdcertName = @sRequestor
									UNION ALL
									SELECT E1.ProdcertName, E2.ProdcertName, Level + 1 FROM TOEmployee E1 JOIN TOEmployee E2
										ON E2.ProdcertName IN (SELECT * FROM dbo.TOGet_first_manager(E1.Manager, ','))
									INNER JOIN [CTE_Manager_Hierarchy] D
										ON D.Manager = E1.ProdcertName AND E1.ProdcertName <> E2.Manager
								)
								SELECT TOP 1 @sEscalationApprover = Manager FROM [CTE_Manager_Hierarchy] WHERE Level <= @nEscalationLevel ORDER BY  Level DESC
							END
						END
						UPDATE TORequests SET dateRequested = GETDATE(),sRequestor = @sRequestor,nRequestTypeID = @nRequestTypeID,dateStart = @dateStart,dateEnd = @dateEnd,
							nWorkDays = @nWorkDays,sComments = @sComments,nHelperRequestStatusID = @nHelperRequestStatusID,sOutlookMeetingID = @sOutlookMeetingID,
							sOptHolidays = @sOptionalDaysToWrite, sEscalationApprover = @sEscalationApprover,sApprovedBy= NULL, sApproverComments = NULL, dateApproved = NULL,
							nApprovalEscalationLevel = @nApprovalEscalationLevel,sSubmittedBy = @sAlias,bIsHalfDay = @bIsHalfDay,bHalfDayType = @bHalfDayType, bIsEscalated = @bIsEscalated
						WHERE nID = @nID
					END
					IF @@ROWCOUNT <> 0
					BEGIN
						INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES( 'Request', @nID, @sAlias, GETDATE(),'Updated Time Off for: ' + @sRequestor )
						SET @bReturnCode = 'true'
					END
				END
				ELSE
				BEGIN
					SET @bReturnCode = 'false'
					SET @errorMsg = 'Error: submitted time off Overlaps with existing time off'
					RAISERROR(@errorMsg, 16,1)
				END
			END
			ELSE
			BEGIN
				SET @bReturnCode = 'false'
				SET @errorMsg = 'Error: Leave Entitlement Policy Threshold exceeded'
				RAISERROR(@errorMsg, 16,1)
			END
		END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @errorMsg = 'Error: Optional Holidays violation'
			RAISERROR(@errorMsg, 16,1)
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION UpdateTimeOff
		SET @bReturnCode = 'false'
		RETURN
	END CATCH
COMMIT TRANSACTION UpdateTimeOff
RETURN
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_timeoff')
	delete from GxQscripts where name = 'TOUpdate_timeoff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_timeoff')
	delete from GXDBVersions where aliasname = 'TOUpdate_timeoff'
GO

insert into GXDBVersions values(2, 'TOUpdate_timeoff',  '00010002000200060000', 'TOUpdate_timeoff', '00010002000200060000')
GO

