

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_request_type.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_request_type.sp,v $ $Id: TOUpdate_request_type.sp,v 1.2.2.4 2018/03/27 08:42:04 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_request_type <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_request_type')
	drop procedure TOUpdate_request_type
IF EXISTS (select * from GxQscripts where name='TOUpdate_request_type')
	delete from GxQscripts where name = 'TOUpdate_request_type'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_request_type')
	delete from GXDBVersions where aliasname = 'TOUpdate_request_type'
GO
print '... Creating Procedure: TOUpdate_request_type'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_request_type
  @sAlias NVARCHAR(50),
  @nID INT,
  @sRequestType NVARCHAR(255),
  @bIsDeductible BIT,
  @nEntitlementPolicyID INT,	
  @nApprovalPolicyID INT,
  @bIsVisibleToAll BIT,
  @nLocationID INT,
  @bIsOverlapAllowed BIT,
  @sOverlapRequestType NVARCHAR(50) ,
  @bIsHalfDayAllowed BIT,
  @bIsOptionalType BIT,
  @sDept nvarchar(MAX),
  @nOverridingReqID INT,
  @nRequestTypeID INT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @bIsAnyOverlapWithNewPolicy BIT
	DECLARE @dNewPolicyStartDate DATE
	DECLARE @dNewPolicyEndDate DATE
	DECLARE @nOldLEPId INT = 0
	DECLARE @bIsAnyOptType BIT = 'false'
	SELECT @bIsAnyOptType = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TORequestType WHERE bIsOptionalType ='true' AND nLocationID = @nLocationID AND nID <> @nID
	IF @bIsAnyOptType = 'true' AND @bIsOptionalType = 'true'
	BEGIN
		SET @nRequestTypeID = -1
		SET @errorMsg = 'Error: Couldn''t add two optional request type'
		RETURN
	END
	SELECT @nOldLEPId = LEP.nID FROM TORequestType RT JOIN TOLeaveEntitlementPolicy LEP ON nEntitlementPolicyID = LEP.nID WHERE RT.nID = @nID
	SELECT @dNewPolicyStartDate = dRenewedOn, @dNewPolicyEndDate = DATEADD(DAY, -1, DATEADD(MONTH,nDuration,dRenewedOn)) FROM TOLeaveEntitlementPolicy WHERE nID = @nEntitlementPolicyID
	SELECT @bIsAnyOverlapWithNewPolicy = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TORequests R WHERE R.nRequestTypeID = @nID AND R.nHelperRequestStatusID IN (1,2) AND
				((dateStart BETWEEN @dNewPolicyStartDate AND @dNewPolicyEndDate) OR (dateEnd BETWEEN @dNewPolicyStartDate AND @dNewPolicyEndDate))
	IF @nOldLEPId = @nEntitlementPolicyID
		SET @bIsAnyOverlapWithNewPolicy = 'false'
	IF @bIsAnyOverlapWithNewPolicy = 'false'
	BEGIN
		IF @nOldLEPId <> @nEntitlementPolicyID
		BEGIN
			UPDATE TOLeaveEntitlementPolicyHistory SET bIsHistory = 'true' WHERE nRequestTypeID = @nID
			INSERT INTO TOLeaveEntitlementPolicyHistory (nID, nMaxAllowed,  nMaxContAllowed, nAccruedPerMonth, dRenewedOn, nDuration, nMaxCountAllowed, XMLInfo, sPolicyName, nCarryFwdAllowed,
			dDateDumpedToHistory, nRequestTypeID, bIsHistory)
			SELECT LEP.nID, nMaxAllowed,  nMaxContAllowed, nAccruedPerMonth, dRenewedOn, nDuration, nMaxCountAllowed, XMLInfo, sPolicyName, nCarryFwdAllowed,
			GETDATE(), RT.nID, 'false' FROM TOLeaveEntitlementPolicy LEP JOIN TORequestType RT ON
				RT.nEntitlementPolicyID = LEP.nID
			WHERE RT.nID = @nID
	    END
		IF @sDept IS NOT NULL
		BEGIN
			DECLARE @NoOfDeptAvailable INT = 0
			DECLARE @NoOfDeptPasses INT = 0
			SELECT @NoOfDeptAvailable = COUNT(*) FROM TODepartment D JOIN dbo.TOSplit(@sDept, ',') T
				ON D.nID = T.Item
			SELECT @NoOfDeptPasses = COUNT(*) FROM dbo.TOSplit(@sDept, ',') T
			IF @NoOfDeptAvailable != @NoOfDeptAvailable
			BEGIN
				SET @nRequestTypeID = -1
				SET @errorMsg = 'Error: Couldn''t find department'
				RETURN
			END
		END
		IF @nOverridingReqID IS NOT NULL AND @nOverridingReqID > 0
		BEGIN
			DECLARE @bIsOverrideReqTypeValid BIT = 'true'
			SELECT @bIsOverrideReqTypeValid = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TORequestType RT JOIN TOLocation L
				ON RT.nLocationID = L.nParentLocID AND L.nID = @nLocationID  AND RT.nID = @nOverridingReqID
			IF @bIsOverrideReqTypeValid = 'false'
			BEGIN
				SET @nRequestTypeID = -1
				SET @errorMsg = 'Error: Couldn''t override request type'
				RETURN
			END
		END
		UPDATE TORequestType SET sRequestType = @sRequestType, bIsDeductible = @bIsDeductible, nEntitlementPolicyID = @nEntitlementPolicyID, nApprovalPolicyID = @nApprovalPolicyID,
						   bIsVisibleToAll = @bIsVisibleToAll, nLocationID = @nLocationID, bIsOverlapAllowed = @bIsOverlapAllowed, sOverlapRequestType = @sOverlapRequestType,
						   bIsHalfDayAllowed = @bIsHalfDayAllowed, bIsOptionalType = @bIsOptionalType, sDept = @sDept, nOverridingReqID = @nOverridingReqID
		WHERE nID = @nID
		IF @@ROWCOUNT <> 0
		BEGIN
			SET @nRequestTypeID = @nID
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TORequestType', @nID, @sAlias, GETDATE(),'Updated Request Type: ' + @sRequestType)
		END
		ELSE
		BEGIN
			SET @nRequestTypeID = -1
			SET @errorMsg = 'Error: Couldn''t update the request type'
		END
	END
	ELSE
	BEGIN
		SET @nRequestTypeID = -1
		SET @errorMsg = 'Error: Couldn''t update the leave entitlement policy as already time offs are submitted for new policy tenure'
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_request_type')
	delete from GxQscripts where name = 'TOUpdate_request_type'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_request_type')
	delete from GXDBVersions where aliasname = 'TOUpdate_request_type'
GO

insert into GXDBVersions values(2, 'TOUpdate_request_type',  '00010002000200040000', 'TOUpdate_request_type', '00010002000200040000')
GO

