

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_proxy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_proxy.sp,v $ $Id: TOUpdate_proxy.sp,v 1.2.2.1 2018/03/27 08:44:14 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_proxy <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_proxy')
	drop procedure TOUpdate_proxy
IF EXISTS (select * from GxQscripts where name='TOUpdate_proxy')
	delete from GxQscripts where name = 'TOUpdate_proxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_proxy')
	delete from GXDBVersions where aliasname = 'TOUpdate_proxy'
GO
print '... Creating Procedure: TOUpdate_proxy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_proxy
  @sAlias NVARCHAR(50),	
  @nID INT,	
  @dValidFrom DATE,	
  @dExpiryDate DATE,  
  @sProxy NVARCHAR(50), 
  @sUser NVARCHAR(50),
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @nProxyCount INT = 0
	SELECT @nProxyCount = COUNT(*) FROM TOProxys WHERE sUser = @sUser AND nID <> @nID AND bIsDeleted = 0 AND ( (dValidFrom BETWEEN @dValidFrom AND @dExpiryDate) OR (dExpiryDate BETWEEN @dValidFrom AND @dExpiryDate)
		OR (dValidFrom <= @dValidFrom AND dExpiryDate >= @dExpiryDate) OR (@dValidFrom <= dValidFrom   AND @dExpiryDate >= dExpiryDate) )
    IF @nProxyCount > 0 -- start date is less than end date
    BEGIN
		SET @bReturnCode = 'false'
		SET @errorMsg = 'Error: Already a proxy is assigned for given dates'
	END
	ELSE
    BEGIN
		UPDATE TOProxys SET dValidFrom = @dValidFrom, dExpiryDate = @dExpiryDate,  sProxy = @sProxy, sUser = @sUser WHERE nID = @nID
		INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOProxys', @nID, @sAlias, GETDATE(),'Updated Proxy for user: ' + @sUser)
		SET @bReturnCode = 'true'
		SET @errorMsg = 'success'
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_proxy')
	delete from GxQscripts where name = 'TOUpdate_proxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_proxy')
	delete from GXDBVersions where aliasname = 'TOUpdate_proxy'
GO

insert into GXDBVersions values(2, 'TOUpdate_proxy',  '00010002000200010000', 'TOUpdate_proxy', '00010002000200010000')
GO

