

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_location.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_location.sp,v $ $Id: TOUpdate_location.sp,v 1.2.2.2 2018/03/27 09:17:23 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_location <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_location')
	drop procedure TOUpdate_location
IF EXISTS (select * from GxQscripts where name='TOUpdate_location')
	delete from GxQscripts where name = 'TOUpdate_location'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_location')
	delete from GXDBVersions where aliasname = 'TOUpdate_location'
GO
print '... Creating Procedure: TOUpdate_location'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_location
  @sAlias NVARCHAR(50),		
  @nID INT ,
  @sTimeZone NVARCHAR(255),
  @sCountryName NVARCHAR(255),
  @sRegionName NVARCHAR(255),		
  @nParentLocID INT ,	
  @bReturnCode BIT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @bIsLocationExist BIT
	DECLARE @bIsParentLocExist BIT
	SELECT @bIsLocationExist = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TOLocation
		WHERE sCountryName= RTRIM(LTRIM(@sCountryName)) AND sRegionName = LTRIM(RTRIM(@sRegionName)) AND nID <> @nID
	IF @nParentLocID != 0 AND @nParentLocID IS NOT NULL
	BEGIN
		SELECT @bIsParentLocExist = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TOLocation
		WHERE nID = @nParentLocID
	END
		SET @bIsParentLocExist = 'true'
	IF @bIsLocationExist = 'false' AND (@bIsParentLocExist = 'true' OR @bIsParentLocExist IS NULL)
	BEGIN
		UPDATE TOLocation SET nIsActive = 1 , sTimeZone = @sTimeZone,  sCountryName = RTRIM(LTRIM(@sCountryName))
			, sRegionName = RTRIM(LTRIM(@sRegionName)), nParentLocID = @nParentLocID WHERE nID = @nID
		IF @@ROWCOUNT > 0
		BEGIN
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOLocation', @nID, @sAlias, GETDATE(),'Updated TOLocation: ' + @sRegionName)
			SET @bReturnCode = 'true'
			END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @nID = -1
		END
	END
	ELSE
	BEGIN
		SET @bReturnCode = 'false'
		SET @nID = -1
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_location')
	delete from GxQscripts where name = 'TOUpdate_location'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_location')
	delete from GXDBVersions where aliasname = 'TOUpdate_location'
GO

insert into GXDBVersions values(2, 'TOUpdate_location',  '00010002000200020000', 'TOUpdate_location', '00010002000200020000')
GO

