

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_leave_entitlement_policy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_leave_entitlement_policy.sp,v $ $Id: TOUpdate_leave_entitlement_policy.sp,v 1.2.2.1 2018/03/27 08:54:54 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_leave_entitlement_policy <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_leave_entitlement_policy')
	drop procedure TOUpdate_leave_entitlement_policy
IF EXISTS (select * from GxQscripts where name='TOUpdate_leave_entitlement_policy')
	delete from GxQscripts where name = 'TOUpdate_leave_entitlement_policy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_leave_entitlement_policy')
	delete from GXDBVersions where aliasname = 'TOUpdate_leave_entitlement_policy'
GO
print '... Creating Procedure: TOUpdate_leave_entitlement_policy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_leave_entitlement_policy
  @sAlias NVARCHAR(50),
  @nID INT,	
  @nMaxAllowed INT,
  @nMaxContAllowed DECIMAL(5,2), 
  @nAccruedPerMonth DECIMAL(5,2), 
  @dRenewedOn DATETIME, 
  @nDuration INT, 
  @nMaxCountAllowed DECIMAL(5,2), 	
  @sPolicyName NVARCHAR(255), 
  @nCarryFwdAllowed INT,	
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @nOldMaxAllowed INT = -1
	DECLARE @nOldMaxContAllowed INT = -1
	DECLARE @nOldMaxCountAllowed INT = -1
	DECLARE @nDurationViolation INT = -1
	DECLARE @bIsIdInHistory BIT = 'false'
	SELECT @bIsIdInHistory = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TOLeaveEntitlementPolicyHistory LEPH WHERE LEPH.nID = @nID
	IF @bIsIdInHistory = 'false'
	BEGIN
		SELECT @bIsIdInHistory = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TOEmployeeToPolicyMappingHistory EPH WHERE EPH.nLeaveEntitlementPolicyID = @nID
		IF @bIsIdInHistory = 'false'
		BEGIN
			SELECT TOP 1 @nOldMaxCountAllowed = COUNT(*), @nOldMaxAllowed = SUM(nWorkDays), @nOldMaxContAllowed = MAX(DATEDIFF(DAY, dateStart, dateEnd))
			FROM TORequests R JOIN TORequestType RT
				ON RT.nID = R.nRequestTypeID
			JOIN TOLeaveEntitlementPolicy LEP
				ON LEP.nID = RT.nEntitlementPolicyID
			WHERE LEP.nID = @nID AND sRequestor NOT IN
			(SELECT sEmpAlias FROM TOEmployeeToPolicyMapping EMP JOIN TOLeaveEntitlementPolicy LEP1
				ON LEP1.nID = EMP.nLeaveEntitlementPolicyID AND
				R.dateStart BETWEEN LEP1.dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, LEP1.dRenewedOn)) AND R.dateEnd BETWEEN LEP1.dRenewedOn
				AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, LEP1.dRenewedOn))
			WHERE EMP.nLeaveEntitlementPolicyID <> @nID AND EMP.nRequestType = RT.nID)
			AND R.dateStart BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn)) AND dateEnd BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
			GROUP BY sRequestor, nRequestTypeID
			HAVING COUNT(*) > @nMaxCountAllowed OR SUM(nWorkDays) > @nMaxAllowed OR MAX(DATEDIFF(DAY, dateStart, dateEnd)) > @nMaxContAllowed
			IF (@nOldMaxCountAllowed = -1 AND @nOldMaxAllowed = -1 AND @nOldMaxContAllowed = -1)
			BEGIN
				SELECT TOP 1 @nOldMaxCountAllowed = COUNT(*), @nOldMaxAllowed = SUM(nWorkDays), @nOldMaxContAllowed = MAX(DATEDIFF(DAY, dateStart, dateEnd))
				FROM TORequests R JOIN TOEmployeeToPolicyMapping EMP
					ON R.nRequestTypeID = EMP.nRequestType
				JOIN TOLeaveEntitlementPolicy LEP
					ON LEP.nID = EMP.nLeaveEntitlementPolicyID
				WHERE LEP.nID = @nID AND R.dateStart BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
				AND dateEnd BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
				GROUP BY sRequestor, nRequestTypeID
				HAVING COUNT(*) > @nMaxCountAllowed OR SUM(nWorkDays) > @nMaxAllowed OR MAX(DATEDIFF(DAY, dateStart, dateEnd)) > @nMaxContAllowed
				IF (@nOldMaxCountAllowed = -1 AND @nOldMaxAllowed = -1 AND @nOldMaxContAllowed = -1)
				BEGIN
					UPDATE TOLeaveEntitlementPolicy SET nMaxAllowed = @nMaxAllowed, nMaxContAllowed = @nMaxContAllowed,
					nAccruedPerMonth = @nAccruedPerMonth,-- dRenewedOn = @dRenewedOn, nDuration = @nDuration,  -- do not allow to change duration and start date of the policy
					nMaxCountAllowed = @nMaxCountAllowed, sPolicyName = @sPolicyName, nCarryFwdAllowed = @nCarryFwdAllowed WHERE nID= @nID
					IF @@ROWCOUNT <> 0
					BEGIN
						INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOLeaveEntitlementPolicy', @nID, @sAlias, GETDATE(),'Updated Leave Entitlement Policy: ' + @sPolicyName)
						SET @bReturnCode = 'true'
					END
					ELSE
					BEGIN
						SET @bReturnCode = 'false'
						SET @errorMsg = 'Error: cannot update leave entitlement policy'
					END
				END
				ELSE
				BEGIN
					SET @bReturnCode = 'false'
					SET @errorMsg = 'Error: entitlement policy is already assigned to some employees and updated values are violating existing time offs'
				END
			END
			ELSE
			BEGIN
				SET @bReturnCode = 'false'
				SET @errorMsg = 'Error: entitlement policy is already assigned to request type and updated values are violating existing time offs'
			END
		END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @errorMsg = 'Error: entitlement policy is already in history, update is not allowed'
		END
	END
	ELSE
	BEGIN
		SET @bReturnCode = 'false'
		SET @errorMsg = 'Error: entitlement policy is already in history, update is not allowed'
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_leave_entitlement_policy')
	delete from GxQscripts where name = 'TOUpdate_leave_entitlement_policy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_leave_entitlement_policy')
	delete from GXDBVersions where aliasname = 'TOUpdate_leave_entitlement_policy'
GO

insert into GXDBVersions values(2, 'TOUpdate_leave_entitlement_policy',  '00010002000200010000', 'TOUpdate_leave_entitlement_policy', '00010002000200010000')
GO

