

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_holidays.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_holidays.sp,v $ $Id: TOUpdate_holidays.sp,v 1.2.2.1 2018/03/27 08:52:07 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_holidays <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_holidays')
	drop procedure TOUpdate_holidays
IF EXISTS (select * from GxQscripts where name='TOUpdate_holidays')
	delete from GxQscripts where name = 'TOUpdate_holidays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_holidays')
	delete from GXDBVersions where aliasname = 'TOUpdate_holidays'
GO
print '... Creating Procedure: TOUpdate_holidays'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_holidays
  @sAlias NVARCHAR(50),	
  @nID INT,
  @StartDate DATE,	
  @EndDate DATE, 
  @nIsOptional INT, 
  @nLocationID INT, 
  @sName NVARCHAR(255),
  @bReturnCode BIT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @nHolidayDays INT
	SET @nHolidayDays = DATEDIFF(DAY, @StartDate, @EndDate) + 1
    IF @nHolidayDays > 0 -- start date is less than end date
    BEGIN
		UPDATE TOHolidays SET dStartDate = @StartDate, dEndDate = @EndDate,  nStatus = 1, nIsOptional = @nIsOptional, nLocationID = @nLocationID, sName = @sName
		WHERE nID = @nID
		INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOHolidays', @nID, @sAlias, GETDATE(),'Updated TOHolidays: ' + @sName)
		SET @bReturnCode = 'true'
	END
	ELSE
		SET @bReturnCode = 'false'
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_holidays')
	delete from GxQscripts where name = 'TOUpdate_holidays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_holidays')
	delete from GXDBVersions where aliasname = 'TOUpdate_holidays'
GO

insert into GXDBVersions values(2, 'TOUpdate_holidays',  '00010002000200010000', 'TOUpdate_holidays', '00010002000200010000')
GO

