

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_employees.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_employees.sp,v $ $Id: TOUpdate_employees.sp,v 1.2.2.1 2018/03/27 08:59:24 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_employees <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_employees')
	drop procedure TOUpdate_employees
IF EXISTS (select * from GxQscripts where name='TOUpdate_employees')
	delete from GxQscripts where name = 'TOUpdate_employees'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_employees')
	delete from GXDBVersions where aliasname = 'TOUpdate_employees'
GO
print '... Creating Procedure: TOUpdate_employees'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_employees
  @sAlias NVARCHAR(50),
  @ProdcertName NVARCHAR(50),		
  @nLocationID INT,
  @Manager NVARCHAR(255),
  @dHiredDate DATETIME,
  @sMobileNumber NVARCHAR(50),
  @sPhoneNumber NVARCHAR(50),
  @bIsDeleted BIT,
  @sEmail NVARCHAR(255),	
  @Gender BIT,
  @sEmpName NVARCHAR(255),
  @nTitleID INT,
  @nDeptID INT,
  @nTeamID INT,
  @sEmpID NVARCHAR(50),
  @bReturnCode BIT OUTPUT
,
  @nID INT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @ManagerCount INT = 0
	DECLARE @bIsSameManager BIT = 0
	DECLARE @Table TABLE (ManagerCount INT)
	DECLARE @SameManager NVARCHAR(255)
	IF @Manager IS NOT NULL
	BEGIN
		IF @Manager = @ProdcertName
			SET @bIsSameManager = 1
		ELSE
			INSERT INTO @Table SELECT  COUNT(ProdcertName) FROM TOEmployee E JOIN dbo.TOSplit(@Manager, ',') T ON E.ProdcertName = T.Item GROUP BY E.ProdcertName HAVING COUNT(ProdcertName) = 1
	END
	IF (SELECT COUNT(*) FROM @Table) = (SELECT COUNT(*) FROM dbo.TOSplit(@Manager, ',')) OR (@bIsSameManager = 'true') OR (@Manager IS NULL)
    BEGIN
		SELECT @nID = nID FROM TOEmployee WHERE ProdcertName = @ProdcertName
		IF @nID > 0
		BEGIN
			UPDATE TOEmployee SET nLocationID = @nLocationID,Manager = @Manager,dHiredDate = @dHiredDate,sMobileNumber = @sMobileNumber,sPhoneNumber = @sPhoneNumber,
			bIsDeleted = @bIsDeleted,sEmail = @sEmail,Gender = @Gender,sEmpName = @sEmpName,
			nTitleID = @nTitleID,nDeptID = @nDeptID,nTeamID = @nTeamID, sEmpID = @sEmpID WHERE ProdcertName = @ProdcertName
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOEmployee', @nID, @sAlias, GETDATE(),'Updated TOEmployee: ' + @ProdcertName)
			SET @bReturnCode = 'true'
		END
		ELSE
			SET @bReturnCode = 'false'
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_employees')
	delete from GxQscripts where name = 'TOUpdate_employees'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_employees')
	delete from GXDBVersions where aliasname = 'TOUpdate_employees'
GO

insert into GXDBVersions values(2, 'TOUpdate_employees',  '00010002000200010000', 'TOUpdate_employees', '00010002000200010000')
GO

