

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOUpdate_employee_policy_mapping.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOUpdate_employee_policy_mapping.sp,v $ $Id: TOUpdate_employee_policy_mapping.sp,v 1.2.2.2 2018/03/27 09:10:28 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOUpdate_employee_policy_mapping <<<'

IF EXISTS (select * from sysobjects where name='TOUpdate_employee_policy_mapping')
	drop procedure TOUpdate_employee_policy_mapping
IF EXISTS (select * from GxQscripts where name='TOUpdate_employee_policy_mapping')
	delete from GxQscripts where name = 'TOUpdate_employee_policy_mapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_employee_policy_mapping')
	delete from GXDBVersions where aliasname = 'TOUpdate_employee_policy_mapping'
GO
print '... Creating Procedure: TOUpdate_employee_policy_mapping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOUpdate_employee_policy_mapping
  @sAlias NVARCHAR(50),			
  @PolicyMap dbo.Employee_Policy_Map READONLY,
  @sRequestor NVARCHAR(50),
  @bReturnCode BIT OUTPUT
,
  @nID INT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @IDs TABLE(nID INT, ProdcertName NVARCHAR(50))
	DECLARE @PolicyDuration TABLE (sAlias NVARCHAR(50), nID INT, nReqType INT, dPolicyStartDate DATE, dPolicyEndDate DATE)
	DECLARE @DeletePolicyDuration TABLE (sAlias NVARCHAR(50), nID INT, nReqType INT, dPolicyStartDate DATE, dPolicyEndDate DATE)
	DECLARE @ModifyPolicyDuration TABLE (sAlias NVARCHAR(50), nID INT, nReqType INT, dPolicyStartDate DATE, dPolicyEndDate DATE)
	DECLARE @NoModifyPolicyDuration TABLE (sAlias NVARCHAR(50), nID INT, nReqType INT, dPolicyStartDate DATE, dPolicyEndDate DATE)
	DECLARE @bIsAnyOverlapWithNewPolicy BIT
	DECLARE @PolicyMapCount  INT
	SELECT @PolicyMapCount = COUNT(*) FROM @PolicyMap
	IF @PolicyMapCount = 0
	BEGIN
		DECLARE @PrevOldCount INT = 0
		SELECT @PrevOldCount = COUNT(*) FROM TOEmployeeToPolicyMapping WHERE sEmpAlias = @sRequestor
		INSERT INTO @PolicyDuration SELECT EP.sEmpAlias, L.nID, nRequestType, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration,dRenewedOn)) FROM TOLeaveEntitlementPolicy L JOIN TOEmployeeToPolicyMapping EP
										ON EP.nLeaveEntitlementPolicyID = L.nID  AND sEmpAlias = @sRequestor
		SELECT @bIsAnyOverlapWithNewPolicy = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TORequests R JOIN @PolicyDuration P
			ON P.nReqType = R.nRequestTypeID
		WHERE R.nHelperRequestStatusID IN (1,2) AND sRequestor = @sRequestor AND
				((dateStart BETWEEN dPolicyStartDate AND dPolicyEndDate) OR (dateEnd BETWEEN dPolicyStartDate AND dPolicyEndDate))
		IF @bIsAnyOverlapWithNewPolicy = 'false' OR @PrevOldCount = 0
		BEGIN
			SET @bReturnCode = 'true'
			DELETE FROM TOEmployeeToPolicyMapping WHERE sEmpAlias = @sRequestor
		END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @nID = -1
		END
	END
	ELSE
	BEGIN
		DECLARE @PrevCount INT = 0
		DECLARE @NewLEPCount INT = 0
		DECLARE @NewTotalLEPCount INT = 0
		DECLARE @NewLAPCount INT = 0
		SELECT @PrevCount = COUNT(*) FROM TOEmployeeToPolicyMapping WHERE sEmpAlias = @sRequestor
		SELECT @NewLEPCount = COUNT(*) From TOEmployeeToPolicyMapping E JOIN @PolicyMap P
			ON E.sEmpAlias = P.sAlias AND E.nLeaveEntitlementPolicyID = P.nLEPID AND E.nRequestType = P.nRequestType
		SELECT @NewTotalLEPCount = COUNT(*) From @PolicyMap P
		IF (@PrevCount = @NewLEPCount) AND (@PrevCount = @NewTotalLEPCount)
		BEGIN
			UPDATE TOEmployeeToPolicyMapping SET nLeaveApprovalPolicyID = T.nLAPID
												FROM (SELECT nLAPID  From TOEmployeeToPolicyMapping E JOIN @PolicyMap P
															ON E.sEmpAlias = P.sAlias AND E.nRequestType = P.nRequestType) T
			IF @@ROWCOUNT > 0
			BEGIN
				INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  SELECT 'TOEmployeeToPolicyMapping', T.nID, @sAlias, GETDATE(),'Updated TOEmployeeToPolicyMapping for: ' + T.ProdcertName  FROM @IDs T
				SET @bReturnCode = 'true'
				SET @nID = @@ROWCOUNT
			END
			ELSE
			BEGIN
				SET @bReturnCode = 'false'
				SET @nID = -1
			END
		END
		ELSE
		BEGIN
			INSERT INTO @NoModifyPolicyDuration SELECT P.sEmpAlias, LEP.nID, P.nRequestType, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration,dRenewedOn))
										   FROM TOLeaveEntitlementPolicy LEP JOIN TOEmployeeToPolicyMapping P
												ON P.nLeaveEntitlementPolicyID = LEP.nID
										   JOIN @PolicyMap PM
												ON PM.sAlias = P.sEmpAlias AND P.nLeaveEntitlementPolicyID = PM.nLEPID AND P.nRequestType = PM.nRequestType
										   WHERE P.sEmpAlias = @sRequestor
			INSERT INTO @DeletePolicyDuration SELECT P.sEmpAlias, LEP.nID, P.nRequestType, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration,dRenewedOn))
										   FROM TOLeaveEntitlementPolicy LEP JOIN TOEmployeeToPolicyMapping P
												ON P.nLeaveEntitlementPolicyID = LEP.nID
										   WHERE P.sEmpAlias = @sRequestor AND P.nRequestType NOT IN (SELECT nRequestType FROM @PolicyMap)
			INSERT INTO @ModifyPolicyDuration SELECT P.sAlias, nID, nRequestType, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration,dRenewedOn))
										FROM TOLeaveEntitlementPolicy JOIN @PolicyMap P
											ON P.nLEPID = nID
										 EXCEPT
										 (SELECT sAlias, nID, nReqType, dPolicyStartDate, dPolicyEndDate FROM @NoModifyPolicyDuration
										 UNION
										 SELECT sAlias, nID, nReqType, dPolicyStartDate, dPolicyEndDate FROM @DeletePolicyDuration)
			SELECT @bIsAnyOverlapWithNewPolicy = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TORequests R JOIN
				(SELECT sAlias, nID, nReqType, dPolicyStartDate, dPolicyEndDate FROM @ModifyPolicyDuration
				 UNION
				 SELECT sAlias, nID, nReqType, dPolicyStartDate, dPolicyEndDate FROM @DeletePolicyDuration) P
					ON P.nReqType = R.nRequestTypeID
			WHERE R.nHelperRequestStatusID IN (1,2) AND sRequestor = @sRequestor AND
					((dateStart BETWEEN dPolicyStartDate AND dPolicyEndDate) OR (dateEnd BETWEEN dPolicyStartDate AND dPolicyEndDate))
			IF @bIsAnyOverlapWithNewPolicy = 'false'
			BEGIN
				UPDATE TOEmployeeToPolicyMappingHistory SET bIsHistory = 'true'
				FROM
					TOEmployeeToPolicyMapping E JOIN
					(SELECT sAlias, nID, nReqType, dPolicyStartDate, dPolicyEndDate FROM @ModifyPolicyDuration
					UNION
					SELECT sAlias, nID, nReqType, dPolicyStartDate, dPolicyEndDate FROM @DeletePolicyDuration) P
						ON E.nRequestType = P.nReqType AND P.sAlias = E.sEmpAlias
				INSERT INTO TOEmployeeToPolicyMappingHistory (sEmpAlias, nLeaveEntitlementPolicyID, nMaxAllowed, nMaxContAllowed, nCarryFwdAllowed, nAccruedPerMonth, nMaxCountAllowed, nDuration,
				dRenewedOn, nLeaveApprovalPolicyID, dDateCreated, nRequestType,dDateDumpedTOHistory, bIsHistory)
				SELECT E.sEmpAlias, LEP.nID, nMaxAllowed, nMaxContAllowed, nCarryFwdAllowed, nAccruedPerMonth, nMaxCountAllowed, nDuration, dRenewedOn, E.nLeaveApprovalPolicyID,
				E.dDateCreated, E.nRequestType, GETDATE(), 'false'
				FROM TOLeaveEntitlementPolicy LEP JOIN TOEmployeeToPolicyMapping E
					ON E.nLeaveEntitlementPolicyID = LEP.nID
				JOIN @ModifyPolicyDuration P
					ON E.sEmpAlias = P.sAlias AND P.nReqType = E.nRequestType
				DELETE FROM TOEmployeeToPolicyMapping
				WHERE nRequestType NOT IN (SELECT nReqType FROM @NoModifyPolicyDuration)
				AND sEmpAlias = @sRequestor
				INSERT INTO TOEmployeeToPolicyMapping (sEmpAlias, nLeaveEntitlementPolicyID, nLeaveApprovalPolicyID, dDateCreated, nRequestType)
				OUTPUT inserted.nID, inserted.sEmpAlias INTO @IDs(nID, ProdcertName)
				SELECT @sRequestor, nLEPID, nLAPID, GETDATE(), nRequestType
					FROM @ModifyPolicyDuration P JOIN @PolicyMap PM
						ON P.nReqType = PM.nRequestType AND P.nID = PM.nLEPID AND P.sAlias = PM.sAlias
				SET @nID = SCOPE_IDENTITY()
				IF @@ROWCOUNT > 0
				BEGIN
					INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  SELECT 'TOEmployeeToPolicyMapping', T.nID, @sAlias, GETDATE(),'Updated TOEmployeeToPolicyMapping for: ' + T.ProdcertName  FROM @IDs T
					SET @bReturnCode = 'true'
					SET @nID = @@ROWCOUNT
				END
				ELSE
				BEGIN
					SET @bReturnCode = 'false'
					SET @nID = -1
				END
			END
			ELSE
			BEGIN
				SET @bReturnCode = 'false'
				SET @nID = -1
			END
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOUpdate_employee_policy_mapping')
	delete from GxQscripts where name = 'TOUpdate_employee_policy_mapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOUpdate_employee_policy_mapping')
	delete from GXDBVersions where aliasname = 'TOUpdate_employee_policy_mapping'
GO

insert into GXDBVersions values(2, 'TOUpdate_employee_policy_mapping',  '00010002000200020000', 'TOUpdate_employee_policy_mapping', '00010002000200020000')
GO

