

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOGet_timesheets_for_approval.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOGet_timesheets_for_approval.sp,v $ $Id: TOGet_timesheets_for_approval.sp,v 1.1.2.6 2020/11/12 01:47:58 isebastian Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TOGet_timesheets_for_approval')
BEGIN
	print '>>> Drop Stored Procedure: TOGet_timesheets_for_approval <<<'
	drop procedure TOGet_timesheets_for_approval
END
IF EXISTS (select * from GxQscripts where name='TOGet_timesheets_for_approval')
	delete from GxQscripts where name = 'TOGet_timesheets_for_approval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timesheets_for_approval')
	delete from GXDBVersions where aliasname = 'TOGet_timesheets_for_approval'
GO
print '... Creating Procedure: TOGet_timesheets_for_approval'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TOGet_timesheets_for_approval
  @sRequestor NVARCHAR(50),
  @sRequestStatus NVARCHAR(50),
  @Locations dbo.UserAlias READONLY,
  @pageNo INT,
  @pageSize INT,
  @empIDs dbo.UserAlias READONLY,
  @nTotalCount INT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE  @SpecialEscTable TABLE (login NVARCHAR(255), email NVARCHAR(255))
	DECLARE  @doubleOTWorkStates TABLE (nID INT)
	DECLARE @doubleOTStates NVARCHAR(512) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetOvertimeWorkState')
	INSERT INTO @doubleOTWorkStates SELECT Item FROM dbo.TOSplit(@doubleOTStates,',')
	DECLARE  @overtimeStatus TABLE (status NVARCHAR(256))
	DECLARE @status NVARCHAR(1024) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetOvertimeStatus')
	INSERT INTO @overtimeStatus SELECT Item FROM dbo.TOSplit(@status,',')
	DECLARE  @timesheetUsers TABLE (status NVARCHAR(256))
	DECLARE @users NVARCHAR(1024) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetUsers')
	INSERT INTO @timesheetUsers SELECT Item FROM dbo.TOSplit(@users,',')
	DECLARE @bIsSomeEmpSelected BIT = (SELECT CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM @empIDs)
	DECLARE @bIsLocationSelected BIT = (SELECT CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM @Locations)
	DECLARE @location TABLE (nID INT)
	IF @bIsLocationSelected = 'false'
	BEGIN
		INSERT INTO @location SELECT nID FROM TOLocation
	END
	ELSE
	BEGIN
		INSERT INTO @location SELECT sAlias FROM @Locations
	END
	IF @bIsSomeEmpSelected = 'false'
	BEGIN
		SET @nTotalCount = (SELECT COUNT(*)
							FROM
							TOTimeSheet T  WITH(NOLOCK) JOIN TOEmployee E WITH(NOLOCK)
								ON T.sRequestor = E.ProdcertName
							LEFT JOIN TOTimeSheetProxys P WITH(NOLOCK)
								ON (P.sUser = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END
									 AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate AND P.sProxy = @sRequestor)
							JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
								ON HRS.nID = T.nHelperTimeSheetStatusId AND T.bIsSubmitted = 'true'
							JOIN TOLocation L WITH(NOLOCK)
								ON L.nID = E.nLocationID
							JOIN @location TL
								ON  E.nLocationID = TL.nID
						WHERE (CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END =  @sRequestor
							  OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate))
							  AND HRS.sStatus = @sRequestStatus
						)
		SELECT * FROM
			(SELECT T.nID, sRequestor, weekStart, dateFilledIn, timeMonStart, timeMonEnd, timeTueStart, timeTueEnd, timeWedStart, timeWedEnd, timeThuStart, timeThuEnd
				, timeFriStart, timeFriEnd, timeSatStart, timeSatEnd, timeSunStart, timeSunEnd, sSubmittedBy, sComments, HRS.sStatus As status, nHoursSubmitted
				, bIsSubmitted, monBreaktime, tueBreakTime, wedBreakTime, thuBreakTime, friBreakTime, satBreakTime, sunBreakTime, nOTHours, nDoubleOThours
				, sApprovedBy, sApproverComments, dateApproved, T.sickDays
				, CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
				, CASE WHEN E.status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
				, CASE WHEN E.prevLocationID IS NULL THEN NULL WHEN E.prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
				, CASE WHEN E.prevStatus IS NULL THEN NULL WHEN E.prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
				, E.EffectiveDateOfChange
				, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers)
				THEN
					CASE WHEN DATEDIFF(wk, CONVERT(DATE, E.EffectiveDateOfChange - DATEPART(dw,  E.EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4 THEN 'false'
					ELSE 'true' END
				ELSE 'false' END AS isOldStatusCheckRequired
				, E1.ProdcertName AS sPayrollProcessedByAlias, E1.sEmpName AS sPayrollProcessedByName, T.datePayrollProcessed
				,E.sEmpName, E.sEmpID, L.sRegionName, ROW_NUMBER() OVER (ORDER BY CASE WHEN @sRequestStatus = 'approved' THEN T.dateApproved ELSE T.dateFilledIn END DESC, T.nID DESC) AS RowNum
			FROM TOTimeSheet T  WITH(NOLOCK) JOIN TOEmployee E WITH(NOLOCK)
					ON T.sRequestor = E.ProdcertName
				LEFT JOIN TOEmployee E1
					ON E1.ProdcertName = T.sPayrollProcessedBy
				LEFT JOIN TOTimeSheetProxys P WITH(NOLOCK)
					ON (P.sUser = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END
							AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate  AND P.sProxy = @sRequestor)
				JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
					ON HRS.nID = T.nHelperTimeSheetStatusId AND T.bIsSubmitted = 'true'
				JOIN TOLocation L WITH(NOLOCK)
					ON L.nID = E.nLocationID
				JOIN @location TL
					ON  E.nLocationID = TL.nID
			WHERE (CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END =  @sRequestor
					OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate))
					AND HRS.sStatus = @sRequestStatus AND T.bIsSubmitted = 'true'
		) T
		WHERE RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize)
	END
	ELSE
	BEGIN
		SET @nTotalCount = (SELECT COUNT(*)
							FROM TOTimeSheet T  WITH(NOLOCK) JOIN TOEmployee E WITH(NOLOCK)
									ON T.sRequestor = E.ProdcertName
								LEFT JOIN TOTimeSheetProxys P WITH(NOLOCK)
									ON (P.sUser = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END
										 AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate AND P.sProxy = @sRequestor)
								JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
									ON HRS.nID = T.nHelperTimeSheetStatusId AND T.bIsSubmitted = 'true'
								JOIN TOLocation L WITH(NOLOCK)
									ON L.nID = E.nLocationID
								JOIN @location TL
									ON  E.nLocationID = TL.nID
								JOIN @empIDs EID
									ON  E.sEmpID = EID.sAlias
							WHERE (CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END =  @sRequestor
								  OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate))
								  AND HRS.sStatus = @sRequestStatus
							)
		SELECT * FROM
			(SELECT	T.nID, sRequestor, weekStart, dateFilledIn, timeMonStart, timeMonEnd, timeTueStart, timeTueEnd, timeWedStart, timeWedEnd, timeThuStart, timeThuEnd
				, timeFriStart, timeFriEnd, timeSatStart, timeSatEnd, timeSunStart, timeSunEnd, sSubmittedBy, sComments, HRS.sStatus As status, nHoursSubmitted
				, bIsSubmitted, monBreaktime, tueBreakTime, wedBreakTime, thuBreakTime, friBreakTime, satBreakTime, sunBreakTime, nOTHours, nDoubleOThours
				, sApprovedBy, sApproverComments, dateApproved, T.sickDays
				, CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
				, CASE WHEN E.status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
				, CASE WHEN E.prevLocationID IS NULL THEN NULL WHEN E.prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
				, CASE WHEN E.prevStatus IS NULL THEN NULL WHEN E.prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
				, E.EffectiveDateOfChange
				, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers)
				THEN
					CASE WHEN DATEDIFF(wk, CONVERT(DATE, E.EffectiveDateOfChange - DATEPART(dw,  E.EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4 THEN 'false'
					ELSE 'true' END
				ELSE 'false' END AS isOldStatusCheckRequired
				, E1.ProdcertName AS sPayrollProcessedByAlias, E1.sEmpName AS sPayrollProcessedByName, T.datePayrollProcessed
				,E.sEmpName, E.sEmpID, L.sRegionName, ROW_NUMBER() OVER (ORDER BY CASE WHEN @sRequestStatus = 'approved' THEN T.dateApproved ELSE T.dateFilledIn END DESC, T.nID DESC) AS RowNum
			FROM TOTimeSheet T  WITH(NOLOCK) JOIN TOEmployee E WITH(NOLOCK)
					ON T.sRequestor = E.ProdcertName
				LEFT JOIN TOEmployee E1
					ON E1.ProdcertName = T.sPayrollProcessedBy
				LEFT JOIN TOTimeSheetProxys P WITH(NOLOCK)
					ON (P.sUser = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END
							AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate AND P.sProxy = @sRequestor)
				JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
					ON HRS.nID = T.nHelperTimeSheetStatusId AND T.bIsSubmitted = 'true'
				JOIN TOLocation L WITH(NOLOCK)
					ON L.nID = E.nLocationID
				JOIN @location TL
					ON  E.nLocationID = TL.nID
				JOIN @empIDs EID
					ON  E.sEmpID = EID.sAlias
			WHERE (CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END =  @sRequestor
					OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate))
					AND HRS.sStatus = @sRequestStatus AND T.bIsSubmitted = 'true'
		) T
		WHERE RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize)
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOGet_timesheets_for_approval')
	delete from GxQscripts where name = 'TOGet_timesheets_for_approval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timesheets_for_approval')
	delete from GXDBVersions where aliasname = 'TOGet_timesheets_for_approval'
GO

insert into GXDBVersions values(2, 'TOGet_timesheets_for_approval',  '00010001000200060000', 'TOGet_timesheets_for_approval', '00010001000200060000')
GO

