

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOGet_timesheet_for_employee.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOGet_timesheet_for_employee.sp,v $ $Id: TOGet_timesheet_for_employee.sp,v 1.1.2.6 2020/11/12 01:48:01 isebastian Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TOGet_timesheet_for_employee')
BEGIN
	print '>>> Drop Stored Procedure: TOGet_timesheet_for_employee <<<'
	drop procedure TOGet_timesheet_for_employee
END
IF EXISTS (select * from GxQscripts where name='TOGet_timesheet_for_employee')
	delete from GxQscripts where name = 'TOGet_timesheet_for_employee'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timesheet_for_employee')
	delete from GXDBVersions where aliasname = 'TOGet_timesheet_for_employee'
GO
print '... Creating Procedure: TOGet_timesheet_for_employee'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TOGet_timesheet_for_employee
  @sRequestor NVARCHAR(50),
  @dateStart DATETIME,
  @dateEnd DATETIME,
  @pageNo INT,
  @pageSize INT,
  @nID INT,
  @sRequestStatus NVARCHAR(50),
  @Locations dbo.UserAlias READONLY,
  @empIDs dbo.UserAlias READONLY,
  @nTotalCount INT  OUTPUT
AS
BEGIN
	DECLARE  @doubleOTWorkStates TABLE (nID INT)
	DECLARE @doubleOTStates NVARCHAR(512) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetOvertimeWorkState')
	INSERT INTO @doubleOTWorkStates SELECT Item FROM dbo.TOSplit(@doubleOTStates,',')
	DECLARE  @overtimeStatus TABLE (status NVARCHAR(256))
	DECLARE @status NVARCHAR(1024) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetOvertimeStatus')
	INSERT INTO @overtimeStatus SELECT Item FROM dbo.TOSplit(@status,',')
	DECLARE  @timesheetUsers TABLE (status NVARCHAR(256))
	DECLARE @users NVARCHAR(1024) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetUsers')
	INSERT INTO @timesheetUsers SELECT Item FROM dbo.TOSplit(@users,',')
	DECLARE @location TABLE (nID INT)
	DECLARE @bIsLocationSelected BIT = (SELECT CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM @Locations)
	DECLARE @bIsSomeEmpSelected BIT = (SELECT CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM @empIDs)
	IF @bIsLocationSelected = 'false'
	BEGIN
		INSERT INTO @location SELECT nID FROM TOLocation
	END
	ELSE
	BEGIN
		INSERT INTO @location SELECT sAlias FROM @Locations
	END
	IF @sRequestor IS NULL OR @sRequestor = ''
	BEGIN
		IF @bIsSomeEmpSelected = 'false'
		BEGIN
			SET @nTotalCount = (SELECT COUNT(*)
								FROM TOTimeSheet T JOIN TOHelperRequestStatus H
									ON T.nHelperTimeSheetStatusId = H.nID AND H.nID IN (1,2,3,4,5)
								LEFT JOIN TOEmployee E1
									ON E1.ProdcertName = T.sPayrollProcessedBy
								JOIN TOEmployee E
									ON E.ProdcertName = T.sRequestor
								JOIN TOLocation L WITH(NOLOCK)
									ON L.nID = E.nLocationID
								JOIN @location TL
									ON  L.nID = TL.nID
								WHERE ((@dateStart IS NULL AND @dateEnd IS NULL) OR weekStart BETWEEN @dateStart AND @dateEnd )
										AND (@nID IS NULL OR T.nID = @nID) AND (@sRequestStatus IS NULL OR ((@sRequestStatus = 'saved' AND H.sStatus = 'submitted' AND T.bIsSubmitted = 'false') OR
											(H.sStatus = @sRequestStatus AND  T.bIsSubmitted = 'true'))) )
			SELECT * FROM
			(SELECT E.sEmpID, E.sEmpName, E.nLocationID, T.nID, sRequestor, weekStart, dateFilledIn, timeMonStart, timeMonEnd, timeTueStart, timeTueEnd, timeWedStart, timeWedEnd, timeThuStart, timeThuEnd
				, timeFriStart, timeFriEnd, timeSatStart, timeSatEnd, timeSunStart, timeSunEnd, sSubmittedBy, sComments, T.sickDays
				, CASE WHEN H.nID = 1 AND bIsSubmitted = 'false' THEN 'Saved' ELSE H.sStatus END As status, nHoursSubmitted
				, bIsSubmitted, monBreaktime, tueBreakTime, wedBreakTime, thuBreakTime, friBreakTime, satBreakTime, sunBreakTime, nOTHours, nDoubleOThours
				, sApprovedBy, sApproverComments, dateApproved
				, CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
				, CASE WHEN E.status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
				, CASE WHEN E.prevLocationID IS NULL THEN CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END
					   WHEN E.prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
				, CASE WHEN E.prevStatus IS NULL THEN NULL WHEN E.prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
				, CASE WHEN E.status IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE 'false' END AS bIsAuthorized
				, E.EffectiveDateOfChange
				, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers)
				THEN
					CASE WHEN DATEDIFF(wk, CONVERT(DATE, E.EffectiveDateOfChange - DATEPART(dw,  E.EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4 THEN 'false'
					ELSE 'true' END
				ELSE 'false' END AS isOldStatusCheckRequired
				, E1.ProdcertName AS sPayrollProcessedByAlias, E1.sEmpName AS sPayrollProcessedByName, T.datePayrollProcessed
				,ROW_NUMBER() OVER (ORDER BY T.weekStart DESC, E.sEmpName, T.nID DESC) AS RowNum
			FROM TOTimeSheet T JOIN TOHelperRequestStatus H
				ON T.nHelperTimeSheetStatusId = H.nID AND H.nID IN (1,2,3,4,5)
			LEFT JOIN TOEmployee E1
				ON E1.ProdcertName = T.sPayrollProcessedBy
			JOIN TOEmployee E
				ON E.ProdcertName = T.sRequestor
			JOIN TOLocation L WITH(NOLOCK)
				ON L.nID = E.nLocationID
			JOIN @location TL
				ON  L.nID = TL.nID
			WHERE ((@dateStart IS NULL AND @dateEnd IS NULL) OR weekStart BETWEEN @dateStart AND @dateEnd )
				  AND (@nID IS NULL OR T.nID = @nID) AND
				  (@sRequestStatus IS NULL OR ((@sRequestStatus = 'saved' AND H.sStatus = 'submitted' AND T.bIsSubmitted = 'false') OR
											(H.sStatus = @sRequestStatus AND  T.bIsSubmitted = 'true') ))
			) T
			WHERE RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize)
		END
		ELSE
		BEGIN
			SET @nTotalCount = (SELECT COUNT(*)
								FROM TOTimeSheet T JOIN TOHelperRequestStatus H
									ON T.nHelperTimeSheetStatusId = H.nID AND H.nID IN (1,2,3,4,5)
								LEFT JOIN TOEmployee E1
									ON E1.ProdcertName = T.sPayrollProcessedBy
								JOIN TOEmployee E
									ON E.ProdcertName = T.sRequestor
								JOIN TOLocation L WITH(NOLOCK)
									ON L.nID = E.nLocationID
								JOIN @location TL
									ON  L.nID = TL.nID
								JOIN @empIDs EID
									ON  E.sEmpID = EID.sAlias
								WHERE  ((@dateStart IS NULL AND @dateEnd IS NULL) OR weekStart BETWEEN @dateStart AND @dateEnd )
									   AND (@nID IS NULL OR T.nID = @nID) AND
									   (@sRequestStatus IS NULL OR ((@sRequestStatus = 'saved' AND H.sStatus = 'submitted' AND T.bIsSubmitted = 'false') OR
											(H.sStatus = @sRequestStatus AND  T.bIsSubmitted = 'true') )))
			SELECT * FROM
			(SELECT E.sEmpID, E.sEmpName, E.nLocationID, T.nID, sRequestor, weekStart, dateFilledIn, timeMonStart, timeMonEnd, timeTueStart, timeTueEnd, timeWedStart, timeWedEnd, timeThuStart, timeThuEnd
				, timeFriStart, timeFriEnd, timeSatStart, timeSatEnd, timeSunStart, timeSunEnd, sSubmittedBy, sComments, T.sickDays
				, CASE WHEN H.nID = 1 AND bIsSubmitted = 'false' THEN 'Saved' ELSE H.sStatus END As status, nHoursSubmitted
				, bIsSubmitted, monBreaktime, tueBreakTime, wedBreakTime, thuBreakTime, friBreakTime, satBreakTime, sunBreakTime, nOTHours, nDoubleOThours
				, sApprovedBy, sApproverComments, dateApproved
				, CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
				, CASE WHEN E.status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
				, CASE WHEN E.prevLocationID IS NULL THEN CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END
					   WHEN E.prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
				, CASE WHEN E.prevStatus IS NULL THEN NULL WHEN E.prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
				, CASE WHEN E.status IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE 'false' END AS bIsAuthorized
				, E.EffectiveDateOfChange
				, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers)
				THEN
					CASE WHEN DATEDIFF(wk, CONVERT(DATE, E.EffectiveDateOfChange - DATEPART(dw,  E.EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4 THEN 'false'
					ELSE 'true' END
				ELSE 'false' END AS isOldStatusCheckRequired
				, E1.ProdcertName AS sPayrollProcessedByAlias, E1.sEmpName AS sPayrollProcessedByName, T.datePayrollProcessed
				,ROW_NUMBER() OVER (ORDER BY T.weekStart DESC, E.sEmpName, T.nID DESC) AS RowNum
			FROM TOTimeSheet T JOIN TOHelperRequestStatus H
				ON T.nHelperTimeSheetStatusId = H.nID
			LEFT JOIN TOEmployee E1
				ON E1.ProdcertName = T.sPayrollProcessedBy
			JOIN TOEmployee E
				ON E.ProdcertName = T.sRequestor
			JOIN TOLocation L WITH(NOLOCK)
				ON L.nID = E.nLocationID
			JOIN @location TL
				ON  L.nID = TL.nID
			JOIN @empIDs EID
				ON  E.sEmpID = EID.sAlias
			WHERE  ((@dateStart IS NULL AND @dateEnd IS NULL) OR weekStart BETWEEN @dateStart AND @dateEnd )
					AND (@nID IS NULL OR T.nID = @nID) AND
					(@sRequestStatus IS NULL OR ((@sRequestStatus = 'saved' AND H.sStatus = 'submitted' AND T.bIsSubmitted = 'false') OR
											(H.sStatus = @sRequestStatus AND  T.bIsSubmitted = 'true') ))) T
			WHERE RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize)
		END
	END
	ELSE
	BEGIN
		SET @nTotalCount = (SELECT COUNT(*)
							FROM TOTimeSheet T JOIN TOHelperRequestStatus H
								ON T.nHelperTimeSheetStatusId = H.nID AND H.nID IN (1,2,3,4,5)
							LEFT JOIN TOEmployee E1
								ON E1.ProdcertName = T.sPayrollProcessedBy
							JOIN TOEmployee E
								ON E.ProdcertName = T.sRequestor
							JOIN TOLocation L WITH(NOLOCK)
								ON L.nID = E.nLocationID
							JOIN @location TL
								ON  L.nID = TL.nID
							WHERE  ((@dateStart IS NULL AND @dateEnd IS NULL) OR weekStart BETWEEN @dateStart AND @dateEnd )
								   AND (@nID IS NULL OR T.nID = @nID) AND T.sRequestor = @sRequestor  AND
								   (@sRequestStatus IS NULL OR ((@sRequestStatus = 'saved' AND H.sStatus = 'submitted' AND T.bIsSubmitted = 'false') OR
										(H.sStatus = @sRequestStatus AND  T.bIsSubmitted = 'true') )))
		SELECT * FROM
		(SELECT E.sEmpID, E.sEmpName, E.nLocationID, T.nID, sRequestor, weekStart, dateFilledIn, timeMonStart, timeMonEnd, timeTueStart, timeTueEnd, timeWedStart, timeWedEnd, timeThuStart, timeThuEnd
			, timeFriStart, timeFriEnd, timeSatStart, timeSatEnd, timeSunStart, timeSunEnd, sSubmittedBy, sComments, T.sickDays
			, CASE WHEN H.nID = 1 AND bIsSubmitted = 'false' THEN 'Saved' ELSE H.sStatus END As status, nHoursSubmitted
			, bIsSubmitted, monBreaktime, tueBreakTime, wedBreakTime, thuBreakTime, friBreakTime, satBreakTime, sunBreakTime, nOTHours, nDoubleOThours
			, sApprovedBy, sApproverComments, dateApproved
			, CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
			, CASE WHEN E.status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
			, CASE WHEN E.prevLocationID IS NULL THEN CASE WHEN E.nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END
				   WHEN E.prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
			, CASE WHEN E.prevStatus IS NULL THEN NULL WHEN E.prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
			, CASE WHEN E.status IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE 'false' END AS bIsAuthorized
			, E.EffectiveDateOfChange
			, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers )
			THEN
				CASE WHEN DATEDIFF(wk, CONVERT(DATE, E.EffectiveDateOfChange - DATEPART(dw,  E.EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4 THEN 'false'
				ELSE 'true' END
			ELSE 'false' END AS isOldStatusCheckRequired
			, E1.ProdcertName AS sPayrollProcessedByAlias, E1.sEmpName AS sPayrollProcessedByName, T.datePayrollProcessed
			,ROW_NUMBER() OVER (ORDER BY T.weekStart DESC, E.sEmpName, T.nID DESC) AS RowNum
		FROM TOTimeSheet T JOIN TOHelperRequestStatus H
			ON T.nHelperTimeSheetStatusId = H.nID
		LEFT JOIN TOEmployee E1
			ON E1.ProdcertName = T.sPayrollProcessedBy
		JOIN TOEmployee E
			ON E.ProdcertName = T.sRequestor
		JOIN TOLocation L WITH(NOLOCK)
			ON L.nID = E.nLocationID
		JOIN @location TL
			ON  L.nID = TL.nID
		WHERE  ((@dateStart IS NULL AND @dateEnd IS NULL) OR weekStart BETWEEN @dateStart AND @dateEnd )
				AND (@nID IS NULL OR T.nID = @nID) AND T.sRequestor = @sRequestor AND
				(@sRequestStatus IS NULL OR ((@sRequestStatus = 'saved' AND H.sStatus = 'submitted' AND T.bIsSubmitted = 'false') OR
										(H.sStatus = @sRequestStatus AND  T.bIsSubmitted = 'true') ))) T
		WHERE RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize)
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOGet_timesheet_for_employee')
	delete from GxQscripts where name = 'TOGet_timesheet_for_employee'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timesheet_for_employee')
	delete from GXDBVersions where aliasname = 'TOGet_timesheet_for_employee'
GO

insert into GXDBVersions values(2, 'TOGet_timesheet_for_employee',  '00010001000200060000', 'TOGet_timesheet_for_employee', '00010001000200060000')
GO

