

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOGet_timeoffs_for_email.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOGet_timeoffs_for_email.sp,v $ $Id: TOGet_timeoffs_for_email.sp,v 1.1.2.6 2019/10/27 22:02:12 sgolla Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
IF NOT EXISTS (SELECT * FROM systypes where name = 'Identifiers')
BEGIN
CREATE TYPE Identifiers AS TABLE(
    nID int NOT NULL
)
END;;
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TOGet_timeoffs_for_email')
BEGIN
	print '>>> Drop Stored Procedure: TOGet_timeoffs_for_email <<<'
	drop procedure TOGet_timeoffs_for_email
END
IF EXISTS (select * from GxQscripts where name='TOGet_timeoffs_for_email')
	delete from GxQscripts where name = 'TOGet_timeoffs_for_email'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timeoffs_for_email')
	delete from GXDBVersions where aliasname = 'TOGet_timeoffs_for_email'
GO
print '... Creating Procedure: TOGet_timeoffs_for_email'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOGet_timeoffs_for_email
  @IDs Identifiers READONLY,
  @nReqCount INT OUTPUT
AS
BEGIN
	DECLARE  @Requestors TABLE (sRequestor NVARCHAR(50), nID INT)
	INSERT INTO @Requestors SELECT sRequestor, R.nID FROM TORequests R JOIN @IDs I ON R.nID = I.nID
	SELECT R.sRequestor, E.sEmpName,E.sEmail AS sRequestorEmail, RT.sRequestType, HRS.sStatus, R.dateStart, dateEnd, R.bIsHalfDay, R.bHalfDayType, R.bIsEscalated,
	COALESCE(E1.sEmpName, R.sEscalationApprover) AS sEscalationApprover, COALESCE(E1.sEmail, R.sEscalationApprover) AS sEscalationApproverEmail, E3.sEmail AS sManagerEmail,
	E2.sEmpName AS sSubmittedBy, E2.sEmail AS sSubmitterEmail , R.nWorkDays, R.sComments, STUFF((SELECT H.sName + ',' FROM TOSplit(sOPtHolidays, ',') T JOIN TOHolidays H
		ON T.Item BETWEEN H.dStartDate AND H.dEndDate AND H.nIsOptional = 1 AND H.nLocationID = E.nLocationID
	FOR XML PATH('')), 1, 0, '' ) AS sOptHolidays, sApprovedBy, E4.sEmail AS sApproverEmail,  E4.sEmpName AS sApproverName, sApproverComments, RT.bIsOptionalType, E3.sEmpName AS sManagerName
	, E5.sEmail AS sSecondaryManagerEmail, E5.sEmpName AS sSecondaryManagerName, E6.sEmail AS sManagerProxyEmail, E6.sEmpName AS sManagerProxyName, R.sOutlookMeetingID, L.sTimeZone, RT.nID AS nRequestTypeID
	FROM TORequests R JOIN @IDs I
		ON I.nID = R.nID
	JOIN TORequestType RT
		ON R.nRequestTypeID = RT.nID
	JOIN TOHelperRequestStatus	HRS
		ON HRS.nID = R.nHelperRequestStatusID
	JOIN TOEmployee E
		ON E.ProdcertName = R.sRequestor
	JOIN TOLocation L
		ON L.nID = E.nLocationID
	LEFT JOIN TOEmployee E1
		ON 	E1.ProdcertName = R.sEscalationApprover
	LEFT JOIN TOEmployee E2
		ON E2.ProdcertName = R.sSubmittedBy
	LEFT JOIN TOEmployee E3
		ON E3.ProdcertName = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END --dbo.TOGet_user_name(E.Manager, ',')
	LEFT JOIN TOEmployee E4
		ON E4.ProdcertName = sApprovedBy
	LEFT JOIN TOEmployee E5
		ON E5.ProdcertName = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN dbo.TOGet_user_name(E.Manager, ',') ELSE NULL END
	LEFT JOIN TOProxys P
		ON P.sUser = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END
			AND P.bIsDeleted = 0 AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate
	LEFT JOIN TOEmployee E6
		ON P.sProxy = E6.ProdcertName
	SELECT @nReqCount = COUNT(*) FROM TORequests R JOIN @IDs T ON T.nID = R.nID
		SELECT sRequestor, sEmpName, sRequestType, SUM(nWorkDays) As nWorkDays, sStatus, Year
	FROM
	(SELECT TR.nID, TR.sRequestor, E.sEmpName, RT.sRequestType,
	CASE WHEN YEAR(dateStart) = YEAR(GETDATE()) THEN
		dbo.TOGet_total_working_days(dateStart, CONVERT(DATE, CONVERT(VARCHAR,YEAR(GETDATE())) + '/12/31'),
		(SELECT COUNT(CASE WHEN CONVERT(DATE,Item) <= CONVERT(DATE, CONVERT(VARCHAR,YEAR(GETDATE())) + '/12/31') THEN 1 ELSE NULL END) FROM TOSplit(sOptHolidays, ',')), E.nLocationID)
	WHEN YEAR(dateStart) = YEAR(DATEADD(YEAR, -1, GETDATE())) THEN
		dbo.TOGet_total_working_days(dateStart, CONVERT(DATE, CONVERT(VARCHAR,YEAR(DATEADD(YEAR, -1, GETDATE()))) + '/12/31'),
		(SELECT COUNT(CASE WHEN CONVERT(DATE,Item) <= CONVERT(DATE, CONVERT(VARCHAR,YEAR(DATEADD(YEAR, -1, GETDATE()))) + '/12/31') THEN 1 ELSE NULL END) FROM TOSplit(sOptHolidays, ',')), E.nLocationID)
	END AS nWorkDays,
	HRS.sStatus, YEAR(dateStart) As Year
	FROM TORequests TR JOIN @Requestors R
		ON TR.sRequestor = R.sRequestor AND R.nID != TR.nID
	JOIN TORequestType RT
		ON TR.nRequestTypeID = RT.nID
	JOIN TOHelperRequestStatus	HRS
		ON HRS.nID = TR.nHelperRequestStatusID
	JOIN TOEmployee E
		ON E.ProdcertName = TR.sRequestor
	WHERE TR.nHelperRequestStatusID IN (1,2) AND YEAR(dateStart) != YEAR(dateEnd) AND YEAR(dateStart) IN (YEAR(GETDATE()), YEAR(DATEADD(YEAR, -1, GETDATE())))
		UNION
	SELECT TR.nID, TR.sRequestor, E.sEmpName, RT.sRequestType,
			CASE WHEN YEAR(dateEnd) = YEAR(GETDATE()) THEN
				dbo.TOGet_total_working_days(CONVERT(DATE, CONVERT(VARCHAR,YEAR(GETDATE())) + '/01/01'), dateEnd,
				(SELECT COUNT(CASE WHEN CONVERT(DATE,Item) >= CONVERT(DATE, CONVERT(VARCHAR,YEAR(GETDATE())) + '/01/01') THEN 1 ELSE NULL END) FROM TOSplit(sOptHolidays, ',')), E.nLocationID)
			WHEN YEAR(dateEnd) = YEAR(DATEADD(YEAR, -1, GETDATE())) THEN
				dbo.TOGet_total_working_days(CONVERT(DATE, CONVERT(VARCHAR,YEAR(DATEADD(YEAR, -1, GETDATE()))) + '/01/01'), dateEnd,
				(SELECT COUNT(CASE WHEN CONVERT(DATE,Item) >= CONVERT(DATE, CONVERT(VARCHAR,YEAR(DATEADD(YEAR, -1, GETDATE()))) + '/01/01') THEN 1 ELSE NULL END) FROM TOSplit(sOptHolidays, ',')), E.nLocationID)
			END AS nWorkDays,
			HRS.sStatus, YEAR(dateEnd) As Year
	FROM TORequests TR JOIN @Requestors R
		ON TR.sRequestor = R.sRequestor AND R.nID != TR.nID
	JOIN TORequestType RT
		ON TR.nRequestTypeID = RT.nID
	JOIN TOHelperRequestStatus	HRS
		ON HRS.nID = TR.nHelperRequestStatusID
	JOIN TOEmployee E
		ON E.ProdcertName = TR.sRequestor
	WHERE TR.nHelperRequestStatusID IN (1,2) AND YEAR(dateStart) != YEAR(dateEnd) AND YEAR(dateEnd) IN (YEAR(GETDATE()), YEAR(DATEADD(YEAR, -1, GETDATE())))
		UNION
	SELECT TR.nID, TR.sRequestor, E.sEmpName, RT.sRequestType, TR.nWorkDays AS nWorkDays, HRS.sStatus, YEAR(dateStart) As Year
	FROM TORequests TR JOIN @Requestors R
		ON TR.sRequestor = R.sRequestor AND R.nID != TR.nID
	JOIN TORequestType RT
		ON TR.nRequestTypeID = RT.nID
	JOIN TOHelperRequestStatus	HRS
		ON HRS.nID = TR.nHelperRequestStatusID
	JOIN TOEmployee E
		ON E.ProdcertName = TR.sRequestor
	WHERE TR.nHelperRequestStatusID IN (1,2)  AND YEAR(dateStart) = YEAR(dateEnd) AND YEAR(dateStart) IN (YEAR(GETDATE()), YEAR(DATEADD(YEAR, -1, GETDATE())))
	) T
	GROUP BY sRequestor, sEmpName, sRequestType, sStatus, YEAR
	ORDER BY sEmpName, YEAR DESC, sRequestType, sStatus
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOGet_timeoffs_for_email')
	delete from GxQscripts where name = 'TOGet_timeoffs_for_email'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timeoffs_for_email')
	delete from GXDBVersions where aliasname = 'TOGet_timeoffs_for_email'
GO

insert into GXDBVersions values(2, 'TOGet_timeoffs_for_email',  '00010001000200060000', 'TOGet_timeoffs_for_email', '00010001000200060000')
GO

