

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOGet_timeoffs_for_approval.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOGet_timeoffs_for_approval.sp,v $ $Id: TOGet_timeoffs_for_approval.sp,v 1.2.2.7 2020/02/28 15:45:17 isebastian Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TOGet_timeoffs_for_approval')
BEGIN
	print '>>> Drop Stored Procedure: TOGet_timeoffs_for_approval <<<'
	drop procedure TOGet_timeoffs_for_approval
END
IF EXISTS (select * from GxQscripts where name='TOGet_timeoffs_for_approval')
	delete from GxQscripts where name = 'TOGet_timeoffs_for_approval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timeoffs_for_approval')
	delete from GXDBVersions where aliasname = 'TOGet_timeoffs_for_approval'
GO
print '... Creating Procedure: TOGet_timeoffs_for_approval'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOGet_timeoffs_for_approval
  @sRequestor NVARCHAR(50),
  @sRequestStatus NVARCHAR(50),
  @Locations NVARCHAR(255),
  @pageNo INT,
  @pageSize INT,
  @nTotalCount INT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	IF @Locations IS NULL
	BEGIN
		SET @nTotalCount = (SELECT COUNT(*)
			FROM TOProxys P WITH(NOLOCK) JOIN TOEmployee E1  WITH(NOLOCK)
				ON (P.sUser = CASE WHEN CHARINDEX(',', E1.Manager, 0) > 0 THEN SUBSTRING(E1.Manager, 0 , CHARINDEX(',', E1.Manager, 0)) ELSE E1.Manager END
					AND P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			RIGHT JOIN TORequests R  WITH(NOLOCK)
				ON R.sRequestor = E1.ProdcertName -- AND R.sEscalationApprover = E1.Manager
			LEFT JOIN TOProxys P1 WITH(NOLOCK)
				ON R.sEscalationApprover = P1.sUser AND R.bIsEscalated = 'true'
			JOIN TOEmployee E2 WITH(NOLOCK)
				ON E2.ProdcertName = R.sRequestor
			LEFT JOIN TOEmployee E3 WITH(NOLOCK)
				ON E3.ProdcertName = R.sEscalationApprover AND R.bIsEscalated = 'true'
			JOIN TORequestType RT WITH(NOLOCK)
				ON RT.nID = R.nRequestTypeID
			JOIN TODepartment D WITH(NOLOCK)
				ON D.nID = E2.nDeptID
			JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
				ON HRS.nID = R.nHelperRequestStatusID
			JOIN TOLocation L WITH(NOLOCK)
				ON L.nID = E2.nLocationID
		WHERE (CASE WHEN CHARINDEX(',', E2.Manager, 0) > 0 THEN SUBSTRING(E2.Manager, 0 , CHARINDEX(',', E2.Manager, 0)) ELSE E2.Manager END =  @sRequestor
			  OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			  OR (P1.sProxy = @sRequestor AND P1.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P1.dValidFrom AND P1.dExpiryDate)
			  OR (R.sEscalationApprover = @sRequestor AND R.bIsEscalated = 'true'))
			  AND HRS.sStatus = @sRequestStatus
		)
		SELECT * FROM
		(SELECT R.nID As nID,dateRequested,sRequestor,RT.sRequestType AS sRequestType,dateStart,dateEnd,nWorkDays,sComments,HRS.sStatus As sStatus,sApprovedBy,dateApproved,
		sApproverComments,sOptHolidays, bIsEscalated, E3.sEmpName AS sEscalationApprover,  sEscalationApprover as sEscalationApproverAlias,
		P1.sProxy AS sEscalationProxy,
		sSubmittedBy,bIsHalfDay,bHalfDayType, E2.sEmpName, sRegionName, ROW_NUMBER() OVER (ORDER BY CASE WHEN @sRequestStatus = 'approved' THEN R.dateApproved ELSE R.dateRequested END DESC, R.nID DESC) AS RowNum
			FROM TOProxys P WITH(NOLOCK) JOIN TOEmployee E1  WITH(NOLOCK)
				ON (P.sUser = CASE WHEN CHARINDEX(',', E1.Manager, 0) > 0 THEN SUBSTRING(E1.Manager, 0 , CHARINDEX(',', E1.Manager, 0)) ELSE E1.Manager END
					 AND P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			RIGHT JOIN TORequests R  WITH(NOLOCK)
				ON R.sRequestor = E1.ProdcertName--  AND R.sEscalationApprover = E1.Manager
			LEFT JOIN TOProxys P1 WITH(NOLOCK)
				ON R.sEscalationApprover = P1.sUser	AND R.bIsEscalated = 'true'
			JOIN TOEmployee E2 WITH(NOLOCK)
				ON E2.ProdcertName = R.sRequestor
			LEFT JOIN TOEmployee E3 WITH(NOLOCK)
				ON E3.ProdcertName = R.sEscalationApprover	AND R.bIsEscalated = 'true'
			JOIN TORequestType RT WITH(NOLOCK)
				ON RT.nID = R.nRequestTypeID
			JOIN TODepartment D WITH(NOLOCK)
				ON D.nID = E2.nDeptID
			JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
				ON HRS.nID = R.nHelperRequestStatusID
			JOIN TOLocation L WITH(NOLOCK)
				ON L.nID = E2.nLocationID
		WHERE (CASE WHEN CHARINDEX(',', E2.Manager, 0) > 0 THEN SUBSTRING(E2.Manager, 0 , CHARINDEX(',', E2.Manager, 0)) ELSE E2.Manager END =  @sRequestor
			  OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			  OR (P1.sProxy = @sRequestor AND P1.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P1.dValidFrom AND P1.dExpiryDate)
			  OR (R.sEscalationApprover = @sRequestor AND R.bIsEscalated = 'true'))
			  AND HRS.sStatus = @sRequestStatus) T
		WHERE RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize)
	END
	ELSE
	BEGIN
		SET @nTotalCount = (SELECT COUNT(*)
			FROM TOProxys P WITH(NOLOCK) JOIN TOEmployee E1  WITH(NOLOCK)
				ON (P.sUser =  CASE WHEN CHARINDEX(',', E1.Manager, 0) > 0 THEN SUBSTRING(E1.Manager, 0 , CHARINDEX(',', E1.Manager, 0)) ELSE E1.Manager END
					 AND P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			RIGHT JOIN TORequests R  WITH(NOLOCK)
				ON R.sRequestor = E1.ProdcertName--  AND R.sEscalationApprover = E1.Manager
			LEFT JOIN TOProxys P1 WITH(NOLOCK)
				ON R.sEscalationApprover = P1.sUser	AND R.bIsEscalated = 'true'
			JOIN TOEmployee E2 WITH(NOLOCK)
				ON E2.ProdcertName = R.sRequestor
			LEFT JOIN TOEmployee E3 WITH(NOLOCK)
				ON E3.ProdcertName = R.sEscalationApprover AND R.bIsEscalated = 'true'
			JOIN TORequestType RT WITH(NOLOCK)
				ON RT.nID = R.nRequestTypeID
			JOIN TODepartment D WITH(NOLOCK)
				ON D.nID = E2.nDeptID
			JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
				ON HRS.nID = R.nHelperRequestStatusID
			JOIN TOLocation L WITH(NOLOCK)
				ON L.nID = E2.nLocationID
			JOIN dbo.TOSplit(@Locations,',') T
				 ON  L.nID = T.Item
		WHERE (CASE WHEN CHARINDEX(',', E2.Manager, 0) > 0 THEN SUBSTRING(E2.Manager, 0 , CHARINDEX(',', E2.Manager, 0)) ELSE E2.Manager END =  @sRequestor
			  OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			  OR (P1.sProxy = @sRequestor AND P1.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P1.dValidFrom AND P1.dExpiryDate)
			  OR (R.sEscalationApprover = @sRequestor AND R.bIsEscalated = 'true'))
			  AND HRS.sStatus = @sRequestStatus
		)
		SELECT * FROM
		(SELECT R.nID As nID,dateRequested,sRequestor,RT.sRequestType AS sRequestType,dateStart,dateEnd,nWorkDays,sComments,HRS.sStatus As sStatus,sApprovedBy,dateApproved,
		sApproverComments,sOptHolidays, bIsEscalated, E3.sEmpName AS sEscalationApprover,  sEscalationApprover as sEscalationApproverAlias,
		P1.sProxy AS sEscalationProxy,
		sSubmittedBy,bIsHalfDay,bHalfDayType, E2.sEmpName, sRegionName, ROW_NUMBER() OVER (ORDER BY CASE WHEN @sRequestStatus = 'approved' THEN R.dateApproved ELSE R.dateRequested END DESC, R.nID DESC)  AS RowNum
			FROM TOProxys P WITH(NOLOCK) JOIN TOEmployee E1  WITH(NOLOCK)
				ON (P.sUser =  CASE WHEN CHARINDEX(',', E1.Manager, 0) > 0 THEN SUBSTRING(E1.Manager, 0 , CHARINDEX(',', E1.Manager, 0)) ELSE E1.Manager END
					 AND P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			RIGHT JOIN TORequests R  WITH(NOLOCK)
				ON R.sRequestor = E1.ProdcertName--  AND R.sEscalationApprover = E1.Manager
			LEFT JOIN TOProxys P1 WITH(NOLOCK)
				ON R.sEscalationApprover = P1.sUser	AND R.bIsEscalated = 'true'
			JOIN TOEmployee E2 WITH(NOLOCK)
				ON E2.ProdcertName = R.sRequestor
			LEFT JOIN TOEmployee E3 WITH(NOLOCK)
				ON E3.ProdcertName = R.sEscalationApprover	AND R.bIsEscalated = 'true'
			JOIN TORequestType RT WITH(NOLOCK)
				ON RT.nID = R.nRequestTypeID
			JOIN TODepartment D WITH(NOLOCK)
				ON D.nID = E2.nDeptID
			JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
				ON HRS.nID = R.nHelperRequestStatusID
			JOIN TOLocation L WITH(NOLOCK)
				ON L.nID = E2.nLocationID
			JOIN dbo.TOSplit(@Locations,',') T
				 ON  L.nID = T.Item
		WHERE (CASE WHEN CHARINDEX(',', E2.Manager, 0) > 0 THEN SUBSTRING(E2.Manager, 0 , CHARINDEX(',', E2.Manager, 0)) ELSE E2.Manager END =  @sRequestor
			  OR (P.sProxy = @sRequestor AND P.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate)
			  OR (P1.sProxy = @sRequestor AND P1.bIsDeleted = 0  AND CONVERT(DATE, GETDATE()) BETWEEN P1.dValidFrom AND P1.dExpiryDate)
			  OR (R.sEscalationApprover = @sRequestor AND R.bIsEscalated = 'true'))
			  AND HRS.sStatus = @sRequestStatus) T
		WHERE RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize)
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOGet_timeoffs_for_approval')
	delete from GxQscripts where name = 'TOGet_timeoffs_for_approval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timeoffs_for_approval')
	delete from GXDBVersions where aliasname = 'TOGet_timeoffs_for_approval'
GO

insert into GXDBVersions values(2, 'TOGet_timeoffs_for_approval',  '00010002000200070000', 'TOGet_timeoffs_for_approval', '00010002000200070000')
GO

