

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOGet_timeoff_report.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOGet_timeoff_report.sp,v $ $Id: TOGet_timeoff_report.sp,v 1.1.2.2 2018/03/27 08:57:25 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOGet_timeoff_report <<<'

IF EXISTS (select * from sysobjects where name='TOGet_timeoff_report')
	drop procedure TOGet_timeoff_report
IF EXISTS (select * from GxQscripts where name='TOGet_timeoff_report')
	delete from GxQscripts where name = 'TOGet_timeoff_report'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timeoff_report')
	delete from GXDBVersions where aliasname = 'TOGet_timeoff_report'
GO
print '... Creating Procedure: TOGet_timeoff_report'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOGet_timeoff_report
  @manager NVARCHAR(50),
  @sRequestor NVARCHAR(50),
  @nDeptID INT,
  @nLocationID INT,
  @nRequestTypeID INT,
  @dateStart DATE,
  @dateEnd DATE,
  @pageNo INT,
  @pageSize INT,
  @nTotalCount INT OUTPUT
AS
BEGIN
	IF @dateStart IS NULL
	BEGIN
		SET @dateStart = CONVERT(DATE, DATEADD(DAY, -DATEPART(DAYOFYEAR, GETDATE()) + 1, GETDATE()))
	END
	IF @dateEnd IS NULL
	BEGIN
		SET @dateEnd = CONVERT(DATE, DATEADD(YEAR, 1, DATEADD(DAY, -DATEPART(DAYOFYEAR, GETDATE()), GETDATE())))
	END
	SET @nTotalCount = (SELECT COUNT(R.nID)
				FROM TORequests R  WITH(NOLOCK) JOIN TOEmployee E1
					ON R.sRequestor = E1.ProdcertName AND E1.bIsDeleted = 0
				JOIN TOEmployee E2 WITH(NOLOCK)
					ON E2.ProdcertName = CASE WHEN CHARINDEX(',', E1.Manager, 0) > 0 THEN SUBSTRING(E1.Manager, 0 , CHARINDEX(',', E1.Manager, 0)) ELSE E1.Manager END
				JOIN TORequestType RT WITH(NOLOCK)
					ON RT.nID = R.nRequestTypeID
				JOIN TODepartment D WITH(NOLOCK)
					ON D.nID = E1.nDeptID
				JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
					ON HRS.nID = R.nHelperRequestStatusID AND HRS.nID IN (1,2)
				JOIN TOLocation L WITH(NOLOCK)
					ON L.nID = E1.nLocationID
				WHERE ((@manager IS NOT NULL AND E2.ProdcertName = @manager) OR (@manager IS NULL))
					AND ((@sRequestor IS NOT NULL AND E1.ProdcertName = @sRequestor) OR (@sRequestor IS NULL))
					AND ((@nDeptID IS NOT NULL AND D.nID = @nDeptID) OR (@nDeptID IS NULL))
					AND ((@nLocationID IS NOT NULL AND L.nID = @nLocationID) OR (@nLocationID IS NULL))
					AND ((@nRequestTypeID IS NOT NULL AND RT.nID = @nRequestTypeID) OR (@nRequestTypeID IS NULL))
					AND ((R.dateStart >= @dateStart AND R.dateEnd <= @dateEnd)
						 OR (R.dateStart <= @dateStart AND R.dateEnd >= @dateEnd)
						 OR (R.dateStart BETWEEN @dateStart AND @dateEnd AND R.dateEnd >= @dateEnd)
						 OR (R.dateStart <= @dateStart AND R.dateEnd BETWEEN @dateStart AND @dateEnd) )
				)
	SELECT * FROM (
	SELECT R.nID As nID,dateRequested,sRequestor,RT.nID AS nRequestTypeID, RT.sRequestType AS sRequestType,dateStart,dateEnd,nWorkDays,sComments,
		HRS.sStatus As sStatus,sApprovedBy,dateApproved,sApproverComments,sOptHolidays, R.sEscalationApprover,
		sSubmittedBy,bIsHalfDay,bHalfDayType, E1.sEmpName AS sEmpName, L.sRegionName,  bIsEscalated,
		E2.ProdcertName AS ManagerAlias, E2.sEmpName AS sManagerName, E2.ProdcertName AS sManagerAlias, E2.sEmail AS sManagerEmail,
		ROW_NUMBER() OVER (ORDER BY R.nID) AS RowNum
	FROM TORequests R  WITH(NOLOCK) JOIN TOEmployee E1
		ON R.sRequestor = E1.ProdcertName AND E1.bIsDeleted = 0
	JOIN TOEmployee E2 WITH(NOLOCK)
		ON E2.ProdcertName = CASE WHEN CHARINDEX(',', E1.Manager, 0) > 0 THEN SUBSTRING(E1.Manager, 0 , CHARINDEX(',', E1.Manager, 0)) ELSE E1.Manager END
	JOIN TORequestType RT WITH(NOLOCK)
		ON RT.nID = R.nRequestTypeID
	JOIN TODepartment D WITH(NOLOCK)
		ON D.nID = E1.nDeptID
	JOIN TOHelperRequestStatus HRS WITH(NOLOCK)
		ON HRS.nID = R.nHelperRequestStatusID AND HRS.nID IN (1,2)
	JOIN TOLocation L WITH(NOLOCK)
		ON L.nID = E1.nLocationID
	WHERE ((@manager IS NOT NULL AND E2.ProdcertName = @manager) OR (@manager IS NULL))
		AND ((@sRequestor IS NOT NULL AND E1.ProdcertName = @sRequestor) OR (@sRequestor IS NULL))
		AND ((@nDeptID IS NOT NULL AND D.nID = @nDeptID) OR (@nDeptID IS NULL))
		AND ((@nLocationID IS NOT NULL AND L.nID = @nLocationID) OR (@nLocationID IS NULL))
		AND ((@nRequestTypeID IS NOT NULL AND RT.nID = @nRequestTypeID) OR (@nRequestTypeID IS NULL))
		AND ((R.dateStart >= @dateStart AND R.dateEnd <= @dateEnd)
			 OR (R.dateStart <= @dateStart AND R.dateEnd >= @dateEnd)
			 OR (R.dateStart BETWEEN @dateStart AND @dateEnd AND R.dateEnd >= @dateEnd)
			 OR (R.dateStart <= @dateStart AND R.dateEnd BETWEEN @dateStart AND @dateEnd) )
	) T
		WHERE ((@pageNo IS NOT NULL AND @pageSize IS NOT NULL) AND RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize) )
		ORDER BY sRequestor, dateStart, dateEnd
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOGet_timeoff_report')
	delete from GxQscripts where name = 'TOGet_timeoff_report'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_timeoff_report')
	delete from GXDBVersions where aliasname = 'TOGet_timeoff_report'
GO

insert into GXDBVersions values(2, 'TOGet_timeoff_report',  '00010001000200020000', 'TOGet_timeoff_report', '00010001000200020000')
GO

