

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOGet_leave_entitlement_policy_details.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOGet_leave_entitlement_policy_details.sp,v $ $Id: TOGet_leave_entitlement_policy_details.sp,v 1.2.2.1 2018/03/27 09:02:57 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOGet_leave_entitlement_policy_details <<<'

IF EXISTS (select * from sysobjects where name='TOGet_leave_entitlement_policy_details')
	drop procedure TOGet_leave_entitlement_policy_details
IF EXISTS (select * from GxQscripts where name='TOGet_leave_entitlement_policy_details')
	delete from GxQscripts where name = 'TOGet_leave_entitlement_policy_details'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_leave_entitlement_policy_details')
	delete from GXDBVersions where aliasname = 'TOGet_leave_entitlement_policy_details'
GO
print '... Creating Procedure: TOGet_leave_entitlement_policy_details'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOGet_leave_entitlement_policy_details
  @sRequestor NVARCHAR(50),
  @nRequestType INT,
  @dateStart DATE,
  @dateEnd DATE,
  @LEPStartDate DATE OUTPUT
,
  @LEPEndDate DATE OUTPUT
,
  @nMaxAllowed DECIMAL(5,2) OUTPUT
,
  @nMaxContAllowed DECIMAL(5,2) OUTPUT
,
  @nMaxCountAllowed DECIMAL(5,2) OUTPUT
,
  @bIsLEPFound BIT OUTPUT
AS
BEGIN
	DECLARE @dRenewedOn DATE
	DECLARE @dLastDate DATE
	DECLARE @nLEPID INT = -1
	SELECT @nMaxAllowed = nMaxAllowed, @nMaxContAllowed = nMaxContAllowed, @nMaxCountAllowed = nMaxCountAllowed, @LEPStartDate = dRenewedOn,
		   @LEPEndDate = dLastDate, @nLEPID = nLEPID
	FROM
	(SELECT nMaxAllowed, nMaxContAllowed, nMaxCountAllowed, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn)) AS dLastDate,
	LEP.nID  AS nLEPID
	FROM TOEmployeeToPolicyMapping EMP JOIN TOLeaveEntitlementPolicy LEP
		ON LEP.nID = EMP.nLeaveEntitlementPolicyID
	WHERE EMP.nRequestType = @nRequestType AND EMP.sEmpAlias = @sRequestor
		  AND @dateStart BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
		  AND @dateEnd BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
	UNION
	SELECT  nMaxAllowed, nMaxContAllowed, nMaxCountAllowed, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn)) AS dLastDate,
	EMPH.nID AS nLEPID
	FROM TOEmployeeToPolicyMappingHistory EMPH
	WHERE EMPH.sEmpAlias = @sRequestor AND EMPH.nRequestType = @nRequestType
		  AND @dateStart BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
		  AND @dateEnd BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
		  AND bIsHistory = 'false') T
	IF NOT (@nLEPID > 0)
	BEGIN
		SELECT @nMaxAllowed = nMaxAllowed, @nMaxContAllowed = nMaxContAllowed, @nMaxCountAllowed = nMaxCountAllowed, @LEPStartDate = dRenewedOn,
			   @LEPEndDate = dLastDate, @nLEPID = nLEPID
		FROM
		(
		SELECT nMaxAllowed, nMaxContAllowed, nMaxCountAllowed, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn)) AS dLastDate,
		LEP.nID  AS nLEPID
		FROM TORequestType RT JOIN TOLeaveEntitlementPolicy LEP
			ON LEP.nID = RT.nEntitlementPolicyID
		WHERE RT.nID = @nRequestType
			  AND @dateStart BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
			  AND @dateEnd BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
		UNION
		SELECT  nMaxAllowed, nMaxContAllowed, nMaxCountAllowed, dRenewedOn, DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn)) AS dLastDate,
		LEPH.nID AS nLEPID
		FROM TOLeaveEntitlementPolicyHistory LEPH
		WHERE LEPH.nRequestTypeID = @nRequestType
			AND @dateStart BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
			AND @dateEnd BETWEEN dRenewedOn AND DATEADD(DAY, -1, DATEADD(MONTH,nDuration, dRenewedOn))
			AND bIsHistory = 'false') T
	END
	IF @nLEPID > 0
		SET @bIsLEPFound = 'true'
	ELSE
		SET @bIsLEPFound = 'false'
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOGet_leave_entitlement_policy_details')
	delete from GxQscripts where name = 'TOGet_leave_entitlement_policy_details'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_leave_entitlement_policy_details')
	delete from GXDBVersions where aliasname = 'TOGet_leave_entitlement_policy_details'
GO

insert into GXDBVersions values(2, 'TOGet_leave_entitlement_policy_details',  '00010002000200010000', 'TOGet_leave_entitlement_policy_details', '00010002000200010000')
GO

