

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOGet_Employee_For_timesheet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOGet_Employee_For_timesheet.sp,v $ $Id: TOGet_Employee_For_timesheet.sp,v 1.1.2.3 2018/07/02 02:49:43 isebastian Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOGet_Employee_For_timesheet <<<'

IF EXISTS (select * from sysobjects where name='TOGet_Employee_For_timesheet')
	drop procedure TOGet_Employee_For_timesheet
IF EXISTS (select * from GxQscripts where name='TOGet_Employee_For_timesheet')
	delete from GxQscripts where name = 'TOGet_Employee_For_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_Employee_For_timesheet')
	delete from GXDBVersions where aliasname = 'TOGet_Employee_For_timesheet'
GO
print '... Creating Procedure: TOGet_Employee_For_timesheet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOGet_Employee_For_timesheet
  @sRequestor NVARCHAR(50),	 	
  @bIsAllEmployee BIT,
  @bIsDirectEmpOnly BIT
AS
BEGIN
	DECLARE  @doubleOTWorkStates TABLE (nID INT)
	DECLARE @doubleOTStates NVARCHAR(512) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetOvertimeWorkState')
	INSERT INTO @doubleOTWorkStates SELECT Item FROM dbo.TOSplit(@doubleOTStates,',')
	DECLARE  @overtimeStatus TABLE (status NVARCHAR(256))
	DECLARE @status NVARCHAR(1024) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetOvertimeStatus')
	INSERT INTO @overtimeStatus SELECT Item FROM dbo.TOSplit(@status,',')
	DECLARE  @timesheetUsers TABLE (status NVARCHAR(256))
	DECLARE @users NVARCHAR(1024) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetUsers')
	INSERT INTO @timesheetUsers SELECT Item FROM dbo.TOSplit(@users,',')
	DECLARE @bTimesheetSubmittedBefore BIT =  (SELECT CASE WHEN COUNT(nID) > 0 THEN 'true' ELSE 'false' END FROM TOTimeSheet WHERE sRequestor = @sRequestor AND nHelperTimeSheetStatusId IN (1,2,5))
	DECLARE @UserAccess NVARCHAR(50)
	SET @UserAccess = ( SELECT CASE WHEN COUNT(E.nID) > 0 THEN 'admin' ELSE NULL END
						FROM TOEmployee E LEFT JOIN UMUsers UM WITH(NOLOCK)
							ON E.sEmail = UM.email
						LEFT JOIN UMUserGroup USG WITH(NOLOCK)
							ON  UM.id = USG.userId
						LEFT JOIN UMGroups UG
							ON USG.groupId = UG.id
						JOIN TOUserAccess U
							ON (U.UserName = E.ProdcertName OR U.UserName = UG.email) AND UserAccess = 'TimesheetAdmin'
						WHERE E.ProdcertName = @sRequestor)
	IF @UserAccess IS NULL
	BEGIN
		SET @UserAccess = ( SELECT CASE WHEN COUNT(E.nID) > 0 THEN 'manager' ELSE NULL END
							FROM TOEmployee E LEFT JOIN TOTimesheetProxys P
								ON P.sUser = CASE WHEN CHARINDEX(',', Manager, 0) > 0 THEN SUBSTRING(Manager, 0 , CHARINDEX(',', Manager, 0)) ELSE Manager END AND
									P.bIsDeleted = 0 AND CONVERT(DATE,GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate
							WHERE CASE WHEN CHARINDEX(',', Manager, 0) > 0 THEN SUBSTRING(Manager, 0 , CHARINDEX(',', Manager, 0)) ELSE Manager END = @sRequestor OR P.sProxy = @sRequestor	)
	END
	IF @UserAccess = 'admin' and @bIsDirectEmpOnly = 'true'
	BEGIN
		SET @UserAccess = 'manager'
	END
	IF @bIsAllEmployee = 'true'
	BEGIN
		IF @UserAccess = 'admin'
		BEGIN
			SELECT  DISTINCT nID, nLocationID, Manager, dHiredDate, sMobileNumber, sPhoneNumber, sEmail, ProdcertName, sEmpName
			,CASE WHEN @UserAccess IS NOT NULL THEN @UserAccess ELSE 'employee' END AS sRole
			, 1003 AS nTitleID, nDeptID, nTeamID,
			 sEmpID
			, NULL AS dDateHourlyStatusChanged, 'false' AS isHourlyStatusChanged
			, CASE WHEN nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
			, CASE WHEN E.status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
			, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE @bTimesheetSubmittedBefore END AS bTimesheetSubmittedBefore
			, CASE WHEN E.status IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE 'false' END AS bIsAuthorized
			, CASE WHEN prevLocationID IS NULL THEN CASE WHEN nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END
				   WHEN prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
			, CASE WHEN prevStatus IS NULL THEN NULL WHEN prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
			, EffectiveDateOfChange
			, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers )
			  THEN
				CASE WHEN DATEDIFF(wk, CONVERT(DATE, EffectiveDateOfChange - DATEPART(dw,  EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4
					 THEN 'false' ELSE 'true' END
			  ELSE 'false' END AS isOldStatusCheckRequired
			FROM TOEmployee	E JOIN @timesheetUsers T
				ON T.status = E.status OR E.prevStatus = T.status
		END
		IF @UserAccess = 'manager'
		BEGIN
			SELECT  DISTINCT E.nID, nLocationID, Manager, dHiredDate, sMobileNumber, sPhoneNumber, sEmail, ProdcertName, sEmpName
			,CASE WHEN @UserAccess IS NOT NULL THEN @UserAccess ELSE 'employee' END AS sRole
			, 1003 AS nTitleID, nDeptID, nTeamID,
			 sEmpID
			, NULL AS dDateHourlyStatusChanged, 'false' AS isHourlyStatusChanged
			, CASE WHEN nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
			, CASE WHEN E.status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
			, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE @bTimesheetSubmittedBefore END AS bTimesheetSubmittedBefore
			, CASE WHEN E.status IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE 'false' END AS bIsAuthorized
			, CASE WHEN prevLocationID IS NULL THEN CASE WHEN nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END
				   WHEN prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
			, CASE WHEN prevStatus IS NULL THEN NULL WHEN prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
			, EffectiveDateOfChange
			, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers )
			  THEN
				CASE WHEN DATEDIFF(wk, CONVERT(DATE, EffectiveDateOfChange - DATEPART(dw,  EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4
					 THEN 'false' ELSE 'true' END
			  ELSE 'false' END AS isOldStatusCheckRequired
			FROM TOEmployee	E JOIN @timesheetUsers T
				ON T.status = E.status OR E.prevStatus = T.status
			LEFT JOIN TOTimesheetProxys P
				 ON P.sUser = CASE WHEN CHARINDEX(',', Manager, 0) > 0 THEN SUBSTRING(Manager, 0 , CHARINDEX(',', Manager, 0)) ELSE Manager END AND
					P.bIsDeleted = 0 AND CONVERT(DATE,GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate
			WHERE (CASE WHEN CHARINDEX(',', Manager, 0) > 0 THEN SUBSTRING(Manager, 0 , CHARINDEX(',', Manager, 0)) ELSE Manager END = @sRequestor
					OR P.sProxy = @sRequestor)
		END
	END
	ELSE
	BEGIN
		SELECT  nID, nLocationID, Manager, dHiredDate, sMobileNumber, sPhoneNumber, sEmail, ProdcertName, sEmpName
		,CASE WHEN @UserAccess IS NOT NULL THEN @UserAccess ELSE 'employee' END AS sRole
		, 1003 AS nTitleID, nDeptID, nTeamID,
		 sEmpID
		, NULL AS dDateHourlyStatusChanged, 'false' AS isHourlyStatusChanged
		, CASE WHEN nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS payrollType
		, CASE WHEN status IN (SELECT status FROM @overtimeStatus)  THEN 'Overtime' ELSE 'Regular' END AS payrollModel
		, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE @bTimesheetSubmittedBefore END AS bTimesheetSubmittedBefore
		, CASE WHEN E.status IN (SELECT status from @timesheetUsers ) THEN 'true' ELSE 'false' END AS bIsAuthorized
		, CASE WHEN prevLocationID IS NULL THEN CASE WHEN nLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END
			   WHEN prevLocationID IN (SELECT nID FROM @doubleOTWorkStates) THEN 'CA' ELSE 'NR' END AS prevPayrollType
		, CASE WHEN prevStatus IS NULL THEN NULL WHEN prevStatus IN (SELECT status FROM @overtimeStatus) THEN 'Overtime' ELSE 'Regular' END AS prevPayrollModel
		, EffectiveDateOfChange
		, CASE WHEN E.prevStatus IN (SELECT status from @timesheetUsers )
			THEN
			CASE WHEN DATEDIFF(wk, CONVERT(DATE, EffectiveDateOfChange - DATEPART(dw,  EffectiveDateOfChange) % 7), CONVERT(DATE, GETDATE())) > 4
					THEN 'false' ELSE 'true' END
			ELSE 'false' END AS isOldStatusCheckRequired
		FROM TOEmployee	E
		WHERE ProdcertName = @sRequestor
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOGet_Employee_For_timesheet')
	delete from GxQscripts where name = 'TOGet_Employee_For_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOGet_Employee_For_timesheet')
	delete from GXDBVersions where aliasname = 'TOGet_Employee_For_timesheet'
GO

insert into GXDBVersions values(2, 'TOGet_Employee_For_timesheet',  '00010001000200030000', 'TOGet_Employee_For_timesheet', '00010001000200030000')
GO

