

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TODelete_timesheet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TODelete_timesheet.sp,v $ $Id: TODelete_timesheet.sp,v 1.1.2.2 2018/03/27 08:44:20 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TODelete_timesheet <<<'

IF EXISTS (select * from sysobjects where name='TODelete_timesheet')
	drop procedure TODelete_timesheet
IF EXISTS (select * from GxQscripts where name='TODelete_timesheet')
	delete from GxQscripts where name = 'TODelete_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TODelete_timesheet')
	delete from GXDBVersions where aliasname = 'TODelete_timesheet'
GO
print '... Creating Procedure: TODelete_timesheet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TODelete_timesheet
  @nID INT,
  @sRequestor NVARCHAR(50),	 	
  @sSubmittedBy NVARCHAR(50),	
  @sComments NVARCHAR(MAX),	
  @sAlias NVARCHAR(50),		
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
BEGIN TRANSACTION DeleteTimesheet
	BEGIN TRY
		DECLARE @nHelperTimeSheetStatusId INT = 4
		DECLARE @bIsTimesheetAlreadySubmitted BIT ='false'
		UPDATE TOTimeSheet SET sRequestor = @sRequestor, dateFilledIn = GETDATE(),
								 sSubmittedBy = @sSubmittedBy, sComments = @sComments, nHelperTimeSheetStatusId = @nHelperTimeSheetStatusId
		WHERE nID = @nID
		SET @bReturnCode = 'true'
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION CancelTimeOff
		SET @bReturnCode = 'false'
		RETURN
	END CATCH
COMMIT TRANSACTION CancelTimeOff
RETURN
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TODelete_timesheet')
	delete from GxQscripts where name = 'TODelete_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TODelete_timesheet')
	delete from GXDBVersions where aliasname = 'TODelete_timesheet'
GO

insert into GXDBVersions values(2, 'TODelete_timesheet',  '00010001000200020000', 'TODelete_timesheet', '00010001000200020000')
GO

