

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TODelete_timeoff.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TODelete_timeoff.sp,v $ $Id: TODelete_timeoff.sp,v 1.2.2.5 2018/03/27 08:56:28 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TODelete_timeoff <<<'

IF EXISTS (select * from sysobjects where name='TODelete_timeoff')
	drop procedure TODelete_timeoff
IF EXISTS (select * from GxQscripts where name='TODelete_timeoff')
	delete from GxQscripts where name = 'TODelete_timeoff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TODelete_timeoff')
	delete from GXDBVersions where aliasname = 'TODelete_timeoff'
GO
print '... Creating Procedure: TODelete_timeoff'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TODelete_timeoff
  @nID INT,
  @sRequestor NVARCHAR(50),	 	
  @sComments NVARCHAR(MAX),	
  @sOutlookMeetingID NVARCHAR(255),
  @sAlias NVARCHAR(50),		
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
BEGIN TRANSACTION CancelTimeOff
BEGIN TRY
	DECLARE @nHelperRequestStatusID INT = 4
	DECLARE @nApprovalEscalationLevel INT = 0 -- set by default 0 means immediate manager can approve
	DECLARE @sSubmitterAlias NVARCHAR(50)
	DECLARE @sRequestorAlias NVARCHAR(50)
	DECLARE @nOldLeaveStatus INT
	DECLARE @dOldReqStartDate DATE
	DECLARE @dOldReqEndDate DATE
	SELECT @nOldLeaveStatus = nHelperRequestStatusID, @dOldReqStartDate = dateStart, @dOldReqEndDate = dateEnd, @sSubmitterAlias = sSubmittedBy , @sRequestorAlias = sRequestor FROM TORequests WHERE nID = @nID
	IF @nOldLeaveStatus = 3 OR @nOldLeaveStatus = 4
	BEGIN
		SET @errorMsg = 'Error: Cannot delete cancelled/denied Requests'
		RAISERROR(@errorMsg, 16,1)
	END
	--IF CONVERT(DATE, GETDATE()) > @dOldReqStartDate
	--BEGIN
	--	SET @errorMsg = 'Error: Cannot cancel past days Requests'
	--	RAISERROR(@errorMsg, 16,1)
	--END
	IF NOT ((@nOldLeaveStatus IN (1,2) AND (@sAlias = @sRequestorAlias)) OR (@nOldLeaveStatus = 1 AND (@sSubmitterAlias = @sAlias)))
	BEGIN
		SET @errorMsg = 'Error: Cannot modify Requests which is either not yours nor submitted by you for others'
		RAISERROR(@errorMsg, 16,1)
	END
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	BEGIN
		UPDATE TORequests SET sComments = @sComments,nHelperRequestStatusID = @nHelperRequestStatusID, sSubmittedBy = @sAlias	WHERE nID = @nID
		IF @@ROWCOUNT <> 0
		BEGIN
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES( 'Request', @nID, @sAlias, GETDATE(),'Cancelled Time Off for: ' + @sRequestor )
			SET @bReturnCode = 'true'
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION CancelTimeOff
	SET @bReturnCode = 'false'
	RETURN
END CATCH
COMMIT TRANSACTION CancelTimeOff
RETURN
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TODelete_timeoff')
	delete from GxQscripts where name = 'TODelete_timeoff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TODelete_timeoff')
	delete from GXDBVersions where aliasname = 'TODelete_timeoff'
GO

insert into GXDBVersions values(2, 'TODelete_timeoff',  '00010002000200050000', 'TODelete_timeoff', '00010002000200050000')
GO

