

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TODelete_leave_entitlement_policy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TODelete_leave_entitlement_policy.sp,v $ $Id: TODelete_leave_entitlement_policy.sp,v 1.2.2.1 2018/03/27 09:01:43 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TODelete_leave_entitlement_policy <<<'

IF EXISTS (select * from sysobjects where name='TODelete_leave_entitlement_policy')
	drop procedure TODelete_leave_entitlement_policy
IF EXISTS (select * from GxQscripts where name='TODelete_leave_entitlement_policy')
	delete from GxQscripts where name = 'TODelete_leave_entitlement_policy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TODelete_leave_entitlement_policy')
	delete from GXDBVersions where aliasname = 'TODelete_leave_entitlement_policy'
GO
print '... Creating Procedure: TODelete_leave_entitlement_policy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TODelete_leave_entitlement_policy
  @sAlias NVARCHAR(50),
  @nID INT,
  @bReturnCode BIT OUTPUT
,
  @sReturnMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @IsLEPAssociatedToEmp BIT
	SELECT @IsLEPAssociatedToEmp  = CASE WHEN COUNT(*) > 0 THEN 'TRUE' ELSE 'FALSE' END FROM TOEmployeeToPolicyMapping WHERE nLeaveEntitlementPolicyID = @nID
	DECLARE @IsLEPAssociatedToRT BIT
	SELECT @IsLEPAssociatedToRT = CASE WHEN COUNT(*) > 0 THEN 'TRUE' ELSE 'FALSE' END FROM TORequestType WHERE nEntitlementPolicyID = @nID
	DECLARE @sPolicyName NVARCHAR(255)
	SELECT @sPolicyName = sPolicyName FROM TOLeaveEntitlementPolicy WHERE nID = @nID
	IF @IsLEPAssociatedToEmp = 1 OR @IsLEPAssociatedToRT = 1
	BEGIN
		SET @sReturnMsg ='Entitlement policy is either associated  to an employee or leave type'
		SET @bReturnCode = 'false'
	END
	ELSE
	BEGIN
		DELETE FROM TOLeaveEntitlementPolicy  WHERE nID= @nID
		IF @@ROWCOUNT <> 0
		BEGIN
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOLeaveEntitlementPolicy', @nID, @sAlias, GETDATE(),'Deleted Leave Entitlement Policy: ' + @sPolicyName)
			SET @bReturnCode = 'true'
			SET @sReturnMsg = 'success'
		END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @sReturnMsg = 'Something went wrong'
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TODelete_leave_entitlement_policy')
	delete from GxQscripts where name = 'TODelete_leave_entitlement_policy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TODelete_leave_entitlement_policy')
	delete from GXDBVersions where aliasname = 'TODelete_leave_entitlement_policy'
GO

insert into GXDBVersions values(2, 'TODelete_leave_entitlement_policy',  '00010002000200010000', 'TODelete_leave_entitlement_policy', '00010002000200010000')
GO

