

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCreate_timesheet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCreate_timesheet.sp,v $ $Id: TOCreate_timesheet.sp,v 1.1.2.3 2019/03/15 19:18:17 isebastian Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TOCreate_timesheet')
BEGIN
	print '>>> Drop Stored Procedure: TOCreate_timesheet <<<'
	drop procedure TOCreate_timesheet
END
IF EXISTS (select * from GxQscripts where name='TOCreate_timesheet')
	delete from GxQscripts where name = 'TOCreate_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_timesheet')
	delete from GXDBVersions where aliasname = 'TOCreate_timesheet'
GO
print '... Creating Procedure: TOCreate_timesheet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCreate_timesheet
  @sRequestor NVARCHAR(50),	
  @weekStart DATE,
  @timeMonStart NCHAR(100),	
  @timeMonEnd NCHAR(100),	
  @timeTueStart NCHAR(100),	
  @timeTueEnd NCHAR(100),	
  @timeWedStart NCHAR(100),	
  @timeWedEnd NCHAR(100),	
  @timeThuStart NCHAR(100),	
  @timeThuEnd NCHAR(100),	
  @timeFriStart NCHAR(100),	
  @timeFriEnd NCHAR(100),	
  @timeSatStart NCHAR(100),	
  @timeSatEnd NCHAR(100),	
  @timeSunStart NCHAR(100),	
  @timeSunEnd NCHAR(100),	
  @sSubmittedBy NVARCHAR(50),	
  @sComments NVARCHAR(MAX),	
  @nHoursSubmitted FLOAT,
  @bIsSubmitted BIT,
  @monBreakTime FLOAT,
  @tueBreakTime FLOAT,
  @wedBreakTime FLOAT,
  @thuBreakTime FLOAT,
  @friBreakTime FLOAT,
  @satBreakTime FLOAT,
  @sunBreakTime FLOAT,
  @nOTHours FLOAT,
  @nDoubleOTHours FLOAT,
  @sAlias NVARCHAR(50),
  @sickDays INT,
  @nID INT OUTPUT
,
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	BEGIN TRANSACTION CreateTimesheet
	BEGIN TRY
		DECLARE @nHelperTimeSheetStatusId INT = 1
		DECLARE @bIsTimesheetAlreadySubmitted BIT ='false'
		SELECT @bIsTimesheetAlreadySubmitted = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END, @nID = nID
			 FROM TOTimeSheet WHERE sRequestor= @sRequestor AND weekStart = @weekStart-- AND nHelperTimeSheetStatusId IN (1,2,5)
		GROUP BY nID
		IF @bIsTimesheetAlreadySubmitted = 'true'
		BEGIN
			SET @bReturnCode = 'false'
			SET @errorMsg = 'Timesheet Already submitted for the week'
			--UPDATE TOTimeSheet SET sRequestor = @sRequestor, weekStart = @weekStart, dateFilledIn = GETDATE(), timeMonStart = @timeMonStart, timeMonEnd = @timeMonEnd
			--					, timeTueStart = @timeTueStart, timeTueEnd = @timeTueEnd
			--					, timeWedStart = @timeWedStart, timeWedEnd = @timeWedEnd, timeThuStart = @timeThuStart, timeThuEnd = @timeThuEnd
			--					, timeFriStart = @timeFriStart, timeFriEnd = @timeFriEnd, timeSatStart = @timeSatStart, timeSatEnd = @timeSatEnd
			--					, timeSunStart = @timeSunStart, timeSunEnd = @timeSunEnd, sSubmittedBy = @sSubmittedBy, sComments = @sComments, nHelperTimeSheetStatusId = @nHelperTimeSheetStatusId
			--					, nHoursSubmitted = @nHoursSubmitted, bIsSubmitted = @bIsSubmitted, monBreaktime = @monBreaktime, tueBreakTime = @tueBreakTime, wedBreakTime = @wedBreakTime
			--					, thuBreakTime = @thuBreakTime, friBreakTime = @friBreakTime, satBreakTime = @satBreakTime, sunBreakTime = @sunBreakTime, nOTHours = @nOTHours
			--					, nDoubleOThours = @nDoubleOThours
			--WHERE nID = @nID
		END
		ELSE
		BEGIN
			INSERT INTO TOTimeSheet (sRequestor, weekStart, dateFilledIn, timeMonStart, timeMonEnd, timeTueStart, timeTueEnd, timeWedStart, timeWedEnd, timeThuStart, timeThuEnd
								 , timeFriStart, timeFriEnd, timeSatStart, timeSatEnd, timeSunStart, timeSunEnd, sSubmittedBy, sComments, nHelperTimeSheetStatusId, nHoursSubmitted
								 , bIsSubmitted, monBreaktime, tueBreakTime, wedBreakTime, thuBreakTime, friBreakTime, satBreakTime, sunBreakTime, nOTHours, nDoubleOThours, sickDays)
			VALUES (@sRequestor, @weekStart, GETDATE(), @timeMonStart, @timeMonEnd, @timeTueStart, @timeTueEnd, @timeWedStart, @timeWedEnd, @timeThuStart, @timeThuEnd
								 , @timeFriStart, @timeFriEnd, @timeSatStart, @timeSatEnd, @timeSunStart, @timeSunEnd, @sSubmittedBy, @sComments, @nHelperTimeSheetStatusId, @nHoursSubmitted
								 , @bIsSubmitted, @monBreaktime, @tueBreakTime, @wedBreakTime, @thuBreakTime, @friBreakTime, @satBreakTime, @sunBreakTime, @nOTHours, @nDoubleOThours, @sickDays)
			SET @nID = SCOPE_IDENTITY()
			SET @bReturnCode = 'true'
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION CreateTimeOff
		SET @bReturnCode = 'false'
		RETURN
	END CATCH
COMMIT TRANSACTION CreateTimesheet
RETURN
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCreate_timesheet')
	delete from GxQscripts where name = 'TOCreate_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_timesheet')
	delete from GXDBVersions where aliasname = 'TOCreate_timesheet'
GO

insert into GXDBVersions values(2, 'TOCreate_timesheet',  '00010001000200030000', 'TOCreate_timesheet', '00010001000200030000')
GO

