

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCreate_request_type.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCreate_request_type.sp,v $ $Id: TOCreate_request_type.sp,v 1.2.2.2 2018/03/27 08:51:43 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCreate_request_type <<<'

IF EXISTS (select * from sysobjects where name='TOCreate_request_type')
	drop procedure TOCreate_request_type
IF EXISTS (select * from GxQscripts where name='TOCreate_request_type')
	delete from GxQscripts where name = 'TOCreate_request_type'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_request_type')
	delete from GXDBVersions where aliasname = 'TOCreate_request_type'
GO
print '... Creating Procedure: TOCreate_request_type'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCreate_request_type
  @sAlias NVARCHAR(50),
  @sRequestType NVARCHAR(255),
  @bIsDeductible BIT,
  @nEntitlementPolicyID INT,	
  @nApprovalPolicyID INT,
  @bIsVisibleToAll BIT,
  @nLocationID INT,
  @bIsOverlapAllowed BIT,
  @sOverlapRequestType NVARCHAR(50),
  @bIsHalfDayAllowed BIT,
  @bIsOptionalType BIT,
  @sDept nvarchar(MAX),
  @nOverridingReqID INT,
  @nRequestTypeID INT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @IsEntitlementPolicyAvailable BIT
	SELECT @IsEntitlementPolicyAvailable = CASE WHEN COUNT(*) > 0 THEN 'TRUE' ELSE 'FALSE' END FROM TOLeaveEntitlementPolicy WHERE nID = @nEntitlementPolicyID
	DECLARE @IsApprovalPolicyAvailable BIT
	SELECT @IsApprovalPolicyAvailable = CASE WHEN COUNT(*) > 0 THEN 'TRUE' ELSE 'FALSE' END FROM TOLeaveApprovalPolicy WHERE nID = @nApprovalPolicyID
	DECLARE @IsLocationAvailable BIT
	SELECT @IsLocationAvailable = CASE WHEN COUNT(*) > 0 THEN 'TRUE' ELSE 'FALSE' END FROM TOLocation WHERE nID = @nLocationID
	DECLARE @bIsAnyOptType BIT = 'false'
	SELECT @bIsAnyOptType = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TORequestType WHERE bIsOptionalType ='true' AND nLocationID = @nLocationID
	IF @bIsAnyOptType = 'true' AND @bIsOptionalType = 'true'
	BEGIN
		SET @nRequestTypeID = -1
		SET @errorMsg = 'Error: Couldn''t add two optional request type'
		RETURN
	END
	IF @sDept IS NOT NULL
	BEGIN
		DECLARE @NoOfDeptAvailable INT = 0
		DECLARE @NoOfDeptPasses INT = 0
		SELECT @NoOfDeptAvailable = COUNT(*) FROM TODepartment D JOIN dbo.TOSplit(@sDept, ',') T
			ON D.nID = T.Item
		SELECT @NoOfDeptPasses = COUNT(*) FROM dbo.TOSplit(@sDept, ',') T
		IF @NoOfDeptAvailable != @NoOfDeptAvailable
		BEGIN
			SET @nRequestTypeID = -1
			SET @errorMsg = 'Error: Couldn''t find department'
			RETURN
		END
	END
	IF @nOverridingReqID IS NOT NULL AND @nOverridingReqID > 0
	BEGIN
		DECLARE @bIsOverrideReqTypeValid BIT = 'true'
		SELECT @bIsOverrideReqTypeValid = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TORequestType RT JOIN TOLocation L
			ON RT.nLocationID = L.nParentLocID AND L.nID = @nLocationID  AND RT.nID = @nOverridingReqID
		IF @bIsOverrideReqTypeValid = 'false'
		BEGIN
			SET @nRequestTypeID = -1
			SET @errorMsg = 'Error: Couldn''t override request type'
			RETURN
		END
	END
    INSERT INTO TORequestType (sRequestType, bIsDeductible, nEntitlementPolicyID, nApprovalPolicyID, bIsVisibleToAll, nLocationID, bIsOverlapAllowed, sOverlapRequestType, bIsHalfDayAllowed, bIsOptionalType, sDept, nOverridingReqID)
		VALUES(@sRequestType, @bIsDeductible, @nEntitlementPolicyID, @nApprovalPolicyID, @bIsVisibleToAll, @nLocationID, @bIsOverlapAllowed, @sOverlapRequestType, @bIsHalfDayAllowed,@bIsOptionalType, @sDept, @nOverridingReqID)
		SET @nRequestTypeID = SCOPE_IDENTITY()
	INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TORequestType', @nRequestTypeID, @sAlias, GETDATE(),'Create New Request Type: ' + @sRequestType)
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCreate_request_type')
	delete from GxQscripts where name = 'TOCreate_request_type'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_request_type')
	delete from GXDBVersions where aliasname = 'TOCreate_request_type'
GO

insert into GXDBVersions values(2, 'TOCreate_request_type',  '00010002000200020000', 'TOCreate_request_type', '00010002000200020000')
GO

