

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCreate_request_attachment.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCreate_request_attachment.sp,v $ $Id: TOCreate_request_attachment.sp,v 1.2.2.1 2018/03/27 09:00:58 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCreate_request_attachment <<<'

IF EXISTS (select * from sysobjects where name='TOCreate_request_attachment')
	drop procedure TOCreate_request_attachment
IF EXISTS (select * from GxQscripts where name='TOCreate_request_attachment')
	delete from GxQscripts where name = 'TOCreate_request_attachment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_request_attachment')
	delete from GXDBVersions where aliasname = 'TOCreate_request_attachment'
GO
print '... Creating Procedure: TOCreate_request_attachment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCreate_request_attachment
  @nRequestID INT,				
  @sAttachmentName NVARCHAR(255),	
  @sAttachmentType NVARCHAR(255), 	
  @sAttachmentGUID NVARCHAR(255),
  @sAlias NVARCHAR(50),
  @nID INT OUTPUT
,
  @bReturnCode BIT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @reqID INT
	SELECT @reqID = nID From TORequests WHERE (sSubmittedBy = @sAlias OR sRequestor = @sAlias) AND nID = @nRequestID
	IF @reqID > 0
	BEGIN
		INSERT INTO TORequest_Attachment(nRequestID, sAttachmentName, sAttachmentType, sAttachmentGUID) VALUES (@nRequestID, @sAttachmentName, @sAttachmentType, @sAttachmentGUID) SET  @nID = SCOPE_IDENTITY()
		IF @@ROWCOUNT <> 0
		BEGIN
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TORequest_Attachment', @nID, @sAlias, GETDATE(),'Created Request Attachment: ' + @sAttachmentName)
			SET @bReturnCode = 'true'
		END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @nID = -1
		END
	END
	ELSE
	BEGIN
		SET @bReturnCode = 'false'
		SET @nID = -1
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCreate_request_attachment')
	delete from GxQscripts where name = 'TOCreate_request_attachment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_request_attachment')
	delete from GXDBVersions where aliasname = 'TOCreate_request_attachment'
GO

insert into GXDBVersions values(2, 'TOCreate_request_attachment',  '00010002000200010000', 'TOCreate_request_attachment', '00010002000200010000')
GO

