

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCreate_proxy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCreate_proxy.sp,v $ $Id: TOCreate_proxy.sp,v 1.2.2.1 2018/03/27 08:58:04 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCreate_proxy <<<'

IF EXISTS (select * from sysobjects where name='TOCreate_proxy')
	drop procedure TOCreate_proxy
IF EXISTS (select * from GxQscripts where name='TOCreate_proxy')
	delete from GxQscripts where name = 'TOCreate_proxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_proxy')
	delete from GXDBVersions where aliasname = 'TOCreate_proxy'
GO
print '... Creating Procedure: TOCreate_proxy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCreate_proxy
  @sAlias NVARCHAR(50),		
  @dValidFrom DATE,	
  @dExpiryDate DATE,  
  @sProxy NVARCHAR(50), 
  @sUser NVARCHAR(50),
  @nID INT OUTPUT
,
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @nProxyCount INT = 0
	DECLARE @bIsUserManager BIT = 'false'
	SELECT @bIsUserManager = CASE WHEN COUNT(*) > 0 THEN 'true' ELSE 'false' END FROM TOEmployee WHERE @sUser IN (SELECT * FROM dbo.TOSplit(Manager, ','))
	SELECT @nProxyCount = COUNT(*) FROM TOProxys WHERE sUser = @sUser AND bIsDeleted = 0 AND ( (dValidFrom BETWEEN @dValidFrom AND @dExpiryDate) OR (dExpiryDate BETWEEN @dValidFrom AND @dExpiryDate)
		OR (dValidFrom <= @dValidFrom AND dExpiryDate >= @dExpiryDate) OR (@dValidFrom <= dValidFrom   AND @dExpiryDate >= dExpiryDate) )
    IF @nProxyCount > 0 -- start date is less than end date
    BEGIN
		SET @bReturnCode = 'false'
		SET @errorMsg = 'Error: Already a proxy is assigned for given dates'
	END
	ELSE
    BEGIN
		IF @bIsUserManager = 'true'
		BEGIN
			INSERT INTO TOProxys (dValidFrom, dExpiryDate,  sProxy, sUser, bIsDeleted)
			VALUES (@dValidFrom, @dExpiryDate, @sProxy, @sUser, 'false') SET @nID = SCOPE_IDENTITY()
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOProxys', @nID, @sAlias, GETDATE(),'Created Proxy for user: ' + @sUser)
			SET @bReturnCode = 'true'
			SET @errorMsg = 'success'
		END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @errorMsg = 'Error: Proxy cannot be assigned for user ' + @sUser
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCreate_proxy')
	delete from GxQscripts where name = 'TOCreate_proxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_proxy')
	delete from GXDBVersions where aliasname = 'TOCreate_proxy'
GO

insert into GXDBVersions values(2, 'TOCreate_proxy',  '00010002000200010000', 'TOCreate_proxy', '00010002000200010000')
GO

