

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCreate_holidays.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCreate_holidays.sp,v $ $Id: TOCreate_holidays.sp,v 1.2.2.1 2018/03/27 08:57:34 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCreate_holidays <<<'

IF EXISTS (select * from sysobjects where name='TOCreate_holidays')
	drop procedure TOCreate_holidays
IF EXISTS (select * from GxQscripts where name='TOCreate_holidays')
	delete from GxQscripts where name = 'TOCreate_holidays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_holidays')
	delete from GXDBVersions where aliasname = 'TOCreate_holidays'
GO
print '... Creating Procedure: TOCreate_holidays'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCreate_holidays
  @sAlias NVARCHAR(50),		
  @StartDate DATE,	
  @EndDate DATE, 
  @nIsOptional INT, 
  @nLocationID INT, 
  @sName NVARCHAR(255),
  @nID INT OUTPUT
,
  @bReturnCode BIT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @nHolidayDays INT
	SET @nHolidayDays = DATEDIFF(DAY, @StartDate, @EndDate) + 1
    IF @nHolidayDays > 0 -- start date is less than end date
    BEGIN
		INSERT INTO TOHolidays (dStartDate, dEndDate,  nStatus, nIsOptional, nLocationID, sName)
		VALUES (@StartDate, @EndDate, 1, @nIsOptional, @nLocationID, @sName) SET @nID = SCOPE_IDENTITY()
		INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOHolidays', @nID, @sAlias, GETDATE(),'Created TOHolidays: ' + @sName)
		SET @bReturnCode = 'true'
	END
	ELSE
	BEGIN
		SET @bReturnCode = 'false'
		SET @nID = -1
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCreate_holidays')
	delete from GxQscripts where name = 'TOCreate_holidays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_holidays')
	delete from GXDBVersions where aliasname = 'TOCreate_holidays'
GO

insert into GXDBVersions values(2, 'TOCreate_holidays',  '00010002000200010000', 'TOCreate_holidays', '00010002000200010000')
GO

