

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCreate_events.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCreate_events.sp,v $ $Id: TOCreate_events.sp,v 1.2.2.1 2018/03/27 09:03:59 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCreate_events <<<'

IF EXISTS (select * from sysobjects where name='TOCreate_events')
	drop procedure TOCreate_events
IF EXISTS (select * from GxQscripts where name='TOCreate_events')
	delete from GxQscripts where name = 'TOCreate_events'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_events')
	delete from GXDBVersions where aliasname = 'TOCreate_events'
GO
print '... Creating Procedure: TOCreate_events'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCreate_events
  @sEventName NVARCHAR(255),
  @sVenue NVARCHAR(255),
  @sDetails NVARCHAR(MAX),
  @dStartDate DATE,
  @dEndDate DATE,
  @sAlias NVARCHAR(50),		
  @nLocationID INT,
  @nID INT OUTPUT
,
  @bReturnCode BIT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
    BEGIN
		INSERT INTO TOEvents (sEventName,sVenue,sDetails,dStartDate,dEndDate,sAlias,nLocationID)
		VALUES (@sEventName,@sVenue,@sDetails,@dStartDate,@dEndDate,@sAlias,@nLocationID)
		SET @nID = SCOPE_IDENTITY()
		IF @@ROWCOUNT <> 0
		BEGIN
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOEvents', @nID, @sAlias, GETDATE(),'Created Event: ' + @sEventName)
			SET @bReturnCode = 'true'
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCreate_events')
	delete from GxQscripts where name = 'TOCreate_events'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_events')
	delete from GXDBVersions where aliasname = 'TOCreate_events'
GO

insert into GXDBVersions values(2, 'TOCreate_events',  '00010002000200010000', 'TOCreate_events', '00010002000200010000')
GO

