

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCreate_employees.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCreate_employees.sp,v $ $Id: TOCreate_employees.sp,v 1.2.2.1 2018/03/27 09:13:58 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCreate_employees <<<'

IF EXISTS (select * from sysobjects where name='TOCreate_employees')
	drop procedure TOCreate_employees
IF EXISTS (select * from GxQscripts where name='TOCreate_employees')
	delete from GxQscripts where name = 'TOCreate_employees'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_employees')
	delete from GXDBVersions where aliasname = 'TOCreate_employees'
GO
print '... Creating Procedure: TOCreate_employees'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCreate_employees
  @sAlias NVARCHAR(50),		
  @nLocationID INT,
  @Manager NVARCHAR(255),
  @dHiredDate DATETIME,
  @sMobileNumber NVARCHAR(50),
  @sPhoneNumber NVARCHAR(50),
  @sEmail NVARCHAR(255),
  @ProdcertName NVARCHAR(50),
  @Gender BIT,
  @sEmpName NVARCHAR(255),
  @nTitleID INT,
  @nDeptID INT,
  @nTeamID INT, 
  @sEmpID NVARCHAR(50),
  @nID INT OUTPUT
,
  @bReturnCode BIT OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;
    BEGIN
		DECLARE @ManagerCount INT = 0
		DECLARE @bIsSameManager BIT = 0
		DECLARE @Table TABLE (ManagerCount INT)
		IF @Manager IS NOT NULL
		BEGIN
			IF @Manager = @ProdcertName
				SET @bIsSameManager = 1
			ELSE
				INSERT INTO @Table SELECT  COUNT(ProdcertName) FROM TOEmployee E JOIN dbo.TOSplit(@Manager, ',') T ON E.ProdcertName = T.Item GROUP BY E.ProdcertName HAVING COUNT(ProdcertName) = 1
		END
		IF (SELECT COUNT(*) FROM @Table) = (SELECT COUNT(*) FROM dbo.TOSplit(@Manager, ',')) OR (@bIsSameManager = 'true') OR (@Manager IS NULL)
		BEGIN
			INSERT INTO TOEmployee (nLocationID,Manager,dHiredDate,sMobileNumber,sPhoneNumber,sEmail,ProdcertName,Gender,sEmpName,nTitleID,nDeptID,nTeamID,sEmpID)
			VALUES (@nLocationID,@Manager,@dHiredDate,@sMobileNumber,@sPhoneNumber,@sEmail,@ProdcertName,@Gender,@sEmpName,@nTitleID,@nDeptID,@nTeamID,@sEmpID)
			SET @nID = SCOPE_IDENTITY()
			IF @@ROWCOUNT <> 0
			BEGIN
				INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOEmployee', @nID, @sAlias, GETDATE(),'Created TOEmployee: ' + @sEmpName)
				SET @bReturnCode = 'true'
			END
		END
		ELSE
			SET @bReturnCode = 'false'
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCreate_employees')
	delete from GxQscripts where name = 'TOCreate_employees'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCreate_employees')
	delete from GXDBVersions where aliasname = 'TOCreate_employees'
GO

insert into GXDBVersions values(2, 'TOCreate_employees',  '00010002000200010000', 'TOCreate_employees', '00010002000200010000')
GO

