

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCheck_overlapping_request_violation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCheck_overlapping_request_violation.sp,v $ $Id: TOCheck_overlapping_request_violation.sp,v 1.2.2.3 2018/03/27 08:55:04 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCheck_overlapping_request_violation <<<'

IF EXISTS (select * from sysobjects where name='TOCheck_overlapping_request_violation')
	drop procedure TOCheck_overlapping_request_violation
IF EXISTS (select * from GxQscripts where name='TOCheck_overlapping_request_violation')
	delete from GxQscripts where name = 'TOCheck_overlapping_request_violation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCheck_overlapping_request_violation')
	delete from GXDBVersions where aliasname = 'TOCheck_overlapping_request_violation'
GO
print '... Creating Procedure: TOCheck_overlapping_request_violation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCheck_overlapping_request_violation
  @sRequestor NVARCHAR(50),
  @LEPStartDate DATE,
  @LEPEndDate DATE,
  @StartDate DATE,
  @EndDate DATE,
  @nReqTypeID INT,
  @bIsHalfDay BIT,
  @nHalfDayType BIT,		
  @nLocationID INT,
  @nOldReqID INT,
  @IsOverlapCheckPassed BIT OUTPUT
,
  @nOverlapReqSplits INT OUTPUT
AS
BEGIN
	DECLARE @nNonOverlapReqTypeCount INT          -- Count of no. of TORequests overlap with current request which cannot be overlapped with. If this variable is non-zero return false and exit.
	DECLARE @sOverlapReqType NVARCHAR(50)         -- Type of leave types which the current request can overlap with.
	DECLARE @sOptHoliday NVARCHAR(50)
	DECLARE @nOverlapReqTypeCount INT
	DECLARE @bIsOverlapRequestEscalated BIT
	DECLARE @dateStart DATE
	DECLARE @dateEnd DATE
	DECLARE @nID INT
	DECLARE @nOptDaysInSplit INT
	DECLARE @nCancelStatusID INT = 4
	DECLARE @nApprovedStatusID INT = 2
	DECLARE @nSubmittedStatusID INT = 1
	DECLARE @sOptionalDays NVARCHAR(255)
	DECLARE @bIsHalfDayAllowedForOldReq BIT = 'true'
	DECLARE @nMaxReqCountAllowed INT = -1       -- we need to check if splitting requests is permissable based on Total count for employee or not.
	DECLARE @nTotalRequestCount INT             -- we need to check the total count of splitting requests before splitting it.
	DECLARE @SplitOverlapReqType TABLE(nOverlapReqID INT)
	DECLARE @SplitNonOverlapReqType TABLE(nNonOverlapReqID INT)
	DECLARE @SplitTable TABLE(dOptHolidays DATE)
	DECLARE @OverlapRequest TABLE(nID INT, dateStart DATE, dateEnd DATE, bIsEscalated BIT, sOptHolidays NVARCHAR(255), nHelperRequestStatusID INT, nRequestType INT)
	SELECT @sOverlapReqType = sOverlapRequestType FROM TORequestType WHERE nID = @nReqTypeID AND bIsOverlapAllowed = 'true'
	IF NOT (@nOldReqID > 0)
		SET @nOldReqID = -1
	ELSE
		SELECT @bIsHalfDayAllowedForOldReq = bIsHalfDayAllowed FROM TORequestType WHERE nID = @nOldReqID
	INSERT INTO @SplitOverlapReqType SELECT  CONVERT(INT,Item) FROM dbo.TOSplit(@sOverlapReqType , ',')
	INSERT INTO @SplitNonOverlapReqType SELECT nID FROM TORequestType EXCEPT SELECT nOverlapReqID FROM @SplitOverlapReqType
	--DECLARE @v XML = (SELECT * FROM @SplitNonOverlapReqType FOR XML AUTO)
	--SELECT @v
	IF @bIsHalfDay = 0
	BEGIN
		SELECT @nNonOverlapReqTypeCount = COUNT(*) FROM TORequests JOIN @SplitNonOverlapReqType T
			ON T.nNonOverlapReqID = nRequestTypeID
		WHERE nID <> @nOldReqID AND ((dateStart <= @StartDate AND dateEnd >= @EndDate) OR (dateStart >= @StartDate AND dateEnd <= @EndDate)
			  OR (@StartDate BETWEEN dateStart AND dateEnd) OR (@EndDate BETWEEN dateStart AND dateEnd))
			AND sRequestor = @sRequestor AND nHelperRequestStatusID IN (@nSubmittedStatusID, @nApprovedStatusID)
	END
	ELSE IF @bIsHalfDay = 1 AND (@StartDate = @EndDate)
		SELECT @nNonOverlapReqTypeCount = COUNT(*) FROM TORequests JOIN @SplitNonOverlapReqType T
			ON T.nNonOverlapReqID = nRequestTypeID
		WHERE nID <> @nOldReqID AND ((@StartDate BETWEEN dateStart AND dateEnd AND (bIsHalfDay = 0)) OR (bIsHalfDay = 1 AND bHalfDayType = @nHalfDayType AND (@StartDate BETWEEN dateStart AND dateEnd) ))
			AND sRequestor = @sRequestor AND nHelperRequestStatusID IN (@nSubmittedStatusID, @nApprovedStatusID)
	IF @nNonOverlapReqTypeCount = 0
	BEGIN
		INSERT INTO @OverlapRequest SELECT nID, dateStart, dateEnd, bIsEscalated, sOptHolidays, nHelperRequestStatusID, nRequestTypeID FROM TORequests JOIN @SplitOverlapReqType T
			ON T.nOverlapReqID = nRequestTypeID
		WHERE ((dateStart <= @StartDate AND dateEnd >= @EndDate) OR (dateStart >= @StartDate AND dateEnd <= @EndDate)
			  OR (@StartDate BETWEEN dateStart AND dateEnd) OR (@EndDate BETWEEN dateStart AND dateEnd)) AND nID <> @nOldReqID
			AND sRequestor = @sRequestor AND nHelperRequestStatusID IN (@nSubmittedStatusID, @nApprovedStatusID)
		SELECT @nOverlapReqTypeCount = COUNT(*) FROM @OverlapRequest
		IF @nOverlapReqTypeCount > 1
		BEGIN
			SET @IsOverlapCheckPassed = 'false'
			SET @nOverlapReqSplits = -1
		END
		ELSE IF @nOverlapReqTypeCount = 1
		BEGIN
			SELECT @bIsOverlapRequestEscalated = bIsEscalated FROM @OverlapRequest
			IF @bIsOverlapRequestEscalated = 'true'
			BEGIN
				SET @IsOverlapCheckPassed = 'false'
				SET @nOverlapReqSplits = -1
			END
			ELSE
			BEGIN
				DECLARE @nHelperRequestStatusID INT = 0
				SELECT @sOptHoliday=sOptHolidays, @nID = nID, @dateStart = dateStart, @dateEnd = dateEnd, @nHelperRequestStatusID = nHelperRequestStatusID FROM @OverlapRequest
				DECLARE @nWorkDays INT = 0
				-- write logic here to split TORequests
				IF @bIsHalfDay = 'true'
				BEGIN
					SELECT @bIsHalfDayAllowedForOldReq = bIsHalfDayAllowed FROM TORequestType R JOIN @OverlapRequest T ON T.nRequestType = R.nID
					IF @bIsHalfDayAllowedForOldReq = 'false'
					BEGIN
							SET @IsOverlapCheckPassed = 'false'
							SET @nOverlapReqSplits = -1
							RETURN
					END
					IF (@dateStart = @dateEnd)
						UPDATE TORequests SET nWorkDays = 0.5, bIsHalfDay = 'true', bHalfDayType = (CASE WHEN @nHalfDayType = 'true' THEN 'false' ELSE 'true' END) WHERE nID = @nID
					ELSE IF (@dateStart <> @dateEnd ) AND (@StartDate = @EndDate) AND ((@StartDate = @dateEnd) OR (@StartDate = @dateStart))
					BEGIN
						IF ((@nMaxReqCountAllowed = -1) OR (@nTotalRequestCount + 2 <= @nMaxReqCountAllowed))
						BEGIN
							INSERT INTO @SplitTable SELECT  CONVERT(DATE,Item) FROM dbo.TOSplit(@sOptHoliday , ',')
							IF (@StartDate = @dateEnd)
							BEGIN
								SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @dateEnd)
								SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @StartDate) ORDER BY dOptHolidays FOR XML PATH(''))
								SELECT @nWorkDays = dbo.TOGet_total_working_days(@dateStart, DATEADD(DAY, -1, @dateEnd), @nOptDaysInSplit, @nLocationID)
								IF @nWorkDays > 0
									UPDATE  TORequests SET dateEnd = DATEADD(DAY, -1, @dateEnd), sOptHolidays= @sOptionalDays,
										nWorkDays = @nWorkDays  WHERE nID = @nID
								ELSE
									UPDATE TORequests SET nHelperRequestStatusID =  @nCancelStatusID, nWorkDays = @nWorkDays, dateEnd = DATEADD(DAY, -1, @dateEnd),
										sOptHolidays= @sOptionalDays WHERE nID = @nID
							END
							ELSE IF (@StartDate = @dateStart)
							BEGIN
								SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @dateStart) AND @dateEnd
								SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @dateStart) AND @dateEnd ORDER BY dOptHolidays FOR XML PATH(''))
								SELECT @nWorkDays = dbo.TOGet_total_working_days(DATEADD(DAY, 1, @dateStart), @dateEnd, @nOptDaysInSplit, @nLocationID)
								IF @nWorkDays > 0
									UPDATE  TORequests SET dateStart = DATEADD(DAY, 1, @dateStart), sOptHolidays= @sOptionalDays,
										nWorkDays = @nWorkDays  WHERE nID = @nID
								ELSE
									UPDATE  TORequests SET dateStart = DATEADD(DAY, 1, @dateStart), sOptHolidays= @sOptionalDays, nHelperRequestStatusID = @nCancelStatusID,
										nWorkDays = @nWorkDays  WHERE nID = @nID
							END
							INSERT INTO TORequests (dateRequested,sRequestor,nRequestTypeID,dateStart,dateEnd,nWorkDays,sComments,nHelperRequestStatusID,sOutlookMeetingID,sOptHolidays,
							nApprovalEscalationLevel,sSubmittedBy,bIsHalfDay,bHalfDayType, bIsEscalated, sEscalationApprover)
							SELECT  dateRequested, sRequestor,nRequestTypeID,@StartDate,@EndDate, 0.5 ,sComments,@nHelperRequestStatusID,sOutlookMeetingID,NULL,
							nApprovalEscalationLevel,sSubmittedBy,'true',(CASE WHEN @nHalfDayType = 'true' THEN 'false' ELSE 'true' END),bIsEscalated,sEscalationApprover FROM TORequests WHERE nID = @nID
						END
						ELSE
						BEGIN
							SET @IsOverlapCheckPassed = 'false'
							SET @nOverlapReqSplits = -1
							RETURN
						END
					END
					ELSE IF(@dateStart <> @dateEnd ) AND (@StartDate = @EndDate) AND (@StartDate > @dateStart) AND (@StartDate < @dateEnd)
					BEGIN
						IF ((@nMaxReqCountAllowed = -1) OR (@nTotalRequestCount + 3 <= @nMaxReqCountAllowed))
						BEGIN
							SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @StartDate)
							SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @StartDate) ORDER BY dOptHolidays FOR XML PATH(''))
							SELECT @nWorkDays = dbo.TOGet_total_working_days(@dateStart, DATEADD(DAY, -1, @StartDate), @nOptDaysInSplit, @nLocationID)
							IF @nWorkDays > 0
								UPDATE  TORequests SET dateEnd = DATEADD(DAY, -1, @StartDate), sOptHolidays= @sOptionalDays,
									nWorkDays = @nWorkDays  WHERE nID = @nID
							ELSE
								UPDATE  TORequests SET dateEnd = DATEADD(DAY, -1, @StartDate), sOptHolidays= @sOptionalDays, nHelperRequestStatusID = @nCancelStatusID,
									nWorkDays = @nWorkDays  WHERE nID = @nID
							INSERT INTO TORequests (dateRequested,sRequestor,nRequestTypeID,dateStart,dateEnd,nWorkDays,sComments,nHelperRequestStatusID,sOutlookMeetingID,sOptHolidays,
							nApprovalEscalationLevel,sSubmittedBy,bIsHalfDay,bHalfDayType, bIsEscalated, sEscalationApprover)
							SELECT  dateRequested, sRequestor,nRequestTypeID,@StartDate,@EndDate, 0.5 ,sComments,@nHelperRequestStatusID,sOutlookMeetingID,NULL,
							nApprovalEscalationLevel,sSubmittedBy,'true',(CASE WHEN @nHalfDayType = 'true' THEN 'false' ELSE 'true' END),bIsEscalated,sEscalationApprover FROM TORequests WHERE nID = @nID
							SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @StartDate) AND @dateEnd
							SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @StartDate) AND @dateEnd ORDER BY dOptHolidays FOR XML PATH(''))
							SELECT @nWorkDays = dbo.TOGet_total_working_days(DATEADD(DAY, 1, @StartDate), @dateEnd, @nOptDaysInSplit, @nLocationID)
							IF @nWorkDays > 0
								INSERT INTO TORequests (dateRequested,sRequestor,nRequestTypeID,dateStart,dateEnd,nWorkDays,sComments,nHelperRequestStatusID,sOutlookMeetingID,sOptHolidays,
									nApprovalEscalationLevel,sSubmittedBy,bIsHalfDay,bHalfDayType, bIsEscalated, sEscalationApprover)
								SELECT  dateRequested, sRequestor,nRequestTypeID,DATEADD(DAY, 1, @StartDate),@dateEnd, @nWorkDays
									,sComments,@nHelperRequestStatusID,sOutlookMeetingID,@sOptionalDays,
									nApprovalEscalationLevel,sSubmittedBy,bIsHalfDay,bHalfDayType,bIsEscalated,sEscalationApprover FROM TORequests WHERE nID = @nID
						END
						ELSE
						BEGIN
							SET @IsOverlapCheckPassed = 'false'
							SET @nOverlapReqSplits = -1
							RETURN
						END
					END
					SET @IsOverlapCheckPassed = 'true'
				END
				ELSE
				BEGIN
					IF (@StartDate <= @dateStart AND  @EndDate >= @dateEnd)
					BEGIN
						-- cancel the old request, no changes in new request
						SET @nOverlapReqSplits = 0
						UPDATE TORequests SET nHelperRequestStatusID = @nCancelStatusID WHERE nID = @nID
					END
					ELSE IF (@StartDate > @dateStart AND @EndDate < @dateEnd)
					BEGIN
						-- split the old request in two TORequests, no changes in new request
						SET @nOverlapReqSplits = 2
						IF ((@nMaxReqCountAllowed = -1) OR (@nTotalRequestCount + 2 <= @nMaxReqCountAllowed))
						BEGIN
							INSERT INTO @SplitTable SELECT  CONVERT(DATE,Item) FROM dbo.TOSplit(@sOptHoliday , ',')
							SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @StartDate)
							SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @StartDate) ORDER BY dOptHolidays FOR XML PATH(''))
							SELECT @nWorkDays = dbo.TOGet_total_working_days(@dateStart, DATEADD(DAY, -1, @StartDate), @nOptDaysInSplit, @nLocationID)
							IF @nWorkDays > 0
								UPDATE  TORequests SET dateEnd = DATEADD(DAY, -1, @StartDate), sOptHolidays= @sOptionalDays,
										nWorkDays = @nWorkDays WHERE nID = @nID
							ELSE
								UPDATE  TORequests SET dateEnd = DATEADD(DAY, -1, @StartDate), sOptHolidays= @sOptionalDays, nHelperRequestStatusID = @nCancelStatusID,
										nWorkDays = @nWorkDays WHERE nID = @nID
							SET @nOptDaysInSplit = 0
							SET @sOptionalDays = NULL
							SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @EndDate) AND @dateEnd
							SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @EndDate) AND @dateEnd ORDER BY dOptHolidays FOR XML PATH(''))
							SELECT @nWorkDays = dbo.TOGet_total_working_days(DATEADD(DAY, 1, @EndDate), @dateEnd, @nOptDaysInSplit, @nLocationID)
							IF @nWorkDays > 0
								INSERT INTO TORequests (dateRequested,sRequestor,nRequestTypeID,dateStart,dateEnd,nWorkDays,sComments,nHelperRequestStatusID,sOutlookMeetingID,sOptHolidays,
										nApprovalEscalationLevel,sSubmittedBy,bIsHalfDay,bHalfDayType, bIsEscalated, sEscalationApprover)
								SELECT  dateRequested, sRequestor,nRequestTypeID,DATEADD(DAY, 1, @EndDate),@dateEnd,@nWorkDays
										,sComments,@nHelperRequestStatusID,sOutlookMeetingID,@sOptionalDays,
										nApprovalEscalationLevel,sSubmittedBy,bIsHalfDay,bHalfDayType,bIsEscalated,sEscalationApprover FROM TORequests WHERE nID = @nID
						END
						ELSE
						BEGIN
							SET @IsOverlapCheckPassed = 'false'
							SET @nOverlapReqSplits = -1
							RETURN
						END
					END
					ELSE IF ((@dateStart BETWEEN @StartDate AND @EndDate) AND (@dateEnd > @EndDate))
					BEGIN
						-- shrink the old request's start date to end date + 1, no changes in the new request and add it.
						SET @nOverlapReqSplits = 1
						INSERT INTO @SplitTable SELECT  CONVERT(DATE,Item) FROM dbo.TOSplit(@sOptHoliday , ',')
						SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @EndDate) AND @dateEnd
						SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN DATEADD(DAY, 1, @EndDate) AND @dateEnd ORDER BY dOptHolidays FOR XML PATH(''))
						SELECT @nWorkDays = dbo.TOGet_total_working_days(DATEADD(DAY, 1, @EndDate), @dateEnd, @nOptDaysInSplit, @nLocationID)
						IF @nWorkDays > 0
							UPDATE  TORequests SET dateStart = DATEADD(DAY, 1, @EndDate), sOptHolidays= @sOptionalDays,
									nWorkDays = @nWorkDays WHERE nID = @nID
						ELSE
							UPDATE  TORequests SET dateStart = DATEADD(DAY, 1, @EndDate), sOptHolidays= @sOptionalDays, nHelperRequestStatusID = @nCancelStatusID,
									nWorkDays = @nWorkDays WHERE nID = @nID
					END
					ELSE IF ((@dateEnd BETWEEN @StartDate AND @EndDate) AND (@dateStart < @StartDate))
					BEGIN
						-- shrink the old request's end date to start date - 1, no changes in the new request and add it.
						SET @nOverlapReqSplits = 1
						INSERT INTO @SplitTable SELECT  CONVERT(DATE,Item) FROM dbo.TOSplit(@sOptHoliday , ',')
						SELECT @nOptDaysInSplit = COUNT(dOptHolidays) FROM @SplitTable WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @StartDate)
						SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM  @SplitTable T WHERE dOptHolidays BETWEEN @dateStart AND DATEADD(DAY, -1, @StartDate) ORDER BY dOptHolidays FOR XML PATH(''))
						SELECT @nWorkDays = dbo.TOGet_total_working_days(@dateStart, DATEADD(DAY, -1, @StartDate), @nOptDaysInSplit, @nLocationID)
						IF @nWorkDays > 0
							UPDATE  TORequests SET dateEnd = DATEADD(DAY, -1, @StartDate), sOptHolidays= @sOptionalDays,
								nWorkDays = @nWorkDays  WHERE nID = @nID
						ELSE
							UPDATE  TORequests SET dateEnd = DATEADD(DAY, -1, @StartDate), sOptHolidays= @sOptionalDays, nHelperRequestStatusID = @nCancelStatusID,
								nWorkDays = @nWorkDays  WHERE nID = @nID
					END
					SET @IsOverlapCheckPassed = 'true'
				END
			END
		END
		ELSE
		BEGIN
			SET @IsOverlapCheckPassed = 'true'
			SET @nOverlapReqSplits = -1
		END
	END
	ELSE
	BEGIN
		SET @IsOverlapCheckPassed = 'false'
		SET @nOverlapReqSplits = -1
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCheck_overlapping_request_violation')
	delete from GxQscripts where name = 'TOCheck_overlapping_request_violation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCheck_overlapping_request_violation')
	delete from GXDBVersions where aliasname = 'TOCheck_overlapping_request_violation'
GO

insert into GXDBVersions values(2, 'TOCheck_overlapping_request_violation',  '00010002000200030000', 'TOCheck_overlapping_request_violation', '00010002000200030000')
GO

