

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOCheck_optional_day_violation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOCheck_optional_day_violation.sp,v $ $Id: TOCheck_optional_day_violation.sp,v 1.2.2.2 2018/03/27 09:15:48 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOCheck_optional_day_violation <<<'

IF EXISTS (select * from sysobjects where name='TOCheck_optional_day_violation')
	drop procedure TOCheck_optional_day_violation
IF EXISTS (select * from GxQscripts where name='TOCheck_optional_day_violation')
	delete from GxQscripts where name = 'TOCheck_optional_day_violation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCheck_optional_day_violation')
	delete from GXDBVersions where aliasname = 'TOCheck_optional_day_violation'
GO
print '... Creating Procedure: TOCheck_optional_day_violation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOCheck_optional_day_violation
  @sRequestor NVARCHAR(50),
  @LEPStartDate DATE,
  @LEPEndDate DATE,
  @sOptHoliday NVARCHAR(255),
  @nLocationID INT,
  @bIsHalfDay BIT,
  @nOldReqID INT,
  @dateStart DATE,
  @dateEnd DATE,
  @sOptionalDays NVARCHAR(255)  OUTPUT
,
  @IsOptionalHolidaySuccess BIT OUTPUT
,
  @nOptHolidayInCurrReq INT OUTPUT
AS
BEGIN
	DECLARE @nOptHolidayReqType INT                -- Request type for submitting optional holiday.
	DECLARE @nOptHolidayAllowedForLoc INT = 0         -- No. of optional holiday allowed for that TOLocation.
	DECLARE @nOptHolidayAvailedCount INT = 0           -- Count of optional Holiday Availed.
	DECLARE @nOptHolidaysUsing INT                 -- Count of optional holiday being used in current request.
	DECLARE @nOptDaysInCurrReq INT = 0                  -- Count of optional days in the current request.
	DECLARE @nOptDaysAlreadyAvailedAndInCurReq INT -- Count of optional days in the current request as well as in the already placed request which may need a split up.
	--above has to be taken care for overlapping request being split up and optional TOHolidays may not be porperly checked. Need more thought.
	DECLARE @sOptHolidaysAvailed NVARCHAR(255)
	DECLARE @SplitTable TABLE(dOptHolidays DATE)
	DECLARE @nSubmittedStatusID INT = 1
	DECLARE @nApprovedStatusID INT = 2
	DECLARE @nOptDaysCountInCurReq INT = 0
	DECLARE @nValidOptDaysCountInCurReq INT = 0
	IF NOT (@nOldReqID > 0)
		SET @nOldReqID = -1
	IF  @sOptHoliday IS NULL
	BEGIN
		SET @IsOptionalHolidaySuccess = 'true'
		SET @sOptionalDays = NULL
		RETURN
	END
	IF @bIsHalfDay = 'false'
	BEGIN
		INSERT INTO @SplitTable SELECT  CONVERT(DATE,Item) FROM dbo.TOSplit(@sOptHoliday , ',')
		SELECT @nOptDaysCountInCurReq = COUNT(*) FROM @SplitTable
		SELECT @nValidOptDaysCountInCurReq = COUNT(*) FROM @SplitTable T WHERE T.dOptHolidays BETWEEN @dateStart AND @dateEnd
		IF @nOptDaysCountInCurReq = @nValidOptDaysCountInCurReq
		BEGIN
			SET @nOptHolidayReqType = 15
			--SELECT @nOptHolidayAllowedForLoc = sValue FROM TOGlobal WHERE sName LIKE 'OptHolidayLimit'
			--SELECT @nOptHolidayReqType = sValue FROM TOGlobal WHERE sName LIKE 'OptHolidayReqType'
			DECLARE @nParentLocID INT  = 0
			SELECT @nParentLocID = nParentLocID FROM TOLocation WHERE nID = @nLocationID
			SELECT @nOptHolidayReqType = nID FROM TORequestType WHERE bIsOptionalType = 'true' AND (nLocationID = @nLocationID OR nLocationID = @nParentLocID)
			SELECT @nOptHolidayAllowedForLoc = nMaxAllowed FROM TOLeaveEntitlementPolicy LEP JOIN TORequestType RT ON RT.nEntitlementPolicyID = LEP.nID WHERE RT.nID = @nOptHolidayReqType
			SELECT @sOptHolidaysAvailed = (SELECT sOptHolidays + ',' AS "data()" FROM TORequests
											WHERE (sOptHolidays IS NOT NULL OR nRequestTypeID = @nOptHolidayReqType) AND sRequestor = @sRequestor AND nID <> @nOldReqID
											AND dateStart >= @LEPStartDate AND dateEnd <= @LEPEndDate  AND nHelperRequestStatusID IN (@nSubmittedStatusID, @nApprovedStatusID) FOR XML PATH(''))
			SELECT @nOptHolidayAvailedCount = COUNT(*) FROM dbo.TOSplit(@sOptHolidaysAvailed, ',')
			SELECT @nOptHolidayInCurrReq = COUNT(*) FROM @SplitTable T
			SELECT @nOptDaysInCurrReq = COUNT(*) FROM TOHolidays JOIN @SplitTable T
				ON  T.dOptHolidays BETWEEN dStartDate AND dEndDate WHERE (nLocationID = @nLocationID OR nLocationID = @nParentLocID) AND nIsOptional = 1
			IF @nOptDaysInCurrReq = @nOptHolidayInCurrReq
			BEGIN
				IF ((@nOptHolidayInCurrReq + @nOptHolidayAvailedCount) <= @nOptHolidayAllowedForLoc)
				BEGIN
					SET @IsOptionalHolidaySuccess = 'true'
					SELECT @sOptionalDays = (SELECT CONVERT(NVARCHAR,dOptHolidays) + ',' AS "data()" FROM @SplitTable T ORDER BY dOptHolidays FOR XML PATH(''))
				END
				ELSE
				BEGIN
					SET @IsOptionalHolidaySuccess = 'false'
					SET @sOptionalDays = NULL
					SET @nOptHolidayInCurrReq = -1
				END
			END
			ELSE
			BEGIN
				SET @IsOptionalHolidaySuccess = 'false'
				SET @sOptionalDays = NULL
				SET @nOptHolidayInCurrReq = -2
			END
		END
		ELSE
		BEGIN
			SET @IsOptionalHolidaySuccess = 'false'
			SET @sOptionalDays = NULL
			SET @nOptHolidayInCurrReq = -1
		END
	END
	ELSE
	BEGIN
		SET @IsOptionalHolidaySuccess = 'false'
		SET @sOptionalDays = NULL
		SET @nOptHolidayInCurrReq = -1
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOCheck_optional_day_violation')
	delete from GxQscripts where name = 'TOCheck_optional_day_violation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOCheck_optional_day_violation')
	delete from GXDBVersions where aliasname = 'TOCheck_optional_day_violation'
GO

insert into GXDBVersions values(2, 'TOCheck_optional_day_violation',  '00010002000200020000', 'TOCheck_optional_day_violation', '00010002000200020000')
GO

