

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOApprove_deny_timesheet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOApprove_deny_timesheet.sp,v $ $Id: TOApprove_deny_timesheet.sp,v 1.1.2.3 2018/03/27 08:53:42 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TOApprove_deny_timesheet <<<'

IF EXISTS (select * from sysobjects where name='TOApprove_deny_timesheet')
	drop procedure TOApprove_deny_timesheet
IF EXISTS (select * from GxQscripts where name='TOApprove_deny_timesheet')
	delete from GxQscripts where name = 'TOApprove_deny_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOApprove_deny_timesheet')
	delete from GXDBVersions where aliasname = 'TOApprove_deny_timesheet'
GO
print '... Creating Procedure: TOApprove_deny_timesheet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOApprove_deny_timesheet
  @nID INT,	 
  @sApproverComments NVARCHAR(1024),
  @sAction NVARCHAR(50),
  @sAlias NVARCHAR(50),
  @bReturnCode BIT OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
,
  @empName NVARCHAR(50) OUTPUT
AS
BEGIN
	DECLARE @nApprovedDevyStatus INT = 2
	DECLARE @currentTimesheetStatus INT = 0
	DECLARE @bIsSubmitted INT = 0
	DECLARE @bCanApproveAllTimeOff BIT = 'false'
	DECLARE @sRequestor NVARCHAR(50)
	SELECT @empName = sEmpName FROM TOEmployee WHERE ProdcertName = @sAlias
	IF @sAction = 'approved'
		SET @nApprovedDevyStatus = 2
	ELSE IF @sAction = 'denied'
		SET @nApprovedDevyStatus = 3
	SET NOCOUNT ON;
	--DECLARE @admin NVARCHAR(100) = (SELECT sValue FROM TOGlobal WHERE sName = 'TimesheetAdmin')
	--DECLARE @isTimesheetAdmin BIT =  (SELECT CASE WHEN COUNT(UM.email) > 0 THEN 'true' ELSE 'false' END FROM UMUserGroup UG JOIN UMGroups U
	--										ON UG.groupId = U.id AND U.umdsProviderId = 1
	--									JOIN UMUsers UM
	--										ON UM.id = UG.userId
	--									WHERE U.email = @admin AND CASE WHEN CHARINDEX('\',UM.login, 0) > 0
	--																							 THEN SUBSTRING(UM.login, CHARINDEX('\',UM.login, 0) + 1, LEN(UM.login))
	--																							 ELSE UM.login
	--																				     END = @sAlias)
	DECLARE @isTimesheetAdmin BIT = ( SELECT CASE WHEN COUNT(E.nID) > 0 THEN 'true' ELSE 'false' END
										FROM TOEmployee E LEFT JOIN UMUsers UM WITH(NOLOCK)
											ON E.sEmail = UM.email
										LEFT JOIN UMUserGroup USG WITH(NOLOCK)
											ON  UM.id = USG.userId
										LEFT JOIN UMGroups UG
											ON USG.groupId = UG.id
										JOIN TOUserAccess U
											ON (U.UserName = E.ProdcertName OR U.UserName = UG.email) AND UserAccess = 'TimesheetAdmin'
										WHERE E.ProdcertName = @sAlias)
	IF @isTimesheetAdmin = 'true'
	BEGIN
		SET @bCanApproveAllTimeOff = 'true'
	END
	ELSE
	BEGIN
		SELECT @bCanApproveAllTimeOff = CASE WHEN COUNT(T.nID) > 0 THEN 'true' ELSE 'false' END,
			   @sRequestor = T.sRequestor
		FROM TOTimeSheet T JOIN TOEmployee E
			ON T.sRequestor = E.ProdcertName AND T.nID = @nID
		LEFT JOIN TOTimesheetProxys P
			ON P.sUser = CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END
				AND CONVERT(DATE, GETDATE()) BETWEEN P.dValidFrom AND P.dExpiryDate AND P.bIsDeleted = 0
		WHERE (CASE WHEN CHARINDEX(',', E.Manager, 0) > 0 THEN SUBSTRING(E.Manager, 0 , CHARINDEX(',', E.Manager, 0)) ELSE E.Manager END = @sAlias OR P.sProxy = @sAlias)
			  AND T.sRequestor != @sAlias
		GROUP BY T.nID, T.sRequestor
	END
	IF @bCanApproveAllTimeOff = 'false'
	BEGIN
		SET @bReturnCode = 'false'
		SET @errorMsg = 'Error: you are not authorised to approve/deny time offs'
		RETURN
	END
	ELSE
    	    	BEGIN
		SELECT @currentTimesheetStatus = nHelperTimeSheetStatusId, @bIsSubmitted = bIsSubmitted FROM TOTimeSheet WHERE nID = @nID
		IF ((@currentTimesheetStatus = 1 and @bIsSubmitted = 1 and (@nApprovedDevyStatus = 2 or @nApprovedDevyStatus = 3))  or (@currentTimesheetStatus = 2 and @nApprovedDevyStatus = 3))
		BEGIN
			UPDATE TOTimeSheet SET nHelperTimeSheetStatusId = @nApprovedDevyStatus, sApprovedBy = @sAlias, dateApproved = GETDATE(), sApproverComments = @sApproverComments
			WHERE nID = @nID
			IF @@ROWCOUNT <> 0
			BEGIN
				INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  VALUES('TOTimesheet', @nID, @sAlias, GETDATE(), @sAction + ' Timesheet: ')
				SET @bReturnCode = 'true'
				SET @nID = @@ROWCOUNT
			END
		END
		ELSE
		BEGIN
			SET @bReturnCode = 'false'
			SET @errorMsg = 'Error: Timesheet already processed. No further operations possible.'
			RETURN
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOApprove_deny_timesheet')
	delete from GxQscripts where name = 'TOApprove_deny_timesheet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOApprove_deny_timesheet')
	delete from GXDBVersions where aliasname = 'TOApprove_deny_timesheet'
GO

insert into GXDBVersions values(2, 'TOApprove_deny_timesheet',  '00010001000200030000', 'TOApprove_deny_timesheet', '00010001000200030000')
GO

