

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TOApprove_deny_timeoff.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TOApprove_deny_timeoff.sp,v $ $Id: TOApprove_deny_timeoff.sp,v 1.2.2.4 2020/02/28 15:45:09 isebastian Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TOApprove_deny_timeoff')
BEGIN
	print '>>> Drop Stored Procedure: TOApprove_deny_timeoff <<<'
	drop procedure TOApprove_deny_timeoff
END
IF EXISTS (select * from GxQscripts where name='TOApprove_deny_timeoff')
	delete from GxQscripts where name = 'TOApprove_deny_timeoff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOApprove_deny_timeoff')
	delete from GXDBVersions where aliasname = 'TOApprove_deny_timeoff'
GO
print '... Creating Procedure: TOApprove_deny_timeoff'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TOApprove_deny_timeoff
  @TimeOffs dbo.Approve_Deny_Table READONLY,	 
  @sAction NVARCHAR(50),
  @sAlias NVARCHAR(50),
  @nID INT  OUTPUT
,
  @bReturnCode BIT  OUTPUT
,
  @errorMsg NVARCHAR(255) OUTPUT
AS
BEGIN
	DECLARE @nApprovedDevyStatus INT = 2
	DECLARE @nWorkDays DECIMAL(6,1)
	DECLARE @nApprovalEscalationLevel INT = 0 -- set by default 0 means immediate manager can approve
	DECLARE @IDs TABLE(nID INT, sRequestor NVARCHAR(50))
	DECLARE @nLocationID INT
	DECLARE @nEscalatedCount INT = 0
	DECLARE @Manager NVARCHAR(255)
	DECLARE @bIsManager BIT = 'false'
	DECLARE @nManagerCount INT = 0
	DECLARE @nProxyCount INT = 0
	DECLARE @bIsProxy BIT = 'false'
	DECLARE @ManagerTable TABLE (Manager NVARCHAR(255))
	DECLARE @MyTimeOffApprovals TABLE (nID INT)
	DECLARE @bCanApproveAllTimeOff BIT = 'false'
	IF @sAction = 'approved'
		SET @nApprovedDevyStatus = 2
	ELSE IF @sAction = 'denied'
		SET @nApprovedDevyStatus = 3
	INSERT INTO @MyTimeOffApprovals SELECT nID FROM (SELECT nID, (SELECT * FROM dbo.TOGet_first_manager(Manager, ',')) Manager
									FROM (SELECT R.nID, Manager FROM TORequests R JOIN TOEmployee E
									ON R.sRequestor = E.ProdcertName JOIN @TimeOffs T ON T.nID = R.nID) T1) T WHERE T.Manager = @sAlias
	INSERT INTO @MyTimeOffApprovals SELECT nID FROM (SELECT T.nID, (SELECT * FROM dbo.TOGet_first_manager(Manager, ',')) Manager
									FROM (SELECT R.nID, Manager FROM TORequests R JOIN TOEmployee E ON R.sRequestor = E.ProdcertName JOIN @TimeOffs T ON T.nID = R.nID) T
									JOIN TOProxys ON CONVERT(DATE, GETDATE()) BETWEEN dValidFrom AND dExpiryDate
									AND sUser = CASE WHEN CHARINDEX(',', Manager, 0) > 0 THEN SUBSTRING(Manager, 0 , CHARINDEX(',', Manager, 0)) ELSE Manager END AND  sProxy = @sAlias) T1
	INSERT INTO @MyTimeOffApprovals SELECT R.nID FROM TORequests R JOIN @TimeOffs T ON T.nID = R.nID
									WHERE sEscalationApprover = @sAlias AND R.bIsEscalated = 'true'
	INSERT INTO @MyTimeOffApprovals SELECT R.nID FROM TORequests R JOIN @TimeOffs T ON T.nID = R.nID
									JOIN TOProxys P ON P.sUser = R.sEscalationApprover AND bIsDeleted = 0 AND R.bIsEscalated = 'true'
									AND CONVERT(DATE, GETDATE()) BETWEEN dValidFrom AND dExpiryDate AND sProxy = @sAlias
	SET @bCanApproveAllTimeOff =  (SELECT CASE WHEN COUNT(*) > 0 THEN 'false' ELSE 'true' END FROM @TimeOffs T WHERE T.nID NOT IN (SELECT * FROM @MyTimeOffApprovals GROUP BY nID))
	SET NOCOUNT ON;
	IF @bCanApproveAllTimeOff = 'false'
	BEGIN
		SET @bReturnCode = 'false'
		SET @errorMsg = 'Error: you are not authorised to approve/deny time offs'
		RETURN
	END
	ELSE
    	BEGIN
		INSERT INTO @IDs SELECT R.nID, sRequestor FROM TORequests R JOIN @TimeOffs T ON R.nID = T.nID
		UPDATE TORequests SET nHelperRequestStatusID = @nApprovedDevyStatus, sApprovedBy = @sAlias, dateApproved = GETDATE(), sApproverComments = T.sComments
		FROM TORequests R JOIN @TimeOffs T ON T.nID = R.nID
		IF @@ROWCOUNT <> 0
		BEGIN
			INSERT INTO TOAudit (sTypeName, nTypeID, sUserModified, timeModified, sMessage)  SELECT 'Request', nID, @sAlias, GETDATE(), @sAction + ' Time Off for: ' + sRequestor FROM @IDs
			SET @bReturnCode = 'true'
			SET @nID = @@ROWCOUNT
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TOApprove_deny_timeoff')
	delete from GxQscripts where name = 'TOApprove_deny_timeoff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TOApprove_deny_timeoff')
	delete from GXDBVersions where aliasname = 'TOApprove_deny_timeoff'
GO

insert into GXDBVersions values(2, 'TOApprove_deny_timeoff',  '00010002000200040000', 'TOApprove_deny_timeoff', '00010002000200040000')
GO

