

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_validateAssocCache.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_validateAssocCache.sp,v $ $Id: TM_validateAssocCache.sp,v 1.6.60.1 2017/02/10 20:42:00 sjohnson Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Check if the assoc cache is valid or not if Not mark it dirty
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_validateAssocCache <<<'

IF EXISTS (select * from sysobjects where name='TM_validateAssocCache')
	drop procedure TM_validateAssocCache
IF EXISTS (select * from GxQscripts where name='TM_validateAssocCache')
	delete from GxQscripts where name = 'TM_validateAssocCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_validateAssocCache')
	delete from GXDBVersions where aliasname = 'TM_validateAssocCache'
GO
print '... Creating Procedure: TM_validateAssocCache'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_validateAssocCache
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
	DECLARE @errorCode INT
	DECLARE @errorString varchar(MAX)
	DECLARE @assoCount INT
	DECLARE @OldassoCount INT
	DECLARE @validCache INT
	DECLARE @assoCountStr NVARCHAR(1000)
	SET @validCache = 0
	SET @assoCountStr = (SELECT CAST(value as NVARCHAR(100)) from [GXGlobalParam] where name = 'ScheduleAssocCount')
	SET @OldassoCount = (SELECT CAST(@assoCountStr as INT))
	SET @assoCount = (SELECT count(*) from app_application where (( subclientStatus & 4 ) =  0))   -- CV_STATUS_DELETED
	SET @assoCount = @assoCount + (SELECT count(*) from app_clientGroupAssoc)
--BEGIN TRAN	--START THE TRANSACTION
	if(@assoCount <> @OldassoCount)
	BEGIN
		SET @validCache = 0
UPDATE  [TM_SubTask] SET [flags] = flags - 0x8 --MARK THE SUB TASK THAT THERE IS NO CACHE
		DELETE  TM_AssocEntityCache  --CLEAR THE CACHE
	END
	ELSE
		SET @validCache = 1
	--UPDATE GLOBAL PARAM TABLE WITH NEW ASSOCIATION COUNT
	UPDATE  [GXGlobalParam] SET [value] = CAST(@assoCount as nvarchar(100)) WHERE NAME = 'ScheduleAssocCount'
--COMMIT TRAN
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
--    IF XACT_STATE() <> 0
--    BEGIN
--        ROLLBACK TRANSACTION;
--    END
END CATCH;
SELECT @validCache
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_validateAssocCache')
	delete from GxQscripts where name = 'TM_validateAssocCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_validateAssocCache')
	delete from GXDBVersions where aliasname = 'TM_validateAssocCache'
GO

insert into GXDBVersions values(2, 'TM_validateAssocCache',  '00010006006000010000', 'TM_validateAssocCache', '00010006006000010000')
GO

