

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_setAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_setAlert.sp,v $ $Id: TM_setAlert.sp,v 1.6 2010/03/04 01:17:38 sbonilla Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 04/15/2008
-- Description:	set the alert for give taskId
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_setAlert <<<'

IF EXISTS (select * from sysobjects where name='TM_setAlert')
	drop procedure TM_setAlert
IF EXISTS (select * from GxQscripts where name='TM_setAlert')
	delete from GxQscripts where name = 'TM_setAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_setAlert')
	delete from GXDBVersions where aliasname = 'TM_setAlert'
GO
print '... Creating Procedure: TM_setAlert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_setAlert
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @alertId integer
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
	DECLARE @entities XML
	DECLARE @xmlEntity NVARCHAR(MAX)
	DECLARE @oldTaskId	INTEGER
	DECLARE @oldPolicyId	INTEGER
	DECLARE @taskType	INTEGER
	--DURING UPGRADE ALERTS MAY NOT BE IN TABLE
	IF EXISTS(SELECT * FROM ntnotificationrule WHERE id = @alertId)
	BEGIN
		SET @entities = ( SELECT CAST([xmlEntityList] AS XML) FROM ntnotificationrule WHERE id = @alertId)
		SET @taskType = (SELECT taskType FROM TM_Task WHERE taskId = @i_taskId)
		IF (@taskType <> 4)
		BEGIN
			-- Check if already taskId is associated
			SET @oldTaskId = @entities.value('(/CVGui_CommCellTreeNode/trackingSchedules/schedules/@taskId)[1]', 'int' )
			--Only if @oldTaskId is null insert the taskId in XML Entities
			IF @oldTaskId IS null
			BEGIN
				SET @entities.modify('
				insert <schedules/>
				into (/CVGui_CommCellTreeNode/trackingSchedules)[1]')
				SET @entities.modify('
				insert (attribute taskId {sql:variable("@i_taskId")}
						)
				into (/CVGui_CommCellTreeNode/trackingSchedules[1]/schedules)[1]')
				SET @entities.modify('
				insert (attribute policyId {"0"}
						)
				into (/CVGui_CommCellTreeNode/trackingSchedules[1]/schedules)[1]')
				SET @entities.modify('
				insert (attribute taskType {"0"}
						)
				into (/CVGui_CommCellTreeNode/trackingSchedules[1]/schedules)[1]')
			END
			-- If already a taskId exists replace it with current taskId
			ELSE
			BEGIN
				SET @entities.modify('replace value of (/CVGui_CommCellTreeNode/trackingSchedules/schedules/@taskId)[1] with sql:variable("@i_taskId")')
			END
		END
		ELSE
		BEGIN
			-- Check if already taskId is associated
			SET @oldPolicyId = @entities.value('(/CVGui_CommCellTreeNode/trackingSchedules/schedules/@policyId)[1]', 'int' )
			--Only if @oldTaskId is null insert the taskId in XML Entities
			IF @oldPolicyId IS null
			BEGIN
				SET @entities.modify('
				insert <schedules/>
				into (/CVGui_CommCellTreeNode/trackingSchedules)[1]')
				SET @entities.modify('
				insert (attribute policyId {sql:variable("@i_taskId")}
						)
				into (/CVGui_CommCellTreeNode/trackingSchedules[1]/schedules)[1]')
				SET @entities.modify('
				insert (attribute taskId {"0"}
						)
				into (/CVGui_CommCellTreeNode/trackingSchedules[1]/schedules)[1]')
				SET @entities.modify('
				insert (attribute taskType {"0"}
						)
				into (/CVGui_CommCellTreeNode/trackingSchedules[1]/schedules)[1]')
			END
			-- If already a policyId exists replace it with current policyId
			ELSE
			BEGIN
				SET @entities.modify('replace value of (/CVGui_CommCellTreeNode/trackingSchedules/schedules/@policyId)[1] with sql:variable("@i_taskId")')
			END
		END
		SET @xmlEntity = N'<?xml version="1.0" encoding="UTF-16" standalone="no" ?>' + CAST(@entities AS NVARCHAR(MAX))
		UPDATE ntnotificationrule SET [xmlEntityList] = @xmlEntity WHERE  id = @alertId
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_setAlert')
	delete from GxQscripts where name = 'TM_setAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_setAlert')
	delete from GXDBVersions where aliasname = 'TM_setAlert'
GO

insert into GXDBVersions values(2, 'TM_setAlert',  '00010006000000000000', 'TM_setAlert', '00010006000000000000')
GO

